/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.xjd.XjdRepayDao;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.XjdOrderService;
import com.bcxin.ars.util.HttpGetByJson;
import com.bcxin.ars.xjd.ResultRepay;
import com.bcxin.ars.xjd.XjdOrderSearchDto;
import com.bcxin.ars.xjd.XjdRepay;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class XjdOrderServiceImpl
implements XjdOrderService {
    @Value(value="${XJD_QUERY_URL}")
    private String XJD_QUERY_URL;
    @Autowired
    private UserService userService;
    @Autowired
    private XjdRepayDao xjdRepayDao;

    public void autoGetXjdOrder() throws Exception {
        List users = this.userService.findXjdUserList();
        XjdOrderSearchDto searchDto = new XjdOrderSearchDto();
        searchDto.setPage("1");
        for (User user : users) {
            searchDto.setUserId(user.getXjdUserId());
            String params = JSONObject.toJSON((Object)searchDto).toString();
            String resultjson = HttpGetByJson.sendPostRequest((String)this.XJD_QUERY_URL, (String)params);
            System.out.println(resultjson);
            ResultRepay resultRepay = (ResultRepay)JSONObject.parseObject((String)resultjson, ResultRepay.class);
            if (resultRepay == null || resultRepay.getData() == null || resultRepay.getData().getRepayList() == null || resultRepay.getData().getRepayList().size() <= 0) continue;
            this.xjdRepayDao.deleteByUserId(user.getId().toString());
            List repayList = resultRepay.getData().getRepayList();
            for (XjdRepay xjdRepay : repayList) {
                xjdRepay.setActive(Boolean.valueOf(true));
                xjdRepay.setUserId(user.getId().toString());
                xjdRepay.setXjdUserId(user.getXjdUserId());
                xjdRepay.setCreateTime(new Date());
                xjdRepay.setUpdateTime(new Date());
                this.xjdRepayDao.save(xjdRepay);
            }
        }
    }
}

