/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.UserDaoAop;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.singleLogin.SingleUserDTO;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.LoginLogService;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sys.RegisterpersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class SingleUserLoginBaseServiceImpl
extends BaseService {
    private static Logger logger = LoggerFactory.getLogger(SingleUserLoginBaseServiceImpl.class);
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserDaoAop userDaoAop;
    @Autowired
    private ArsUtil arsUtil;
    @Value(value="${login-timeout}")
    private int loginTimeout = 10;
    @Autowired
    private LoginLogService loginLogService;
    @Autowired
    private RegisterpersonService registerpersonService;

    public abstract User getUserInfo(SingleUserDTO var1);

    public User findByUsername(String userName, String platform) {
        return this.userDao.findByUsername(userName, platform);
    }

    public AjaxResult login(SingleUserDTO userInfo, HttpServletRequest request) {
        User dbUser;
        User u;
        if (request.getSession().getAttribute(Constants.SINGLELOGINBJ_TOKEN) != null) {
            userInfo.setAccessToken(request.getSession().getAttribute(Constants.SINGLELOGINBJ_TOKEN).toString());
        }
        if ((u = this.getUserInfo(userInfo)) == null) {
            throw new ArsException("\u7528\u6237\u4fe1\u606f\u6709\u8bef\uff01");
        }
        if (StringUtil.isNotEmpty((String)u.getUniqueId())) {
            request.getSession().setAttribute(Constants.SINGLELOGINBJ_UNIQUEID, (Object)u.getUniqueId());
        }
        if (StringUtil.isNotEmpty((String)u.getToken())) {
            request.getSession().setAttribute(Constants.SINGLELOGINBJ_TOKEN, (Object)u.getToken());
        }
        if ((dbUser = this.userDao.findByUsername(u.getUsername(), String.valueOf(4))) == null) {
            AjaxResult userAjaxResult = this.registerpersonService.singleUserRegister(u);
            if (!userAjaxResult.isSuccessful()) {
                userAjaxResult.setState(Constants.STATUS_ERROR);
                userAjaxResult.setMsg("\u6ce8\u518c\u5931\u8d25");
                throw new ArsException("\u6ce8\u518c\u5931\u8d25\uff01");
            }
            u.setPassword(u.getPhone().substring(u.getPhone().length() - 6, u.getPhone().length()));
        } else {
            if (StringUtil.isEmpty((String)dbUser.getIdNumber()) || StringUtil.isNotEmpty((String)u.getIdNumber())) {
                if (StringUtil.isEmpty((String)dbUser.getIdNumber())) {
                    dbUser.setIdNumber(u.getIdNumber());
                }
                if (StringUtil.isNotEmpty((String)u.getIdNumber())) {
                    dbUser.setRealname(u.getRealname());
                }
                this.userDao.update(dbUser);
            }
            u = dbUser;
        }
        return this.webLogin(u.getUsername(), u.getPassword(), u.getPlatform(), request);
    }

    public AjaxResult webLogin(String username, String password, Integer platform, HttpServletRequest request) {
        return this.webLogin(username, password, platform, "DA1AFC8A62D75AE0A88B054A7F6667FC", request);
    }

    public AjaxResult webLogin(String username, String password, Integer platform, String host, HttpServletRequest request) {
        AjaxResult result = new AjaxResult();
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(username, password, host);
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            try {
                currentUser.login((AuthenticationToken)token);
            }
            catch (AuthenticationException e) {
                logger.error(e.getMessage(), (Throwable)e);
                result.setSuccessful(false);
                result.setMsg("\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef");
            }
            if (currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                User user = this.userDao.findByUsername(username, platform.toString());
                user.setLoginstate(Integer.valueOf(1));
                if (user.getLoginNum() != null) {
                    user.setLoginNum(Integer.valueOf(user.getLoginNum() + 1));
                } else {
                    user.setLoginNum(Integer.valueOf(1));
                }
                user.setLoginDate(new Date());
                this.userDaoAop.updateLoginState(user);
                user.setSessionId(session.getId().toString());
                user.setCityName("\u5357\u5b81\u5e02");
                user.setCity("450100");
                this.arsUtil.setCurrentUser(user, 120000 * this.loginTimeout);
                result.setData((Object)user);
                result.setSuccessful(true);
                this.loginLogService.logIn(request);
            }
        }
        catch (UnknownAccountException e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setSuccessful(false);
            result.setMsg("\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef");
        }
        catch (IncorrectCredentialsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setSuccessful(false);
            result.setMsg("\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef");
        }
        catch (ExcessiveAttemptsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setSuccessful(false);
            result.setMsg("\u767b\u5f55\u5931\u8d25\u591a\u6b21\uff0c\u8d26\u6237\u9501\u5b9a10\u5206\u949f");
        }
        catch (AuthenticationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return result;
    }
}

