/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityTraincompanyDao;
import com.bcxin.ars.dto.SecurityTraincompanySearchDto;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityTraincompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SecurityTraincompanyService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.webservice.ClientUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SecurityTraincompanyServiceImpl
implements SecurityTraincompanyService {
    @Autowired
    private SecurityTraincompanyDao securityTraincompanyDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ClientUtil clientUtil;

    public SecurityTraincompany findById(long id) {
        return this.securityTraincompanyDao.findById(id);
    }

    public void saveOrUpdate(SecurityTraincompany securityTraincompany) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (securityTraincompany.getId() == null) {
            securityTraincompany.setActive(Boolean.valueOf(true));
            securityTraincompany.setCreateTime(new Date());
            securityTraincompany.setUpdateTime(new Date());
            securityTraincompany.setUpdateBy(currentUser.getUsername());
            this.securityTraincompanyDao.save(securityTraincompany);
        } else {
            SecurityTraincompany dbSecurityTraincompany = this.securityTraincompanyDao.findById(securityTraincompany.getId().longValue());
            dbSecurityTraincompany.setUpdateBy(currentUser.getUsername());
            dbSecurityTraincompany.setUpdateTime(new Date());
            dbSecurityTraincompany.setBardh(securityTraincompany.getBardh());
            dbSecurityTraincompany.setBarq(securityTraincompany.getBarq());
            dbSecurityTraincompany.setBarsfzh(securityTraincompany.getBarsfzh());
            dbSecurityTraincompany.setBarxm(securityTraincompany.getBarxm());
            dbSecurityTraincompany.setBarzw(securityTraincompany.getBarzw());
            dbSecurityTraincompany.setBz1(securityTraincompany.getBz1());
            dbSecurityTraincompany.setBz2(securityTraincompany.getBz2());
            dbSecurityTraincompany.setBz3(securityTraincompany.getBz3());
            dbSecurityTraincompany.setDwbm(securityTraincompany.getDwbm());
            dbSecurityTraincompany.setDwlx(securityTraincompany.getDwlx());
            dbSecurityTraincompany.setDwmc(securityTraincompany.getDwmc());
            dbSecurityTraincompany.setFwlx(securityTraincompany.getFwlx());
            dbSecurityTraincompany.setJgbm(securityTraincompany.getJgbm());
            dbSecurityTraincompany.setJgmc(securityTraincompany.getJgmc());
            dbSecurityTraincompany.setSzdz(securityTraincompany.getSzdz());
            dbSecurityTraincompany.setSzss(securityTraincompany.getSzss());
            dbSecurityTraincompany.setProvince(securityTraincompany.getProvince());
            dbSecurityTraincompany.setCity(securityTraincompany.getCity());
            dbSecurityTraincompany.setDistrict(securityTraincompany.getDistrict());
            this.securityTraincompanyDao.update(dbSecurityTraincompany);
        }
    }

    public SecurityTraincompanySearchDto search(SecurityTraincompanySearchDto dto) {
        SecurityTraincompanySearchDto resultDto = new SecurityTraincompanySearchDto();
        User currentUser = this.arsUtil.getCurrentUser();
        Police police = this.policeDao.findById(currentUser.getOrgid());
        String areacode = police.getAreacode();
        if (areacode.endsWith("0000")) {
            dto.setDistrict(areacode.substring(0, 2) + "____");
        } else if (areacode.endsWith("00")) {
            dto.setDistrict(areacode.substring(0, 4) + "__");
        } else {
            dto.setDistrict(areacode);
        }
        List list = this.securityTraincompanyDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.securityTraincompanyDao.searchCount(dto));
        return resultDto;
    }

    public void delete(SecurityTraincompany securityTraincompany) {
        User currentUser = this.arsUtil.getCurrentUser();
        securityTraincompany.setUpdateBy(currentUser.getUsername());
        securityTraincompany.setUpdateTime(new Date());
        this.securityTraincompanyDao.delete(securityTraincompany);
    }
}

