/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.thread.ThreadUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.CompanyPersonLogDao;
import com.bcxin.ars.dao.OrderDao;
import com.bcxin.ars.dao.OrganizationDao;
import com.bcxin.ars.dao.PersonBaseInfoDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityCompanyDaoAop;
import com.bcxin.ars.dao.SecurityCompanyPersonDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.SecurityPersonDaoAop;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.UserDaoAop;
import com.bcxin.ars.dao.UserRoleDao;
import com.bcxin.ars.dao.certificate.GradeCertificateDao;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dao.task.ComTaskDao;
import com.bcxin.ars.dao.task.ComTaskPerDao;
import com.bcxin.ars.dao.task.UrgentTeamPersonDAO;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.InsPreservationDetailVo;
import com.bcxin.ars.dto.PersonSearchDto;
import com.bcxin.ars.dto.PersonStudyDTO;
import com.bcxin.ars.dto.PersonStudySearchDTO;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.SecurityCompanyPersonDTO;
import com.bcxin.ars.dto.SecurityPersonAppDto;
import com.bcxin.ars.dto.SecurityPersonDTO;
import com.bcxin.ars.dto.SecurityPersonSearchRerurnDTO;
import com.bcxin.ars.dto.UrgentPerson;
import com.bcxin.ars.dto.page.PersonDto;
import com.bcxin.ars.dto.page.PersonPageSearchDto;
import com.bcxin.ars.dto.report.PersonReportData;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Edu;
import com.bcxin.ars.model.Nation;
import com.bcxin.ars.model.Native;
import com.bcxin.ars.model.Order;
import com.bcxin.ars.model.Organization;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityCompanyPerson;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.SecurityProfessionLevel;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.GradeCertificate;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.EduService;
import com.bcxin.ars.service.NationService;
import com.bcxin.ars.service.RoleService;
import com.bcxin.ars.service.SearchHistoryService;
import com.bcxin.ars.service.SecurityCompanyPersonService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityPersonExperienceService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.SecurityProfessionLevelService;
import com.bcxin.ars.service.UserRoleService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.old.BayjbxxService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.Base64Img;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.BuildWebServiceEntity;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.EntityForWebServiceUtil;
import com.bcxin.ars.util.IdNumUtil;
import com.bcxin.ars.util.KeyAndDefauleVal;
import com.bcxin.ars.util.MapDistance;
import com.bcxin.ars.util.MessageUtil;
import com.bcxin.ars.util.Sha1Util;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.ThirdPartyURL;
import com.bcxin.ars.util.message.messageUtils;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.bcxin.ars.util.thread.ThreadPoolManager;
import com.bcxin.ars.webservice.Baycqqkb;
import com.bcxin.ars.webservice.Bayxxb;
import com.bcxin.ars.webservice.ClientUtil;
import com.bcxin.ars.webservice.Zpxxb;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=SecurityPerson.class)
public class SecurityPersonServiceImpl
extends BaseService
implements SecurityPersonService {
    private static Logger logger = LoggerFactory.getLogger(SecurityPersonServiceImpl.class);
    @Autowired
    private SecurityPersonDao personDao;
    @Autowired
    private SecurityPersonDaoAop personDaoAop;
    @Autowired
    private CompanyPersonLogDao companyPersonLogDao;
    @Autowired
    private PersonBaseInfoDao personBaseInfoDao;
    @Autowired
    private EduService eduService;
    @Autowired
    private UrgentTeamPersonDAO urgentTeamPersonDAO;
    @Autowired
    private SearchHistoryService searchHistoryService;
    @Autowired
    private SecurityProfessionLevelService proLevelService;
    @Autowired
    private SecurityCompanyService companyService;
    @Autowired
    private SecurityCompanyPersonService companyPersonService;
    @Autowired
    private SecurityCompanyPersonDao securityCompanyPersonDao;
    @Autowired
    private UserService userService;
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserDaoAop userDaoAop;
    @Autowired
    private UserRoleService userRoleService;
    @Value(value="${ftpServerTemp}")
    private String ftpServerTemp;
    @Value(value="${heiweiPrefixKey}")
    private String heiweiPrefixKey;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private SecurityCompanyDao companyDao;
    @Autowired
    private SecurityCompanyDaoAop companyDaoAop;
    @Autowired
    private ComTaskDao comTaskDao;
    @Autowired
    private ComTaskPerDao comTaskPerDao;
    @Autowired
    private ConfigService configService;
    @Autowired
    private NationService nationService;
    @Autowired
    private OrderDao orderDao;
    @Autowired
    private ClientUtil clientUtil;
    @Autowired
    private BayjbxxService bayjbxxService;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    @Autowired
    private MessageLogDao messageLogDao;
    @Value(value="${temp-folder}")
    private String tempFolder;
    @Value(value="${base-folder}")
    private String baseFolder;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private SecurityCertificateDao securityCertificateDao;
    @Autowired
    private OrganizationDao orgDao;
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private SecurityCompanyPersonDao companyPersonDao;
    @Autowired
    private GradeCertificateDao gradeCertificateDao;
    @Autowired
    private SecurityPersonExperienceService securityPersonExperienceService;
    @Autowired
    private SecurityCertificateService securityCertificateService;

    public SecurityPerson findById(Long id) {
        SecurityPerson result = this.personDao.findById(id);
        if (result != null) {
            result.setComTaskList(this.comTaskDao.findByPerId(result.getId()));
        }
        return result;
    }

    public SecurityPerson findByIdGoodThing(Long id) {
        return this.personDao.findByIdGoodThing(id);
    }

    public void saveOrUpdateHt(SecurityPerson person) {
        if (person.getId() == null) {
            throw new ArsException("\u4fdd\u5b89\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SecurityPerson dbPerson = this.personDao.findById(person.getId());
        if (dbPerson != null) {
            if (person.getHtbh() != null && person.getHtbh() != "") {
                dbPerson.setHtbh(person.getHtbh());
            }
            if (person.getHtenddate() != null) {
                dbPerson.setHtenddate(person.getHtenddate());
            }
            if (person.getHtLife() != null && person.getHtLife() != "") {
                dbPerson.setHtLife(person.getHtLife());
            }
            if (person.getHtstartdate() != null) {
                dbPerson.setHtstartdate(person.getHtstartdate());
            }
            if (person.getHtstate() != null && person.getHtstate() != "") {
                if (person.getHtenddate().getTime() > System.currentTimeMillis()) {
                    dbPerson.setHtstate(person.getHtstate());
                } else {
                    dbPerson.setHtstate("5");
                }
            }
            if (person.getSigndate() != null) {
                dbPerson.setSigndate(person.getSigndate());
            }
            if (person.getEntrydate() != null && person.getEntrydate() != null) {
                dbPerson.setEntrydate(person.getEntrydate());
            }
        } else {
            throw new RuntimeException("\u4fdd\u5b89\u5458\u4e0d\u5b58\u5728\uff0cID:" + person.getId());
        }
        this.personDaoAop.update(dbPerson);
    }

    public void updateCensorStatus(SecurityPerson securityPerson) {
        this.personDaoAop.updateSelective(securityPerson);
    }

    public List<SecurityPerson> findALl(int start, int numPerPage) {
        return this.personDao.findAllBJ(start, numPerPage);
    }

    public void batchUpdateIdentityAuthStateForSaas(List<SecurityPersonDTO> personList) {
        if (CollectionUtil.isEmpty(personList)) {
            return;
        }
        for (SecurityPersonDTO person : personList) {
            person.setUpdateTime(new Date());
        }
        this.personDaoAop.updatePersonidentityAuthStateBatch(personList);
        if ("11".equals(this.configUtils.getCurrentNative())) {
            List list = this.personDao.findByBatchId(personList);
            new Thread(() -> {
                for (SecurityPerson securityPerson : list) {
                    this.oldSecurityCertificate(securityPerson);
                }
            }).start();
        }
    }

    public void updatePersonidentityAuthStateBatchForPhoto(List<SecurityPersonDTO> personList) {
        if (CollectionUtil.isEmpty(personList)) {
            return;
        }
        this.personDaoAop.updatePersonidentityAuthStateBatchForPhoto(personList);
    }

    public void searchForPage(PersonPageSearchDto dto, AjaxPageResponse<PersonDto> page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        String nativePlace = dto.getNativePlace();
        if (StringUtil.isNotEmpty((String)nativePlace)) {
            dto.setNativePlace(this.arsUtil.changeNativePlace(nativePlace));
        }
        page.setData(this.personDao.searchForPage(dto));
        page.setTotal(this.personDao.searchForPageCount(dto).longValue());
    }

    public void searchForReality(PersonPageSearchDto dto, AjaxPageResponse<PersonDto> page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        page.setData(this.personDao.searchForReality(dto));
        page.setTotal(this.personDao.searchForRealityCount(dto).longValue());
    }

    public void searchForFrequently(PersonPageSearchDto dto, AjaxPageResponse<PersonDto> page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.personDao.searchForFrequently(dto, page);
    }

    public static void main(String[] args) {
        SecurityPerson person1 = new SecurityPerson();
        person1.setNation("\u4e2d\u56fd111");
        person1.setArmcertificatejgtime("111111");
        SecurityPerson person2 = new SecurityPerson();
        person2.setNation("\u4e2d\u56fd2222");
        person2.setArmcertificatejgtime("22222");
        person2.setAreacode("640000");
        BeanUtils.copyPropertiesIgnore((Object)person2, (Object)person1, (Boolean)true);
    }

    public void batchUpdateCertificate(List<SecurityPersonDTO> personDTOList) {
        if (CollUtil.isEmpty(personDTOList)) {
            return;
        }
        List securityPersonList = this.personDao.findByBatchId(personDTOList);
        final Map personMap = personDTOList.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        final Vector updateList = new Vector();
        if (CollUtil.isNotEmpty((Collection)securityPersonList)) {
            final CountDownLatch countDownLatch = ThreadUtil.newCountDownLatch((int)securityPersonList.size());
            ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor((int)15, (int)15);
            for (final SecurityPerson person : securityPersonList) {
                threadPoolExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Boolean edit = false;
                            SecurityPersonDTO personDTO = (SecurityPersonDTO)personMap.get(person.getId());
                            if (personDTO == null) {
                                return;
                            }
                            if (StringUtil.isEmpty((String)person.getArmNumber()) && StringUtil.isNotEmpty((String)personDTO.getArmNumber())) {
                                person.setArmNumber(personDTO.getArmNumber());
                                edit = true;
                            }
                            if (StringUtil.isEmpty((String)person.getArmcertificatejgname()) && StringUtil.isNotEmpty((String)personDTO.getArmcertificatejgname())) {
                                person.setArmcertificatejgname(personDTO.getArmcertificatejgname());
                                edit = true;
                            }
                            if (StringUtil.isEmpty((String)person.getArmcertificatejgtime()) && StringUtil.isNotEmpty((String)personDTO.getArmcertificatejgtime())) {
                                person.setArmcertificatejgtime(personDTO.getArmcertificatejgtime());
                                edit = true;
                            }
                            if (StringUtil.isEmpty((String)person.getZgcredential()) && StringUtil.isNotEmpty((String)personDTO.getZgcredential())) {
                                person.setZgcredential(personDTO.getZgcredential());
                                edit = true;
                            }
                            if (StringUtil.isEmpty((String)person.getZgcertificatejgname()) && StringUtil.isNotEmpty((String)personDTO.getZgcertificatejgname())) {
                                person.setZgcertificatejgname(personDTO.getZgcertificatejgname());
                                edit = true;
                            }
                            if (StringUtil.isEmpty((String)person.getZgcertificatejgtime()) && StringUtil.isNotEmpty((String)personDTO.getZgcertificatejgtime())) {
                                person.setZgcertificatejgtime(personDTO.getZgcertificatejgtime());
                                edit = true;
                            }
                            if (StringUtil.isEmpty((String)person.getCredential()) && StringUtil.isNotEmpty((String)personDTO.getCredential())) {
                                person.setCredential(personDTO.getCredential());
                                edit = true;
                            }
                            if (person.getProfessionLevel() == null && personDTO.getProfessionLevel() != null) {
                                person.setProfessionLevel(personDTO.getProfessionLevel());
                                edit = true;
                            }
                            if (StringUtil.isEmpty((String)person.getCertificatejgname()) && StringUtil.isNotEmpty((String)personDTO.getCertificatejgname())) {
                                person.setCertificatejgname(personDTO.getCertificatejgname());
                                edit = true;
                            }
                            if (StringUtil.isEmpty((String)person.getCertificatejgtime()) && StringUtil.isNotEmpty((String)personDTO.getCertificatejgtime())) {
                                person.setCertificatejgtime(personDTO.getCertificatejgtime());
                                edit = true;
                            }
                            if (edit.booleanValue()) {
                                person.setUpdateTime(new Date());
                                updateList.add(person);
                            }
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }
                });
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
                try {
                    throw e;
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            threadPoolExecutor.shutdown();
            if (CollUtil.isNotEmpty(updateList)) {
                this.personDaoAop.batchUpdateCertificate(updateList);
            }
        }
    }

    public void updateIdPhoto(SecurityPerson person) {
        person.setUpdateTime(new Date());
        this.personDaoAop.updateSelective(person);
    }

    public void delIdPhoto(SecurityPerson person) {
        person.setUpdateTime(new Date());
        this.personDaoAop.delIdPhoto(person);
    }

    public void updateIdNumber(SecurityPerson person) {
        person.setUpdateTime(new Date());
        this.personDaoAop.updateSelective(person);
    }

    public PageResult querySercurityPersonList(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.personDao.queryAllCnt(p)), (Object)this.personDao.querySercurityPersonList(p));
    }

    public int getAllCount(Map<Object, Object> p) {
        return this.personDao.queryAllCnt(p);
    }

    public Map getInitCount(Map<Object, Object> p) {
        return this.personDao.queryInitCnt(p);
    }

    public int getNotInitCount(Map<Object, Object> p) {
        return this.personDao.queryNotInitCnt(p);
    }

    public int queryIidentityCnt(Map<Object, Object> p) {
        return this.personDao.queryIidentityCnt(p);
    }

    public int queryNotIidentityCnt(Map<Object, Object> p) {
        return this.personDao.queryNotIidentityCnt(p);
    }

    public int queryLevelCnt(Map<Object, Object> p) {
        return this.personDao.queryLevelCnt(p);
    }

    public int getNewAddCount(Map<Object, Object> p) {
        return this.personDao.queryNewAddCnt(p);
    }

    public void updateGuardStatus(SecurityPerson person) {
        person.setUpdateTime(new Date());
        this.personDaoAop.updateSelective(person);
    }

    public void saveOrUpdate(SecurityPerson person) {
        if (person.getIdNumber() != null && person.getIdNumber().length() > 0) {
            person.setIdNumber(person.getIdNumber().trim().toUpperCase());
        }
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCompany company = null;
        if (currentUser.getPlatform() == 2) {
            company = this.companyDao.findByUserid(currentUser.getId());
        }
        Object existUser = null;
        if (person.getId() == null) {
            SecurityPerson dbPerson = this.personDao.findActiveByIdCard(person.getIdNumber());
            if (dbPerson == null) {
                dbPerson = this.personDao.findActiveByPhone(person.getPhone());
            }
            if (dbPerson != null) {
                if (dbPerson.getRelation() != null && dbPerson.getIncumbencyStatus().equals("1")) {
                    if (dbPerson.getRelation().getCompany().getId().longValue() == company.getId().longValue()) {
                        throw new ArsException("\u8be5\u4eba\u5458\u5df2\u5728\u8d35\u516c\u53f8\u5c31\u804c\uff0c\u4e0d\u9700\u8981\u518d\u6dfb\u52a0\u54e6");
                    }
                    throw new ArsException("\u5f53\u524d\u4eba\u5458\u76ee\u524d\u5728\u804c\uff0c\u4e0d\u5141\u8bb8\u6dfb\u52a0\uff01\u8bf7\u8054\u7cfb\u8be5\u4eba\u5458\u9000\u51fa\u5728\u804c\u516c\u53f8\u4e4b\u540e\u518d\u6dfb\u52a0\uff01");
                }
                this.delete(dbPerson);
            }
            person.setAreacode(company.getAreaCode());
            person.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            person.setNativeCode(this.arsUtil.getCurrentNatvie());
            person.setUpdateBy(currentUser.getRealname());
            person.setUpdateTime(new Date());
            person.setCreateTime(person.getCreateTime());
            person.setIncumbencyStatus("1");
            person.setQualified(Boolean.valueOf(true));
            person.setGuardStatus(Integer.valueOf(3));
            person.setAreacode(company.getAreaCode());
            person.setIdentityAuthState("0");
            if (person.getExp() == null) {
                person.setExp(Integer.valueOf(0));
            }
            if (person.getInsured() == null) {
                person.setInsured("0");
            }
            if (person.getEdu() == null) {
                person.setEdu(Integer.valueOf(4));
            }
            this.personDao.save(person);
            logger.info("update relationship...");
            person.getRelation().setCompany(company);
            person.getRelation().setPerson(person);
            person.getRelation().setActive(Boolean.valueOf(true));
            person.getRelation().setCreateTime(new Date());
            person.getRelation().setUpdateTime(new Date());
            person.getRelation().setNativeCode(company.getNativeCode());
            person.getRelation().setUpdateBy(currentUser.getUsername());
            person.setInsured("0");
            this.companyPersonService.save(person.getRelation());
            String companyId = company.getComId();
            this.companyDaoAop.update(company);
        } else {
            SecurityPerson dbPerson;
            SecurityPerson checkPerson = this.personDao.findActiveByIdCard(person.getIdNumber());
            if (checkPerson == null) {
                checkPerson = this.personDao.findActiveByPhone(person.getPhone());
            }
            if ((dbPerson = this.personDao.findById(person.getId())) != null) {
                dbPerson.setUpdateBy(currentUser.getUsername());
                dbPerson.setUpdateTime(new Date());
                dbPerson.setActive(Boolean.valueOf(true));
                dbPerson.setIncumbencyStatus("1");
                if (person.getAge() != null && person.getAge() > 0) {
                    dbPerson.setAge(person.getAge());
                }
                if (person.getGender() != null && person.getGender().length() > 0) {
                    dbPerson.setGender(person.getGender());
                }
                if (person.getNation() != null && person.getNation().length() > 0) {
                    dbPerson.setNation(person.getNation());
                }
                if (person.getNatives() != null && person.getNatives() > 0) {
                    dbPerson.setNatives(person.getNatives());
                }
                if (person.getStature() != null && person.getStature() > 0) {
                    dbPerson.setStature(person.getStature());
                }
                if (person.getBlood() != null && person.getBlood().length() > 0) {
                    dbPerson.setBlood(person.getBlood());
                }
                if (person.getEdu() != null && person.getEdu() > 0) {
                    dbPerson.setEdu(person.getEdu());
                }
                if (person.getExp() != null && person.getExp() >= 0) {
                    dbPerson.setExp(person.getExp());
                }
                if (person.getIdNumber() != null && person.getIdNumber().length() > 0) {
                    dbPerson.setIdNumber(person.getIdNumber());
                }
                if (person.getIdCardFront() != null && person.getIdCardFront().length() > 0) {
                    dbPerson.setIdCardFront(person.getIdCardFront());
                }
                if (person.getIdCardReverse() != null && person.getIdCardReverse().length() > 0) {
                    dbPerson.setIdCardReverse(person.getIdCardReverse());
                }
                if (person.getResidence() != null && person.getResidence().length() > 0) {
                    dbPerson.setResidence(person.getResidence());
                }
                if (person.getIdCardAddress() != null && person.getIdCardAddress().length() > 0) {
                    dbPerson.setIdCardAddress(person.getIdCardAddress());
                }
                if (person.getCurrentAddress() != null && person.getCurrentAddress().length() > 0) {
                    dbPerson.setCurrentAddress(person.getCurrentAddress());
                }
                if (StringUtil.isNotEmpty((String)person.getDiseasesHistory())) {
                    dbPerson.setDiseasesHistory(person.getDiseasesHistory());
                }
                if (person.getEmergencyContactPerson() != null && person.getEmergencyContactPerson().length() > 0) {
                    dbPerson.setEmergencyContactPerson(person.getEmergencyContactPerson());
                }
                if (person.getEmergencyContactPhone() != null && person.getEmergencyContactPhone().length() > 0) {
                    dbPerson.setEmergencyContactPhone(person.getEmergencyContactPhone());
                }
                dbPerson.setProfessionLevel(person.getProfessionLevel());
                dbPerson.setCredential(person.getCredential());
                if (person.getInsured() != null) {
                    dbPerson.setInsured(person.getInsured());
                }
                if (person.getDrivingLevel() != null && person.getDrivingLevel().length() > 0) {
                    dbPerson.setDrivingLevel(person.getDrivingLevel());
                }
                dbPerson.setArmNumber(person.getArmNumber());
                if (person.getArmStart() != null && person.getArmStart() != null) {
                    dbPerson.setArmStart(person.getArmStart());
                }
                if (person.getArmEnd() != null && person.getArmEnd() != null) {
                    dbPerson.setArmEnd(person.getArmEnd());
                }
                dbPerson.setArmUnit(person.getArmUnit());
                if (person.getEnrolled() != null && person.getEnrolled() != null) {
                    dbPerson.setEnrolled(person.getEnrolled());
                }
                if (person.getEscorted() != null && person.getEscorted() != null) {
                    dbPerson.setEscorted(person.getEscorted());
                }
                if (person.getArmLicence() != null && person.getArmLicence() != null) {
                    dbPerson.setArmLicence(person.getArmLicence());
                }
                if (person.getQualified() != null && person.getQualified() != null) {
                    dbPerson.setQualified(person.getQualified());
                }
                if (person.getUnqualified() != null && person.getUnqualified().length() > 0) {
                    dbPerson.setUnqualified(person.getUnqualified());
                }
                if (person.getStarLevel() != null && person.getStarLevel() > 0) {
                    dbPerson.setStarLevel(person.getStarLevel());
                }
                if (person.getHtbh() != null && person.getHtbh() != "") {
                    dbPerson.setHtbh(person.getHtbh());
                }
                if (person.getHtenddate() != null) {
                    dbPerson.setHtenddate(person.getHtenddate());
                }
                if (person.getHtLife() != null && person.getHtLife() != "") {
                    dbPerson.setHtLife(person.getHtLife());
                }
                if (person.getHtstartdate() != null) {
                    dbPerson.setHtstartdate(person.getHtstartdate());
                }
                if (person.getHtstate() != null && person.getHtstate() != "") {
                    dbPerson.setHtstate(person.getHtstate());
                }
                if (person.getSigndate() != null) {
                    dbPerson.setSigndate(person.getSigndate());
                }
                if (person.getEntrydate() != null && person.getEntrydate() != null) {
                    dbPerson.setEntrydate(person.getEntrydate());
                }
                if (StringUtil.isNotEmpty((String)person.getApplicant_name())) {
                    dbPerson.setApplicant_name(person.getApplicant_name());
                }
                if (StringUtil.isNotEmpty((String)person.getArmcertificatejgname())) {
                    dbPerson.setArmcertificatejgname(person.getArmcertificatejgname());
                }
                if (StringUtil.isNotEmpty((String)person.getArmcertificatejgtime())) {
                    dbPerson.setArmcertificatejgtime(person.getArmcertificatejgtime());
                }
                if (StringUtil.isNotEmpty((String)person.getArmcertificateno())) {
                    dbPerson.setArmcertificateno(person.getArmcertificateno());
                }
                if (StringUtil.isNotEmpty((String)person.getArmtraincompanyname())) {
                    dbPerson.setArmtraincompanyname(person.getArmtraincompanyname());
                }
                if (StringUtil.isNotEmpty((String)person.getArmtraincompanyno())) {
                    dbPerson.setArmtraincompanyno(person.getArmtraincompanyno());
                }
                if (StringUtil.isNotEmpty((String)person.getArmtrainstarttime())) {
                    dbPerson.setArmtrainstarttime(person.getArmtrainstarttime());
                }
                if (StringUtil.isNotEmpty((String)person.getArmtrainendtime())) {
                    dbPerson.setArmtrainendtime(person.getArmtrainendtime());
                }
                if (StringUtil.isNotEmpty((String)person.getArmtraintime())) {
                    dbPerson.setArmtraintime(person.getArmtraintime());
                }
                if (StringUtil.isNotEmpty((String)person.getArmtype())) {
                    dbPerson.setArmtype(person.getArmtype());
                }
                if (StringUtil.isNotEmpty((String)person.getCertificatejgname())) {
                    dbPerson.setCertificatejgname(person.getCertificatejgname());
                }
                if (StringUtil.isNotEmpty((String)person.getCertificatejgno())) {
                    dbPerson.setCertificatejgno(person.getCertificatejgno());
                }
                if (StringUtil.isNotEmpty((String)person.getCertificatejgtime())) {
                    dbPerson.setCertificatejgtime(person.getCertificatejgtime());
                }
                if (StringUtil.isNotEmpty((String)person.getFingerprintsno())) {
                    dbPerson.setFingerprintsno(person.getFingerprintsno());
                }
                if (StringUtil.isNotEmpty((String)person.getGross_premium())) {
                    dbPerson.setGross_premium(person.getGross_premium());
                }
                if (StringUtil.isNotEmpty((String)person.getInception_date())) {
                    dbPerson.setInception_date(person.getInception_date());
                }
                if (StringUtil.isNotEmpty((String)person.getIndustryassociation())) {
                    dbPerson.setIndustryassociation(person.getIndustryassociation());
                }
                if (StringUtil.isNotEmpty((String)person.getIns_count())) {
                    dbPerson.setIns_count(person.getIns_count());
                }
                if (StringUtil.isNotEmpty((String)person.getInsurance_ame())) {
                    dbPerson.setInsurance_ame(person.getInsurance_ame());
                }
                if (StringUtil.isNotEmpty((String)person.getMarriage())) {
                    dbPerson.setMarriage(person.getMarriage());
                }
                if (StringUtil.isNotEmpty((String)person.getNationality())) {
                    dbPerson.setNationality(person.getNationality());
                }
                if (StringUtil.isNotEmpty((String)person.getPlanned_end_date())) {
                    dbPerson.setPlanned_end_date(person.getPlanned_end_date());
                }
                if (StringUtil.isNotEmpty((String)person.getPolitics())) {
                    dbPerson.setPolitics(person.getPolitics());
                }
                if (StringUtil.isNotEmpty((String)person.getProduct_name())) {
                    dbPerson.setProduct_name(person.getProduct_name());
                }
                if (StringUtil.isNotEmpty((String)person.getSfcq())) {
                    dbPerson.setSfcq(person.getSfcq());
                }
                if (StringUtil.isNotEmpty((String)person.getTraincompanyname())) {
                    dbPerson.setTraincompanyname(person.getTraincompanyname());
                }
                if (StringUtil.isNotEmpty((String)person.getTraincompanyno())) {
                    dbPerson.setTraincompanyno(person.getTraincompanyno());
                }
                if (StringUtil.isNotEmpty((String)person.getTraintime())) {
                    dbPerson.setTraintime(person.getTraintime());
                }
                if (StringUtil.isNotEmpty((String)person.getZgcertificatejgname())) {
                    dbPerson.setZgcertificatejgname(person.getZgcertificatejgname());
                }
                if (StringUtil.isNotEmpty((String)person.getZgcertificatejgno())) {
                    dbPerson.setZgcertificatejgno(person.getZgcertificatejgno());
                }
                if (StringUtil.isNotEmpty((String)person.getZgcertificatejgtime())) {
                    dbPerson.setZgcertificatejgtime(person.getZgcertificatejgtime());
                }
                if (StringUtil.isNotEmpty((String)person.getZgcredential())) {
                    dbPerson.setZgcredential(person.getZgcredential());
                }
                if (StringUtil.isNotEmpty((String)person.getZgtraincompanyname())) {
                    dbPerson.setZgtraincompanyname(person.getZgtraincompanyname());
                }
                if (StringUtil.isNotEmpty((String)person.getZgtraincompanyno())) {
                    dbPerson.setZgtraincompanyno(person.getZgtraincompanyno());
                }
                if (StringUtil.isNotEmpty((String)person.getZgtrainendtime())) {
                    dbPerson.setZgtrainendtime(person.getZgtrainendtime());
                }
                if (StringUtil.isNotEmpty((String)person.getZgtrainstarttime())) {
                    dbPerson.setZgtrainstarttime(person.getZgtrainstarttime());
                }
                if (StringUtil.isNotEmpty((String)person.getZgtraintime())) {
                    dbPerson.setZgtraintime(person.getZgtraintime());
                }
                if (StringUtil.isNotEmpty((String)person.getCensorStatus())) {
                    dbPerson.setCensorStatus(person.getCensorStatus());
                }
                if (StringUtil.isNotEmpty((String)person.getPersonType())) {
                    dbPerson.setPersonType(person.getPersonType());
                }
                if (StringUtil.isNotEmpty((String)person.getSocialSecurity())) {
                    dbPerson.setSocialSecurity(person.getSocialSecurity());
                }
                Config coninsConfig = this.configService.findByKey("train_url");
                String path = coninsConfig.getValue() + "train/systemuser/updateByIdentitynumber?identitynumber=" + dbPerson.getIdNumber() + "&truename=" + dbPerson.getRealName() + "&fullname=" + dbPerson.getRealName() + "&certificate=" + dbPerson.getProfessionLevel();
                try {
                    URL url = new URL(path.trim());
                    HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                    if (200 == urlConnection.getResponseCode()) {
                        InputStream is = urlConnection.getInputStream();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        int len = 0;
                        while (-1 != (len = is.read(buffer))) {
                            baos.write(buffer, 0, len);
                            baos.flush();
                        }
                    }
                }
                catch (IOException url) {
                    // empty catch block
                }
                dbPerson.setAreacode(company.getAreaCode());
                this.personDaoAop.update(dbPerson);
                logger.info("update relationship...");
                if (person.getRelation() != null) {
                    SecurityCompanyPerson relation = this.companyPersonService.findByPersonAndCompany(dbPerson.getId(), company.getId());
                    if (relation != null) {
                        if (person.getRelation().getOrg() != null && person.getRelation().getOrg().getId() != null) {
                            relation.setOrg(person.getRelation().getOrg());
                        }
                        relation.setUpdateBy(currentUser.getRealname());
                        relation.setUpdateTime(new Date());
                        relation.setActive(Boolean.valueOf(true));
                        this.companyPersonService.update(relation);
                    } else {
                        person.getRelation().setCompany(company);
                        person.getRelation().setPerson(person);
                        person.getRelation().setActive(Boolean.valueOf(true));
                        person.getRelation().setCreateTime(new Date());
                        person.getRelation().setUpdateTime(new Date());
                        person.getRelation().setUpdateBy(currentUser.getUsername());
                        person.getRelation().setNativeCode(this.arsUtil.getCurrentNatvie());
                        this.companyPersonDao.save(person.getRelation());
                    }
                }
                String string = company.getComId();
            } else {
                throw new RuntimeException("\u4fdd\u5b89\u5458\u4e0d\u5b58\u5728\uff0cID:" + person.getId());
            }
        }
    }

    public void updateBX(SecurityPerson person) {
        person.setUpdateTime(new Date());
        this.personDaoAop.updateSelective(person);
    }

    public void delete(SecurityPerson person) {
        SecurityPerson dbPerson = this.personDao.findById(person.getId());
        SecurityCompanyPerson companyPerson = this.companyPersonService.findSingleByPerson(dbPerson);
        if (companyPerson != null) {
            SecurityCompany company = companyPerson.getCompany();
            companyPerson.setUpdateTime(new Date());
            this.companyPersonService.delete(companyPerson);
            String string = company.getComId();
        }
    }

    public List<SecurityPerson> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.personDao.searchForDataSynchronization(dto);
    }

    public PersonSearchDto search(PersonSearchDto dto) {
        SecurityCompany company;
        User user = this.arsUtil.getCurrentUser();
        if (user.getPlatform() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }
        if (StringUtil.isNotEmpty((String)dto.getKeyword())) {
            this.searchHistoryService.saveOrUpdate(dto.getKeyword(), Constants.SEARCHTYPE_PERSON, user);
        }
        if (user.getPlatform() == 2 && (company = this.companyService.findByUserid(user.getId())) != null) {
            dto.setCompanyId(company.getId());
        }
        List data = this.personDao.search(dto);
        Long count = this.personDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public PersonSearchDto searchForMap(PersonSearchDto dto) {
        User user = this.arsUtil.getCurrentUser();
        if (user.getPlatform() == 1) {
            dto.setNativeCode(user.getNativeCode());
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }
        if (dto.getAreaCode() != null) {
            if (dto.getAreaCode().endsWith("0000")) {
                dto.setAreaCode(dto.getAreaCode().substring(0, 2) + "____");
            } else if (dto.getAreaCode().endsWith("00")) {
                dto.setAreaCode(dto.getAreaCode().substring(0, 4) + "__");
            } else {
                dto.setAreaCode(dto.getAreaCode());
            }
        }
        if (StringUtil.isNotEmpty((String)dto.getKeyword())) {
            this.searchHistoryService.saveOrUpdate(dto.getKeyword(), Constants.SEARCHTYPE_PERSON, user);
        }
        if (user.getPlatform() == 2) {
            SecurityCompany company = this.companyService.findByUserid(user.getId());
            dto.setCompanyId(company.getId());
        }
        List data = this.personDao.searchForMap(dto);
        Long count = this.personDao.searchForMapCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public SecurityPerson findByIdCardAndCompanyId(String idNumber, Long id) {
        return this.personDao.findByIdCardAndCompanyId(idNumber, id);
    }

    public SecurityPerson findByPhoneAndCompanyId(String phone, Long id) {
        return this.personDao.findByPhoneAndCompanyId(phone, id);
    }

    public SecurityPerson findByPhone(String phone) {
        return this.personDao.findByPhone(phone);
    }

    public AjaxResult searchBatch(Long[] personIds) {
        AjaxResult result = new AjaxResult();
        ArrayList<SecurityPerson> listperson = new ArrayList<SecurityPerson>();
        if (personIds != null) {
            for (Long personId : personIds) {
                SecurityPerson person = this.personDao.findById(personId);
                if (!person.getIncumbencyStatus().equals("0")) continue;
                listperson.add(person);
            }
        }
        result.setData(listperson);
        result.setSuccessful(true);
        return result;
    }

    public List<SecurityPerson> searchForExport(PersonPageSearchDto dto) {
        String nativePlace;
        User user = this.arsUtil.getCurrentUser();
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        if (user.getPlatform() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }
        if (StringUtil.isNotEmpty((String)dto.getKeyword())) {
            this.searchHistoryService.saveOrUpdate(dto.getKeyword(), Constants.SEARCHTYPE_PERSON, user);
        }
        if (user.getPlatform() == 2) {
            SecurityCompany company = this.companyService.findByUserid(user.getId());
            dto.setCompanyId(company.getId().toString());
        }
        if (StringUtil.isNotEmpty((String)(nativePlace = dto.getNativePlace()))) {
            if (nativePlace.endsWith("0000")) {
                dto.setNativePlace(nativePlace.substring(0, 2) + "________________");
            } else if (nativePlace.endsWith("00")) {
                dto.setNativePlace(nativePlace.substring(0, 4) + "______________");
            }
        }
        return this.personDao.searchForExport(dto);
    }

    public PersonSearchDto searchForManage(PersonSearchDto dto) {
        User user = this.arsUtil.getCurrentUser();
        if (user.getPlatform() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }
        if (StringUtil.isNotEmpty((String)dto.getKeyword())) {
            this.searchHistoryService.saveOrUpdate(dto.getKeyword(), Constants.SEARCHTYPE_PERSON, user);
        }
        if (user.getPlatform() == 2) {
            SecurityCompany company = this.companyService.findByUserid(user.getId());
            dto.setCompanyId(company.getId());
        }
        List data = this.personDao.searchForManage(dto);
        Long count = this.personDao.searchCountForManage(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public PersonSearchDto searchForPersonInsuredState(PersonSearchDto dto) {
        List data = this.personDao.search(dto);
        Long count = this.personDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public List<ReportData> findLevelReport() {
        SecurityCompany company = this.companyService.getCurrentUserCompany();
        User user = this.arsUtil.getCurrentUser();
        if (user.getPlatform() == 1 && company == null) {
            company = new SecurityCompany();
            company.setPath(user.getPolice().getPath());
            company.setUserid(user.getId());
        }
        return this.personDao.findLevelReport(company);
    }

    public Map<String, String[]> findAgeReport() {
        SecurityCompany company = this.companyService.getCurrentUserCompany();
        HashMap<String, String[]> data = new HashMap<String, String[]>();
        User user = this.arsUtil.getCurrentUser();
        if (user.getPlatform() == 1 && company == null) {
            company = new SecurityCompany();
            company.setPath(user.getPolice().getPath());
            company.setUserid(user.getId());
        }
        List list = this.personDao.findAgeReport(company);
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ReportData rd = (ReportData)list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    public List<ReportData> findGenderReport() {
        User user = this.arsUtil.getCurrentUser();
        SecurityCompany company = this.companyService.getCurrentUserCompany();
        if (user.getPlatform() == 1 && company == null) {
            company = new SecurityCompany();
            company.setPath(user.getPolice().getPath());
            company.setUserid(user.getId());
        }
        return this.personDao.findGenderReport(company);
    }

    public Map<String, String[]> findNativeReport() {
        HashMap<String, String[]> data = new HashMap<String, String[]>();
        SecurityCompany company = this.companyService.getCurrentUserCompany();
        User user = this.arsUtil.getCurrentUser();
        if (user.getPlatform() == 1 && company == null) {
            company = new SecurityCompany();
            company.setPath(user.getPolice().getPath());
            company.setUserid(user.getId());
        }
        List list = this.personDao.findNativeReport(company);
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ReportData rd = (ReportData)list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    public SecurityPersonSearchRerurnDTO findPersonByCompanyIdSearchReturnDTO(SecurityPersonSearchRerurnDTO securityPersonSearchRerurnDTO) {
        SecurityPersonSearchRerurnDTO securityPersonSearch = new SecurityPersonSearchRerurnDTO();
        securityPersonSearch.setData(this.personDao.findByCompanyIdReturnDTO(securityPersonSearchRerurnDTO));
        securityPersonSearch.setTotalCount(this.personDao.countByCompanyIdReturnDTO(securityPersonSearchRerurnDTO));
        return securityPersonSearch;
    }

    public PersonSearchDto searchUrgentPerson(PersonSearchDto dto) {
        User user = this.arsUtil.getCurrentUser();
        if (user == null) {
            return null;
        }
        SecurityCompany company = null;
        if (user.getPlatform() == 2) {
            company = this.companyDao.findByUserid(user.getId());
        }
        if (company != null) {
            dto.setCompanyId(company.getId());
        }
        List data = this.personDao.searchUrgentPerson(dto);
        dto.setData(data);
        return dto;
    }

    public Map<String, String[]> findAbilityReport(Long id) {
        HashMap<String, String[]> data = new HashMap<String, String[]>();
        User user = this.arsUtil.getCurrentUser();
        Map list = this.personDao.findAbilityReport(id);
        String[] name = new String[4];
        String[] value = new String[4];
        String[] limit = new String[4];
        String k = "\u5e74\u9f84";
        name[0] = k + ":" + list.get(k);
        value[0] = list.get(k) + "";
        limit[0] = "60";
        k = "\u5de5\u4f5c\u5e74\u9650";
        name[1] = "\u4ece\u4e8b" + k + ":" + list.get(k) + "\u5e74";
        value[1] = list.get(k) + "";
        limit[1] = "60";
        k = "\u4fdd\u5b89\u7b49\u7ea7";
        name[2] = k + ":" + list.get("level");
        value[2] = list.get(k) + "";
        limit[2] = "5";
        k = "\u5b66\u5386";
        name[3] = k + ":" + list.get("name");
        value[3] = list.get(k) + "";
        limit[3] = "7";
        data.put("name", name);
        data.put("value", value);
        data.put("limit", limit);
        return data;
    }

    public PersonStudyDTO findPersonStudyReport(PersonStudySearchDTO dto) {
        User user = this.arsUtil.getCurrentUser();
        return this.personDao.findPersonStudyReport(dto);
    }

    public List<Long> getAllPersonStudy() {
        return this.personDao.getAllPersonStudy();
    }

    public List<ReportData> findTaskTypeReport(Long id) {
        User user = this.arsUtil.getCurrentUser();
        return this.personDao.findTaskTypeReport(id);
    }

    public Map<String, String[]> findTaskCatalogReport(Long id) {
        HashMap<String, String[]> data = new HashMap<String, String[]>();
        User user = this.arsUtil.getCurrentUser();
        List list = this.personDao.findTaskCatalogReport(id);
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ReportData rd = (ReportData)list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    public List<ReportData> findTaskLevelReport(Long id) {
        User user = this.arsUtil.getCurrentUser();
        return this.personDao.findTaskLevelReport(id);
    }

    public void updateLocation(SecurityPerson person) {
        person.setUpdateTime(new Date());
        this.personDaoAop.updateSelective(person);
    }

    public List<SecurityPerson> findByCompanyId(Long companyId) {
        return this.personDao.findByCompanyId(companyId);
    }

    public List<SecurityPerson> findByCompanyIdForInsurance(Long companyId) {
        return this.personDao.findByCompanyIdForInsurance(companyId);
    }

    public List<SecurityPerson> findByCompanyIdForInsuranceAndCheckId(PersonSearchDto personSearchDto) {
        personSearchDto.setPaging(true);
        Config blbPersonLimitConfig = this.configService.findByKey("BLB_PERSON_LIMIT");
        if (null != blbPersonLimitConfig && null != blbPersonLimitConfig.getValue() && !"".equals(blbPersonLimitConfig.getValue())) {
            personSearchDto.setNumPerPage(Integer.valueOf(Integer.parseInt(blbPersonLimitConfig.getValue())));
        } else {
            personSearchDto.setNumPerPage(Integer.valueOf(500));
        }
        return this.personDao.findByCompanyIdForInsuranceAndCheckId(personSearchDto);
    }

    public Long searchAllCount(PersonSearchDto dto) {
        User user = this.arsUtil.getCurrentUser();
        if (user.getPlatform() == 2) {
            SecurityCompany company = this.companyService.findByUserid(user.getId());
            dto.setCompanyId(company.getId());
        } else {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
            dto.setNativeCode(user.getNativeCode());
        }
        return this.personDao.searchAllCount(dto);
    }

    public List<UrgentPerson> queryUrgentPersonByCompnyId() {
        User user = this.arsUtil.getCurrentUser();
        SecurityCompany company = null;
        if (user.getPlatform() == 2) {
            company = this.companyDao.findByUserid(user.getId());
        }
        if (company == null) {
            throw new RuntimeException("\u5f53\u524d\u767b\u5f55ID\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u516c\u53f8\u4fe1\u606f\uff1aUserid:" + user.getId());
        }
        return this.urgentTeamPersonDAO.queryUrgentPersonByCompnyId(company.getId());
    }

    public void publicAuth(Long id, String photo) {
        User user = this.arsUtil.getCurrentUser();
        SecurityPerson person = this.personDao.findById(id);
        if (person != null) {
            person.setIdentityAuthState("1");
            person.setUpdateTime(new Date());
            this.personDaoAop.updateSelective(person);
            user.setPhoto(photo);
            user.setUpdateTime(new Date());
            this.userService.saveOrUpdate(user, String.valueOf(3));
        }
    }

    public AjaxResult updateCertificate(SecurityPerson person) {
        AjaxResult result = new AjaxResult();
        if (person.getId() == null) {
            throw new ArsException("\u4eba\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SecurityPerson securityPerson = this.personDao.findById(person.getId());
        if (securityPerson == null) {
            throw new ArsException("\u627e\u4e0d\u5230\u4eba\u5458\u4fe1\u606f");
        }
        BeanUtils.copyPropertiesIgnore((Object)person, (Object)securityPerson, (Boolean)true);
        this.personDaoAop.update(securityPerson);
        result.setMsg("\u66f4\u65b0\u6210\u529f");
        result.setSuccessful(true);
        result.setData((Object)person);
        return result;
    }

    public AjaxResult updatePersonInsuredState(SecurityPersonDTO dto) {
        AjaxResult result = new AjaxResult();
        this.personDaoAop.updatePersonInsuredState(dto.getPersons(), dto.getStatus());
        result.setMsg("\u66f4\u65b0\u6210\u529f");
        result.setSuccessful(true);
        return result;
    }

    public AjaxResult batchDelete(Long[] personIds) {
        AjaxResult result = new AjaxResult();
        User user = this.arsUtil.getCurrentUser();
        this.personDaoAop.updateDeletePerson(personIds, new Date(), user.getUsername(), new Date());
        new Thread(() -> {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.comTaskPerDao.updateDeletePerson(personIds);
        }).start();
        result.setSuccessful(true);
        return result;
    }

    public AjaxResult batchAttrition(Long[] personIds) {
        AjaxResult result = new AjaxResult();
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 2) {
            result.setSuccessful(false);
        } else {
            SecurityCompany company = this.companyService.findByUserid(user.getId());
            ArrayList<InsPreservationDetailVo> orders = new ArrayList<InsPreservationDetailVo>();
            if (company.getOrderNo() != null && !"".equals(company.getOrderNo())) {
                String[] ordernos = company.getOrderNo().split(",");
                InsPreservationDetailVo orderVo = null;
                ArrayList<SecurityPerson> listperson = new ArrayList<SecurityPerson>();
                for (Long personId : personIds) {
                    SecurityPerson person = this.personDao.findById(personId);
                    orderVo = new InsPreservationDetailVo();
                    orderVo.setOid(user.getId() + "");
                    orderVo.setId_card(person.getIdNumber());
                    orderVo.setName(person.getRealName());
                    orderVo.setSex(person.getGender());
                    orderVo.setId_type("1");
                    listperson.add(person);
                    orders.add(orderVo);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("vo", orders);
                map.put("orderNo", ordernos[ordernos.length - 1]);
                map.put("webType", "ARS");
                map.put("token", Sha1Util.entryptPassword((String)("ARS" + user.getId())));
                String url = ThirdPartyURL.BAILIANBAO + "/api/order/saveOrderPreservation";
                try {
                    String resultStr = messageUtils.doPost2((String)url, (String)messageUtils.packageMap(map, (String)"ARS"));
                    String status = messageUtils.getStringValueByKey((String)resultStr, (String)"status");
                    if (StringUtil.isNotEmpty((String)status) && "200".equals(status)) {
                        for (SecurityPerson p : listperson) {
                            p.setInsured("0");
                            p.setUpdateTime(new Date());
                            this.personDaoAop.updateSelective(p);
                        }
                        result.setSuccessful(true);
                    } else {
                        result.setSuccessful(false);
                    }
                }
                catch (Exception e) {
                    result.setSuccessful(false);
                }
            }
        }
        return result;
    }

    public void exportPersons(List<SecurityPerson> persons, File file, Map<Long, Native> nativeData) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("\u4eba\u5458\u4fe1\u606f");
            String[] handers = new String[]{"\u90e8\u95e8\u540d\u79f0", "\u59d3\u540d", "\u624b\u673a\u53f7\u7801", "\u8eab\u4efd\u8bc1", "\u6027\u522b", "\u8eab\u9ad8", "\u5b66\u5386", "\u5e74\u9f84", "\u804c\u4e1a\u6c34\u5e73", "\u8bc1\u4e66\u53f7", "\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\u4e66\u53f7", "\u8840\u578b", " \u6c11\u65cf", "\u5bb6\u5ead\u5730\u5740", "\u5c45\u4f4f\u5730\u5740", "\u7c4d\u8d2f", "\u6240\u5c5e\u516c\u53f8", "\u79bb\u804c\u65f6\u95f4"};
            HSSFRow rowFirst = sheet1.createRow(0);
            CellStyle style = ExcelUtil.getCommonTitleStyle((HSSFWorkbook)wb);
            CellStyle stringStyle = ExcelUtil.getStringStyle((HSSFWorkbook)wb);
            for (int i = 0; i < handers.length; ++i) {
                HSSFCell cell = rowFirst.createCell(i);
                sheet1.setColumnWidth(i, 5000);
                sheet1.setDefaultColumnStyle(i, stringStyle);
                cell.setCellStyle(style);
                cell.setCellValue(handers[i]);
            }
            int index = 1;
            HSSFRow row = null;
            Map levels = this.proLevelService.findMap();
            Map edus = this.eduService.findMap();
            for (SecurityPerson person : persons) {
                row = sheet1.createRow(index++);
                HSSFCell orgCell = row.createCell(0);
                orgCell.setCellStyle(style);
                orgCell.setCellValue(person.getRelation() == null || person.getRelation().getOrg() == null ? "" : person.getRelation().getOrg().getName());
                HSSFCell realnameCell = row.createCell(1);
                realnameCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)person.getRealName())) {
                    realnameCell.setCellValue(person.getRealName());
                }
                HSSFCell phoneCell = row.createCell(2);
                phoneCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)person.getPhone())) {
                    phoneCell.setCellValue(person.getPhone());
                }
                HSSFCell idNoCell = row.createCell(3);
                idNoCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)person.getIdNumber())) {
                    idNoCell.setCellValue(person.getIdNumber());
                }
                HSSFCell sexCell = row.createCell(4);
                sexCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)person.getGender())) {
                    sexCell.setCellValue(person.getGender());
                }
                HSSFCell statureCell = row.createCell(5);
                statureCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)person.getStature())) {
                    statureCell.setCellValue((double)person.getStature().intValue());
                }
                HSSFCell eduCell = row.createCell(6);
                eduCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)person.getEdu()) && !StringUtils.isEmpty(edus.get(person.getEdu().longValue()))) {
                    eduCell.setCellValue(((Edu)edus.get(person.getEdu().longValue())).getName());
                }
                HSSFCell ageCell = row.createCell(7);
                ageCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)person.getAge())) {
                    ageCell.setCellValue((double)person.getAge().intValue());
                }
                HSSFCell levelCell = row.createCell(8);
                levelCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)person.getProfessionLevel()) && !StringUtils.isEmpty(levels.get(person.getProfessionLevel()))) {
                    levelCell.setCellValue(((SecurityProfessionLevel)levels.get(person.getProfessionLevel())).getLevel());
                }
                HSSFCell credentialCell = row.createCell(9);
                credentialCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)person.getCredential())) {
                    credentialCell.setCellValue(person.getCredential());
                }
                HSSFCell zgcredentialCell = row.createCell(10);
                zgcredentialCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)person.getZgcredential())) {
                    zgcredentialCell.setCellValue(person.getZgcredential());
                }
                HSSFCell bloodCell = row.createCell(11);
                bloodCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)person.getBlood())) {
                    bloodCell.setCellValue(person.getBlood());
                }
                HSSFCell nationCell = row.createCell(12);
                nationCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)person.getNation())) {
                    nationCell.setCellValue(person.getNation());
                }
                HSSFCell idCardAddressCell = row.createCell(13);
                idCardAddressCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)person.getIdCardAddress())) {
                    idCardAddressCell.setCellValue(person.getIdCardAddress());
                }
                HSSFCell currentAddressCell = row.createCell(14);
                currentAddressCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)person.getCurrentAddress())) {
                    currentAddressCell.setCellValue(person.getCurrentAddress());
                }
                HSSFCell nativesCell = row.createCell(15);
                nativesCell.setCellStyle(style);
                if (!StringUtils.isEmpty((Object)person.getNatives()) && !StringUtils.isEmpty((Object)nativeData.get(person.getNatives().longValue()))) {
                    nativesCell.setCellValue(nativeData.get(person.getNatives().longValue()).getNativeName());
                }
                HSSFCell companynameCell = row.createCell(16);
                companynameCell.setCellStyle(style);
                if (person.getRelation() != null && person.getRelation().getCompany() != null) {
                    companynameCell.setCellValue(person.getRelation().getCompany().getName());
                }
                HSSFCell leaveDateCell = row.createCell(17);
                leaveDateCell.setCellStyle(style);
                if (StringUtils.isEmpty((Object)person.getLeaveDate())) continue;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                leaveDateCell.setCellValue(sdf.format(person.getLeaveDate()));
            }
            FileOutputStream fileOut = new FileOutputStream(file);
            wb.write((OutputStream)fileOut);
            fileOut.close();
            wb.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<SecurityPerson> findUrgentPersons(String latitude, String longitude, Integer scope) {
        Map map = MapDistance.getAround((String)latitude, (String)longitude, (String)(scope + ""));
        PersonSearchDto dto = new PersonSearchDto();
        String minLat = (String)map.get("minLat");
        dto.setMinLat(minLat);
        String maxLat = (String)map.get("maxLat");
        dto.setMaxLat(maxLat);
        String minLng = (String)map.get("minLng");
        dto.setMinLng(minLng);
        String maxLng = (String)map.get("maxLng");
        dto.setMaxLng(maxLng);
        return this.personDao.findUrgentPersons(dto);
    }

    public List<SecurityPerson> findOnlinePersons(String latitude, String longitude, Integer scope) {
        Map map = MapDistance.getAround((String)latitude, (String)longitude, (String)(scope + ""));
        PersonSearchDto dto = new PersonSearchDto();
        String minLat = (String)map.get("minLat");
        dto.setMinLat(minLat);
        String maxLat = (String)map.get("maxLat");
        dto.setMaxLat(maxLat);
        String minLng = (String)map.get("minLng");
        dto.setMinLng(minLng);
        String maxLng = (String)map.get("maxLng");
        dto.setMaxLng(maxLng);
        return this.personDao.findOnlinePersons(dto);
    }

    public AjaxResult checkUserPolicy(Long personId) {
        return null;
    }

    public AjaxResult checkUserPolicy(Long[] personIds) {
        AjaxResult result = new AjaxResult();
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() == 1) {
            result.setSuccessful(false);
            result.setMsg("\u767b\u5f55\u5f02\u5e38");
        } else {
            try {
                JSONArray personArray = new JSONArray();
                for (Long personId : personIds) {
                    SecurityPerson person = this.personDao.findById(personId);
                    if (this.checkUserPolicyFromBLB(person.getId())) continue;
                    JSONObject personObj = new JSONObject();
                    personObj.put("id", (Object)personId);
                    personObj.put("name", (Object)person.getRealName());
                    personArray.add((Object)personObj);
                }
                if (personArray != null && personArray.size() > 0) {
                    result.setSuccessful(false);
                    result.setData((Object)personArray);
                } else {
                    result.setSuccessful(true);
                }
            }
            catch (Exception e) {
                result.setSuccessful(false);
                result.setMsg(e.toString());
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private boolean checkUserPolicyFromBLB(Long personId) {
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() == 1) {
            return false;
        }
        SecurityCompany company = this.companyService.findByUserid(user.getId());
        SecurityPerson person = this.personDao.findById(personId);
        return !person.getInsured().equals("0");
    }

    @Deprecated
    public AjaxResult policy_increased(Long[] personIds) {
        AjaxResult result = new AjaxResult();
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 2) {
            result.setSuccessful(false);
        } else {
            SecurityCompany company = this.companyService.findByUserid(user.getId());
            ArrayList<InsPreservationDetailVo> orders = new ArrayList<InsPreservationDetailVo>();
            if (StringUtil.isNotEmpty((String)company.getOrderNo())) {
                String[] ordernos = company.getOrderNo().split(",");
                InsPreservationDetailVo orderVo = null;
                ArrayList<SecurityPerson> listperson = new ArrayList<SecurityPerson>();
                Config coninsConfig = this.configService.findByKey("train_url");
                for (Long personId : personIds) {
                    SecurityPerson person = this.personDao.findById(personId);
                    orderVo = new InsPreservationDetailVo();
                    orderVo.setOid(user.getId() + "");
                    orderVo.setId_card(person.getIdNumber());
                    orderVo.setName(person.getRealName());
                    orderVo.setSex(person.getGender());
                    orderVo.setId_type("0");
                    Order order = this.orderDao.findByRandomOrderNo(ordernos[ordernos.length - 1]);
                    if (order != null) {
                        Config groupid = this.configService.findByKey("groupid");
                        String groupidValue = "11";
                        if (groupid != null) {
                            groupidValue = groupid.getValue();
                        }
                        String url = coninsConfig.getValue() + "/train/systemuser/addauthtrack" + "?identitynumber=" + person.getIdNumber() + "&groupid=" + groupidValue + "&name=" + person.getRealName() + "&mobile=" + person.getPhone() + "&orderID=" + order.getOrdernumber() + "&startdate=" + order.getEffectivestarttime() + "&enddate=" + order.getEffectiveendtime() + "&companyid=" + company.getId() + "&companyname=" + company.getName();
                        messageUtils.getJsonByInternet((String)url);
                    }
                    listperson.add(person);
                    orders.add(orderVo);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("vo", orders);
                map.put("orderNo", ordernos[ordernos.length - 1]);
                map.put("inceptionDate", DateUtil.getCurrentDate());
                map.put("reviseType", "1");
                map.put("token", Sha1Util.entryptPassword((String)("ARS" + user.getId())));
                String url = ThirdPartyURL.BAILIANBAO + "/api/order/saveOrderPreservation";
                try {
                    String resultStr = messageUtils.doPost2((String)url, (String)messageUtils.packageMap(map, (String)"ARS"));
                    String status = messageUtils.getStringValueByKey((String)resultStr, (String)"status");
                    if (StringUtil.isNotEmpty((String)status) && "200".equals(status)) {
                        result.setSuccessful(true);
                        List returnList = messageUtils.getList((String)resultStr, InsPreservationDetailVo.class, (String)"list");
                        for (InsPreservationDetailVo order : returnList) {
                            SecurityPerson person = this.personDao.findActiveByIdCard(order.getId_card());
                            person.setInsured("1");
                            person.setBxOrderno(ordernos[0]);
                            person.setUpdateTime(new Date());
                            this.personDaoAop.updateSelective(person);
                        }
                    } else {
                        result.setSuccessful(false);
                    }
                }
                catch (Exception e) {
                    result.setSuccessful(false);
                }
            }
        }
        return result;
    }

    public AjaxResult relieveHt(Long personId) {
        AjaxResult result = new AjaxResult();
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() == 1) {
            result.setSuccessful(false);
        } else {
            SecurityPerson person = this.personDao.findById(personId);
            person.setHtstate("3");
            person.setUpdateBy(user.getUsername());
            person.setUpdateTime(new Date());
            this.personDaoAop.update(person);
            result.setSuccessful(true);
        }
        return result;
    }

    public List<PersonStudyDTO> getStudyListDesc(PersonStudySearchDTO dto) {
        return this.personDao.getStudyListDesc(dto);
    }

    public void saveOrUpdateForDS(SecurityPerson securityPerson) {
        SecurityPerson dbSecurityPerson;
        if (securityPerson.getActive() == null) {
            securityPerson.setActive(Boolean.valueOf(true));
        }
        List companyPersonList = securityPerson.getRelationList();
        SecurityCompanyPerson companyPerson = null;
        if (companyPersonList != null) {
            for (SecurityCompanyPerson securityCompanyPerson : companyPersonList) {
                securityCompanyPerson.setPerson(securityPerson);
                if (!securityCompanyPerson.getActive().booleanValue()) continue;
                companyPerson = securityCompanyPerson;
                securityPerson.setRelation(securityCompanyPerson);
            }
        }
        if ((dbSecurityPerson = this.findById(securityPerson.getId())) == null) {
            GradeCertificate gradeCertificate = this.gradeCertificateDao.findByIdNumAndGradeLevel(securityPerson.getIdNumber(), "1");
            if (gradeCertificate != null) {
                if (gradeCertificate.getAppraisalGrade() != null) {
                    securityPerson.setProfessionLevel(gradeCertificate.getAppraisalGrade());
                }
                securityPerson.setCredential(gradeCertificate.getCertificateNo());
                securityPerson.setTraincompanyname(gradeCertificate.getTrainOrgName());
                gradeCertificate.setPersonId(securityPerson.getId());
                this.gradeCertificateDao.updateByPersonId(gradeCertificate);
            }
            this.personDao.save(securityPerson);
            new Thread(() -> {
                try {
                    if (StringUtil.isNotEmpty((String)securityPerson.getArmNumber())) {
                        String[] srccol = new String[]{"idNumber", "armNumber", "armEnd", "armcertificateno", "armcertificatejgname"};
                        String[] desccol = new String[]{"sfzh", "cqzbh", "yxrq", "jgbh", "jgmc"};
                        String[] key = new String[]{"xm", "xb", "ssbags"};
                        String[] value = new String[]{securityPerson.getRealName(), securityPerson.getGender() == "\u7537" ? "1" : "2", securityPerson.getUpdateBy()};
                        Object desc = BuildWebServiceEntity.buildWebServiceEntity((String[])srccol, (String[])desccol, (Object)securityPerson, (Object)new Baycqqkb(), (String[])key, (String[])value);
                        Baycqqkb baycqqkb = (Baycqqkb)desc;
                        this.clientUtil.send("xxba_baycqqkb", (Object)baycqqkb);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }).start();
            new Thread(() -> {
                try {
                    HashMap<String, String> marriage = new HashMap<String, String>();
                    marriage.put("1", "10");
                    marriage.put("2", "20");
                    marriage.put("3", "30");
                    marriage.put("4", "40");
                    marriage.put("9", "90");
                    securityPerson.setMarriage((String)marriage.get(securityPerson.getMarriage()));
                    this.buildWebServiceEntity(securityPerson);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }).start();
            new Thread(() -> {
                try {
                    String photo = securityPerson.getPhoto();
                    if (StringUtil.isNotEmpty((String)photo) && photo.startsWith("getResource.do?path=")) {
                        String fileType = photo.substring(photo.lastIndexOf("."));
                        photo = !"11".equals(this.configUtils.getCurrentNative()) ? Base64Img.encodeBase64File((String)photo, (String)this.baseFolder) : Base64Img.encodeBase64FileBJ((String)photo, (String)this.ftpServerTemp);
                        Zpxxb zpxxb = new Zpxxb();
                        zpxxb.setSfzh(securityPerson.getIdNumber());
                        zpxxb.setZpxx(securityPerson.getIdNumber() + fileType);
                        zpxxb.setZpnr(photo);
                        zpxxb.setZpfl("01");
                        this.clientUtil.send("xxba_zpxxb", (Object)zpxxb);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }).start();
        } else {
            List dbCompanyPersonList;
            boolean censorStatusFlag = false;
            if (companyPerson == null) {
                censorStatusFlag = true;
            } else if (companyPersonList != null && companyPersonList.size() > 0 && (dbCompanyPersonList = this.companyPersonDao.findBatchById(securityPerson.getRelationList())).size() > 0) {
                for (SecurityCompanyPerson securityCompanyPerson : dbCompanyPersonList) {
                    if (companyPerson != null && companyPerson.getId().longValue() != securityCompanyPerson.getId().longValue()) continue;
                    censorStatusFlag = true;
                }
            }
            if (securityPerson.getUpdateTime().getTime() > dbSecurityPerson.getUpdateTime().getTime() || !censorStatusFlag) {
                if (dbSecurityPerson.getIdNumber().equals(securityPerson.getIdNumber()) && censorStatusFlag) {
                    securityPerson.setCensorStatus(dbSecurityPerson.getCensorStatus());
                } else {
                    securityPerson.setCensorStatus(null);
                }
                this.personDaoAop.update(securityPerson);
            }
        }
        this.companyPersonService.saveBatch(companyPersonList);
    }

    private void oldSecurityCertificate(SecurityPerson securityPerson) {
        SecurityCertificate securityCertificate;
        if ("11".equals(this.configUtils.getCurrentNative()) && (securityCertificate = this.securityCertificateDao.findByIdnum(securityPerson.getIdNumber())) != null && Constants.PRINT_TYPE_OLD_YES.equals(securityCertificate.getIsOldData()) && "1".equals(securityPerson.getIdentityAuthState())) {
            if (securityCertificate.getSnapshotId() == null) {
                String photo = this.securityCertificateService.getPhotoUrl(securityCertificate);
                this.securityCertificateService.savePerCerSnapshot(securityCertificate, photo);
                securityCertificate.setUpdateTime(new Date());
                securityCertificate.setUpdateflag(Boolean.valueOf(true));
                this.securityCertificateDao.update(securityCertificate);
            }
            this.securityCertificateService.updateSecurityPersonCertificateInfo(securityCertificate);
        }
    }

    private void buildWebServiceEntity(SecurityPerson person) {
        logger.info("\u4e0a\u62a5\u90e8\u7ea7\u6570\u636e\u3010\u4fdd\u5b89\u5458\u4fe1\u606f\u3011\u2026\u2026");
        Bayxxb bayxxb = new Bayxxb();
        HashMap<String, KeyAndDefauleVal> map = new HashMap<String, KeyAndDefauleVal>();
        map.put("sfzh", new KeyAndDefauleVal("idNumber", null));
        map.put("xm", new KeyAndDefauleVal("realname", (Object)person.getRealName()));
        String gender = IdNumUtil.getSexByIdCard((String)person.getIdNumber());
        map.put("xb", new KeyAndDefauleVal("gender", (Object)(gender.equals("\u7537") ? "1" : "2")));
        map.put("csrq", new KeyAndDefauleVal("idNumber", (Object)IdNumUtil.getBirthByIdCard((String)person.getIdNumber())));
        Nation nation = this.nationService.findByName(person.getNation());
        if (nation != null) {
            map.put("mz", new KeyAndDefauleVal("nation", (Object)nation.getCode()));
        } else {
            map.put("mz", new KeyAndDefauleVal("nation", (Object)"01"));
        }
        map.put("whcd", new KeyAndDefauleVal("edu", (Object)(person.getEdu() != null ? person.getEdu().toString() : "")));
        map.put("zzmm", new KeyAndDefauleVal("politics", null));
        map.put("hj", new KeyAndDefauleVal("natives", (Object)(person.getNatives() != null ? person.getNatives().toString() : "")));
        map.put("xxdz", new KeyAndDefauleVal("idCardAddress", null));
        map.put("hyzk", new KeyAndDefauleVal("marriage", (Object)"90"));
        map.put("byzk", new KeyAndDefauleVal("enrolled", (Object)(person.getEnrolled() != null ? "1" : "0")));
        map.put("sg", new KeyAndDefauleVal("stature", (Object)(person.getStature() != null ? person.getStature().toString() : "")));
        map.put("fzjgbm", new KeyAndDefauleVal("certificatejgno", null));
        map.put("fzjgmc", new KeyAndDefauleVal("certificatejgname", null));
        map.put("fzrq", new KeyAndDefauleVal("certificatejgtime", null));
        map.put("zwxx", new KeyAndDefauleVal("fingerprintsno", null));
        map.put("zpxx", new KeyAndDefauleVal("photo", null));
        map.put("pxdwbm", new KeyAndDefauleVal("traincompanyno", null));
        map.put("baydj", new KeyAndDefauleVal("starLevel", (Object)(person.getStarLevel() != null ? person.getStarLevel().toString() : "")));
        map.put("sflz", new KeyAndDefauleVal("guardStatus", (Object)(person.getGuardStatus() != null ? person.getGuardStatus().toString() : "")));
        map.put("bayzbm", new KeyAndDefauleVal("realname", (Object)""));
        map.put("dxjdjgbm", new KeyAndDefauleVal("realname", (Object)""));
        map.put("dxjdjg", new KeyAndDefauleVal("realname", (Object)""));
        map.put("lrjgbm", new KeyAndDefauleVal("realname", (Object)""));
        map.put("lrjgmc", new KeyAndDefauleVal("realname", (Object)""));
        map.put("lrd", new KeyAndDefauleVal("realname", (Object)""));
        map.put("bz1", new KeyAndDefauleVal("realname", (Object)""));
        map.put("bz2", new KeyAndDefauleVal("realname", (Object)""));
        map.put("bz3", new KeyAndDefauleVal("realname", (Object)""));
        map.put("sfybaz", new KeyAndDefauleVal("realname", (Object)""));
        try {
            EntityForWebServiceUtil.copy(map, (Object)person, (Object)bayxxb);
            this.clientUtil.send("xxba_bayxxb", (Object)bayxxb);
            logger.info("\u4e0a\u62a5\u6210\u529f\u2026\u2026");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Long findUnPolicyByCompanyId(Long companyId) {
        return this.personDao.findUnPolicyByCompanyId(companyId);
    }

    public List<SecurityPerson> searchForTrain(PersonSearchDto dto) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (currentUser == null || currentUser.getPlatform() == 1) {
            return null;
        }
        SecurityCompany company = null;
        if (currentUser.getPlatform() == 2) {
            company = this.companyService.findByUserid(currentUser.getId());
        }
        if (company == null) {
            throw new ArsException("\u516c\u53f8\u4fe1\u606f\u9519\u8bef");
        }
        dto.setCompanyId(company.getId());
        return this.personDao.searchForTrain(dto);
    }

    public List<SecurityPerson> findPersonByCompanyIdAndStatus(Long companyId, String work_status) {
        if ("1".equals(work_status)) {
            return this.personDao.findForUnPolicy(companyId);
        }
        return this.personDao.findPolicyForLeave(companyId);
    }

    public AjaxResult checkPersonStatus(String checkValue) {
        SecurityPerson checkPerson;
        AjaxResult result = new AjaxResult();
        result.setSuccessful(true);
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCompany company = null;
        if (currentUser.getPlatform() == 2) {
            company = this.companyDao.findByUserid(currentUser.getId());
        }
        if ((checkPerson = this.personDao.findActiveByIdCard(checkValue)) == null) {
            checkPerson = this.personDao.findActiveByPhone(checkValue);
        }
        if (checkPerson != null) {
            if (checkPerson.getIncumbencyStatus().equals("1") && checkPerson.getRelation() != null && checkPerson.getRelation().getActive().booleanValue()) {
                if (checkPerson.getRelation().getCompany().getId().longValue() == company.getId().longValue()) {
                    result.setCode("200");
                    result.setMsg("\u8be5\u4eba\u5458\u5df2\u5728\u8d35\u516c\u53f8\u5c31\u804c\uff0c\u4e0d\u9700\u8981\u518d\u6dfb\u52a0\u54e6");
                    result.setSuccessful(false);
                } else {
                    result.setCode("200");
                    result.setMsg("\u5f53\u524d\u4eba\u5458\u76ee\u524d\u5728\u804c\uff0c\u4e0d\u5141\u8bb8\u6dfb\u52a0\uff01\u8bf7\u8054\u7cfb\u8be5\u4eba\u5458\u9000\u51fa\u5728\u804c\u516c\u53f8\u4e4b\u540e\u518d\u6dfb\u52a0\uff01");
                    result.setSuccessful(false);
                }
            } else {
                if (null != checkPerson.getRelation() && checkPerson.getRelation().getCompany().getId().longValue() != company.getId().longValue()) {
                    checkPerson = this.personDao.findByIdCardAndCompanyId(checkValue, company.getId());
                    if (checkPerson == null) {
                        checkPerson = this.personDao.findByPhoneAndCompanyId(checkValue, company.getId());
                    }
                    if (checkPerson == null) {
                        checkPerson = this.personDao.findByIdCard(checkValue);
                        if (checkPerson == null) {
                            checkPerson = this.personDao.findByPhone(checkValue);
                        }
                        if (checkPerson != null) {
                            checkPerson.setId(null);
                        }
                    }
                }
                result.setCode("100");
                result.setMsg("\u5f53\u524d\u4eba\u5458\u5728\u7cfb\u7edf\u4e2d\u5df2\u6709\u8d26\u53f7\uff0c\u4e0d\u9700\u8981\u518d\u65b0\u589e\uff0c\u662f\u5426\u628a\u8be5\u4eba\u5458\u52a0\u5165\u8d35\u516c\u53f8\uff1f");
                result.setSuccessful(true);
                result.setData((Object)checkPerson);
            }
        } else {
            checkPerson = this.personDao.findByIdCardAndCompanyId(checkValue, company.getId());
            if (checkPerson == null) {
                checkPerson = this.personDao.findByPhoneAndCompanyId(checkValue, company.getId());
            }
            if (checkPerson == null) {
                checkPerson = this.personDao.findByIdCard(checkValue);
                if (checkPerson == null) {
                    checkPerson = this.personDao.findByPhone(checkValue);
                }
                if (checkPerson != null) {
                    checkPerson.setId(null);
                }
            }
            if (checkPerson != null) {
                result.setCode("100");
                result.setMsg("\u5f53\u524d\u4eba\u5458\u5728\u7cfb\u7edf\u4e2d\u5df2\u6709\u8d26\u53f7\uff0c\u4e0d\u9700\u8981\u518d\u65b0\u589e\uff0c\u662f\u5426\u628a\u8be5\u4eba\u5458\u52a0\u5165\u8d35\u516c\u53f8\uff1f");
                result.setSuccessful(true);
                result.setData((Object)checkPerson);
            }
        }
        return result;
    }

    public SecurityPerson findByIdCard(String idNumber) {
        return this.personDao.findByIdCard(idNumber);
    }

    public List<SecurityPersonAppDto> findAppByCompanyId(Long companyId) {
        return this.personDao.findAppByCompanyId(companyId);
    }

    public PersonReportData dataStatisticsReport(ReportDataSearchDto searchDto) {
        User currentUser = this.arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areacode);
            }
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        ReportDataSearchDto searchLastWeekDto = new ReportDataSearchDto();
        ReportDataSearchDto searchThisWeekDto = new ReportDataSearchDto();
        ReportDataSearchDto searchLastMonthDto = new ReportDataSearchDto();
        ReportDataSearchDto searchthisMonthDto = new ReportDataSearchDto();
        ReportDataSearchDto searchLastDto = new ReportDataSearchDto();
        searchLastDto.setAreaCode(searchDto.getAreaCode());
        searchLastDto.setPath(currentUser.getPolice().getPath());
        searchLastDto.setUserid(currentUser.getId());
        searchLastWeekDto.setAreaCode(searchDto.getAreaCode());
        searchLastWeekDto.setPath(currentUser.getPolice().getPath());
        searchLastWeekDto.setUserid(currentUser.getId());
        searchLastWeekDto.setType("31");
        searchThisWeekDto.setAreaCode(searchDto.getAreaCode());
        searchThisWeekDto.setPath(currentUser.getPolice().getPath());
        searchThisWeekDto.setUserid(currentUser.getId());
        searchThisWeekDto.setType("3");
        searchLastMonthDto.setAreaCode(searchDto.getAreaCode());
        searchLastMonthDto.setPath(currentUser.getPolice().getPath());
        searchLastMonthDto.setUserid(currentUser.getId());
        searchLastMonthDto.setType("41");
        searchthisMonthDto.setAreaCode(searchDto.getAreaCode());
        searchthisMonthDto.setPath(currentUser.getPolice().getPath());
        searchthisMonthDto.setUserid(currentUser.getId());
        searchthisMonthDto.setType("4");
        if (StringUtil.isNotEmpty((String)searchDto.getType())) {
            if (searchDto.getType().equals("2")) {
                searchLastDto.setType("21");
            } else if (searchDto.getType().equals("3")) {
                searchLastDto.setType("31");
            } else if (searchDto.getType().equals("4")) {
                searchLastDto.setType("41");
            } else if (searchDto.getType().equals("1")) {
                searchLastDto.setType("11");
            }
        }
        Long lastTotal = null;
        Long lastAuthCount = null;
        if (StringUtil.isNotEmpty((String)searchDto.getType()) && !searchDto.getType().equals("100")) {
            lastTotal = this.personDao.dataStatisticsAddReport(searchLastDto);
            lastAuthCount = this.personDao.dataStatisticsAuthReport(searchLastDto);
        }
        PersonReportData data = new PersonReportData();
        Long total = this.personDao.dataStatisticsAddReport(searchDto);
        Long authCount = this.personDao.dataStatisticsAuthReport(searchDto);
        data.setTotal(total);
        data.setAuthCount(authCount);
        if (lastTotal != null && lastAuthCount != null) {
            if (lastTotal > 0L) {
                data.setTotalRate(df.format((double)(total - lastTotal) * 100.0 / (double)lastTotal.longValue()));
            } else if (total < 1L) {
                data.setTotalRate("0");
            } else {
                data.setTotalRate("100");
            }
            if (lastAuthCount > 0L) {
                data.setAuthRate(df.format((double)(authCount - lastAuthCount) * 100.0 / (double)lastAuthCount.longValue()));
            } else if (authCount < 1L) {
                data.setAuthRate("0");
            } else {
                data.setAuthRate("100");
            }
        }
        if (StringUtil.isEmpty((String)searchDto.getType())) {
            Long thisWeekTotal = this.personDao.dataStatisticsAddReport(searchThisWeekDto);
            Long lastWeekTotal = this.personDao.dataStatisticsAddReport(searchLastWeekDto);
            Long thisMonthTotal = this.personDao.dataStatisticsAddReport(searchthisMonthDto);
            Long lastMonthTotal = this.personDao.dataStatisticsAddReport(searchLastMonthDto);
            if (thisWeekTotal == null) {
                thisWeekTotal = 0L;
            }
            if (lastWeekTotal == null) {
                lastWeekTotal = 0L;
            }
            if (thisMonthTotal == null) {
                thisMonthTotal = 0L;
            }
            if (lastMonthTotal == null) {
                lastMonthTotal = 0L;
            }
            data.setThisWeekTotal(thisWeekTotal);
            data.setThisMonthTotal(thisMonthTotal);
            if (lastWeekTotal > 0L) {
                data.setThisWeekRate(df.format((double)(thisWeekTotal - lastWeekTotal) * 100.0 / (double)lastWeekTotal.longValue()));
            } else if (thisWeekTotal < 1L) {
                data.setThisWeekRate("0");
            } else {
                data.setThisWeekRate("100");
            }
            if (thisMonthTotal > 0L) {
                data.setThisMonthRate(df.format((double)(thisMonthTotal - lastMonthTotal) * 100.0 / (double)lastMonthTotal.longValue()));
            } else if (thisWeekTotal < 1L) {
                data.setThisMonthRate("0");
            } else {
                data.setThisMonthRate("100");
            }
        }
        return data;
    }

    public Long[] findUnPolicyPersonIdByCompanyId(Long companyId) {
        return this.personDao.findUnPolicyPersonIdByCompanyId(companyId);
    }

    public SecurityPerson findActiveByIdCard(String idNum) {
        return this.personDao.findActiveByIdCard(idNum);
    }

    public SecurityPerson find(SecurityPerson person) {
        return this.personDao.find(person);
    }

    public void sendNewUserMessage(SecurityPerson person) {
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCompany company = null;
        if (currentUser.getPlatform() == 2) {
            company = this.companyDao.findByUserid(currentUser.getId());
        }
        MessageUtil.sendMessage((String)person.getPhone(), (String)"\u5c0a\u656c\u7684\u7528\u6237\uff0c%COMPANYNAME%\u5df2\u4e3a\u60a8\u5bfc\u5165\u4fe1\u606f\uff0c\u8d26\u53f7\u4e3a\u8eab\u4efd\u8bc1\u53f7\u6216\u624b\u673a\u53f7\uff0c\u521d\u59cb\u5bc6\u7801\u4e3a\uff1abcx123456\uff0c\u8bf7\u5c3d\u5feb\u767b\u5f55\u4fee\u6539\u5bc6\u7801\u3002\u70b9\u51fb http://baibaodun.cn/download.html \u4e0b\u8f7d\u767e\u4fdd\u76fe\u3002".replaceAll("%COMPANYNAME%", company.getName()), (MessageLogDao)this.messageLogDao);
    }

    public void updateBXBatch(List<SecurityPerson> listSecurityPerson) {
        this.personDaoAop.updateBXBatch(listSecurityPerson);
    }

    public List<SecurityPerson> findUnCensor() {
        return this.personDao.findUnCensor();
    }

    public List<SecurityPerson> findReCensor(int backGroupFrequency) {
        return this.personDao.findReCensor(backGroupFrequency);
    }

    public List<SecurityPerson> findNoPassCensorStatus() {
        return this.personDao.findNoPassCensorStatus();
    }

    public List<SecurityPerson> findUnCensorForTest() {
        return this.personDao.findUnCensorForTest();
    }

    public SecurityPerson findActiveByPhone(String phone) {
        return this.personDao.findActiveByPhone(phone);
    }

    public AjaxResult batchAdjDeptForSaas(List<String> perIds, Long deptId) {
        AjaxResult result = new AjaxResult();
        String persons = "";
        User currentUser = this.arsUtil.getCurrentUser();
        Date date = new Date();
        SecurityCompany company = this.companyDao.findByUserid(currentUser.getId());
        if (deptId == null || deptId <= 0L) {
            Organization dborg = this.orgDao.findByCompanyWithSaasSpecial(company.getId());
            if (null == dborg) {
                dborg = new Organization();
                dborg.setName("\u65e0\u90e8\u95e8\u4eba\u5458");
                dborg.setCompany(company);
                dborg.setActive(Boolean.valueOf(true));
                dborg.setCreateTime(new Date());
                dborg.setUpdateTime(new Date());
                dborg.setUpdateBy(currentUser.getUsername());
                dborg.setNativeCode(currentUser.getNativeCode());
                dborg.setIsSaasSpecial("1");
                this.orgDao.save(dborg);
            }
            deptId = dborg.getId();
        }
        if (perIds.size() > 0 && null != deptId) {
            ArrayList<SecurityCompanyPersonDTO> relationList = new ArrayList<SecurityCompanyPersonDTO>();
            for (String perId : perIds) {
                persons = persons + perId;
                SecurityPersonDTO person = new SecurityPersonDTO();
                person.setId(Long.valueOf(Long.parseLong(perId)));
                SecurityCompanyPerson relation = this.companyPersonService.findByPersonAndCompany(person.getId(), company.getId());
                if (relation != null) {
                    SecurityCompanyPersonDTO securityCompanyPersonDTO = new SecurityCompanyPersonDTO();
                    BeanUtils.copyPropertiesIgnore((Object)relation, (Object)securityCompanyPersonDTO, (Boolean)true);
                    securityCompanyPersonDTO.setCompanyId(company.getId());
                    securityCompanyPersonDTO.setOrgId(deptId);
                    securityCompanyPersonDTO.setPersonId(person.getId());
                    securityCompanyPersonDTO.setUpdateBy(currentUser.getRealname());
                    securityCompanyPersonDTO.setUpdateTime(date);
                    relationList.add(securityCompanyPersonDTO);
                    continue;
                }
                SecurityCompanyPersonDTO newRelation = new SecurityCompanyPersonDTO();
                newRelation.setCompanyId(company.getId());
                newRelation.setPersonId(person.getId());
                newRelation.setNativeCode(currentUser.getNativeCode());
                newRelation.setActive(Boolean.valueOf(true));
                newRelation.setOrgId(deptId);
                newRelation.setCreateTime(date);
                newRelation.setUpdateTime(date);
                newRelation.setUpdateBy(currentUser.getUsername());
                relationList.add(newRelation);
            }
            if (relationList.size() > 0) {
                this.securityCompanyPersonDao.updateBatch(relationList);
                result.setMsg("\u66f4\u65b0\u6210\u529f");
                result.setData((Object)("\u66f4\u65b0\u4e2a\u6570\uff1a" + relationList.size() + "\uff0c\u66f4\u65b0\u4eba\u5458Id\uff1a" + persons + "\uff0c\u66f4\u65b0\u90e8\u95e8Id\uff1a" + deptId));
                result.setSuccessful(true);
            } else {
                result.setMsg("\u6ca1\u6709\u66f4\u65b0\u5185\u5bb9");
                result.setData(perIds);
                result.setSuccessful(false);
            }
        }
        return result;
    }

    public AjaxResult batchSaveOrUpdateForSaas(List<SecurityPersonDTO> personDTOList) {
        AjaxResult result = new AjaxResult();
        if (personDTOList.size() > 0) {
            final ArrayList<String> idNnums = new ArrayList<String>();
            User currentUser = this.arsUtil.getCurrentUser();
            Date date = new Date();
            SecurityCompany company = this.companyDao.findByUserid(currentUser.getId());
            List dbExistPersonList = this.personDao.findByBatchId(personDTOList);
            Map<Object, Object> dbExistPersonMap = new HashMap();
            if (dbExistPersonList.size() > 0) {
                dbExistPersonMap = dbExistPersonList.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
            }
            ArrayList<SecurityPersonDTO> dbNoExistPersonList = new ArrayList<SecurityPersonDTO>();
            ArrayList<Object> dbExistList = new ArrayList<Object>();
            ArrayList<SecurityCompanyPersonDTO> relationList = new ArrayList<SecurityCompanyPersonDTO>();
            for (SecurityPersonDTO securityPerson : personDTOList) {
                SecurityPerson dbPerson;
                securityPerson.setRealName(securityPerson.getRealname());
                if (StringUtil.isNotEmpty((String)securityPerson.getIdNumber())) {
                    securityPerson.setNatives(Integer.valueOf(Integer.parseInt(securityPerson.getIdNumber().substring(0, 6))));
                    securityPerson.setAge(Integer.valueOf(IdNumUtil.getAgeByIdCard((String)securityPerson.getIdNumber())));
                    securityPerson.setGender(IdNumUtil.getGenderByIdCard((String)securityPerson.getIdNumber()));
                }
                if (securityPerson.getId() == null) {
                    throw new ArsException("\u4fdd\u5b89\u4eba\u5458\u4fe1\u606f\u9519\u8bef\uff0c\u7f3a\u5931id!");
                }
                if (StringUtil.isNotEmpty((String)securityPerson.getPhoto())) {
                    securityPerson.setPhoto(this.getPhotoPath(securityPerson.getPhoto()));
                }
                if ((dbPerson = (SecurityPerson)dbExistPersonMap.get(securityPerson.getId())) == null) {
                    idNnums.add(securityPerson.getIdNumber());
                    dbNoExistPersonList.add(securityPerson);
                } else {
                    BeanUtils.copyPropertiesIgnore((Object)securityPerson, (Object)dbPerson, (Boolean)true);
                    dbPerson.setUpdateBy(currentUser.getUsername());
                    dbPerson.setUpdateTime(date);
                    dbPerson.setActive(Boolean.valueOf(true));
                    dbPerson.setIncumbencyStatus("1");
                    dbPerson.setLeaveDate(null);
                    dbPerson.setAreacode(company.getAreaCode());
                    if (StringUtil.isNotEmpty((String)securityPerson.getIdNumber()) && !securityPerson.getIdNumber().equals(dbPerson.getIdNumber())) {
                        dbPerson.setZgcertificatejgname(null);
                        dbPerson.setZgcertificatejgno(null);
                        dbPerson.setZgcertificatejgtime(null);
                        dbPerson.setZgcredential(null);
                        dbPerson.setProfessionLevel(null);
                        dbPerson.setCredential(null);
                        dbPerson.setZgcertificatejgtime(null);
                        dbPerson.setTraincompanyname(null);
                        if (StringUtil.isNotEmpty((String)dbPerson.getIdNumber())) {
                            idNnums.add(dbPerson.getIdNumber());
                        }
                        idNnums.add(securityPerson.getIdNumber());
                    }
                    dbExistList.add(dbPerson);
                }
                SecurityCompanyPerson relation = this.companyPersonService.findSingleByPerson((SecurityPerson)securityPerson);
                logger.info("update relationship...");
                boolean editRelation = true;
                if (relation == null) {
                    relation = new SecurityCompanyPerson();
                    relation.setCompany(company);
                    relation.setPerson((SecurityPerson)securityPerson);
                    relation.setCreateTime(date);
                } else if (securityPerson.getDeptId() != null && securityPerson.getDeptId().longValue() == relation.getOrg().getId().longValue()) {
                    editRelation = false;
                } else if ("1".equals(relation.getOrg().getIsSaasSpecial())) {
                    editRelation = false;
                }
                if (securityPerson.getEntrydate() != null) {
                    relation.setEntryDate(securityPerson.getEntrydate());
                }
                if (!editRelation) continue;
                Organization org = new Organization();
                if (securityPerson.getDeptId() != null) {
                    org.setId(securityPerson.getDeptId());
                    relation.setOrg(org);
                } else {
                    Organization dborg = this.orgDao.findByCompanyWithSaasSpecial(company.getId());
                    if (null == dborg) {
                        org.setName("\u65e0\u90e8\u95e8\u4eba\u5458");
                        org.setCompany(company);
                        org.setActive(Boolean.valueOf(true));
                        org.setCreateTime(new Date());
                        org.setUpdateTime(new Date());
                        org.setUpdateBy(currentUser.getUsername());
                        org.setNativeCode(currentUser.getNativeCode());
                        org.setIsSaasSpecial("1");
                        this.orgDao.save(org);
                        relation.setOrg(org);
                    } else {
                        relation.setOrg(dborg);
                    }
                }
                SecurityCompanyPersonDTO relationDto = new SecurityCompanyPersonDTO();
                BeanUtils.copyPropertiesIgnore((Object)relation, (Object)relationDto, (Boolean)true);
                relationDto.setCompanyId(company.getId());
                relationDto.setOrgId(relation.getOrg().getId());
                relationDto.setPersonId(securityPerson.getId());
                relationDto.setUpdateBy(currentUser.getRealname());
                relationDto.setNativeCode(company.getNativeCode());
                relationDto.setUpdateTime(date);
                relationDto.setActive(Boolean.valueOf(true));
                relationList.add(relationDto);
            }
            if (dbNoExistPersonList.size() > 0) {
                for (SecurityPersonDTO person : dbNoExistPersonList) {
                    person.setAreacode(company.getAreaCode());
                    person.setNativeCode(currentUser.getNativeCode());
                    person.setUpdateBy(currentUser.getRealname());
                    person.setUpdateTime(date);
                    person.setCreateTime(new Date());
                    person.setIncumbencyStatus("1");
                    person.setQualified(Boolean.valueOf(true));
                    person.setGuardStatus(Integer.valueOf(3));
                    person.setActive(Boolean.valueOf(true));
                    if (person.getExp() == null) {
                        person.setExp(Integer.valueOf(0));
                    }
                    if (person.getInsured() == null) {
                        person.setInsured("0");
                    }
                    if (person.getEdu() == null) {
                        person.setEdu(Integer.valueOf(4));
                    }
                    dbExistList.add(person);
                }
            }
            this.personDaoAop.updateBatch(dbExistList);
            if (relationList.size() > 0) {
                this.securityCompanyPersonDao.updateBatch(relationList);
            }
            if (idNnums != null && idNnums.size() > 0) {
                ThreadPoolManager threadPoolManager = ThreadPoolManager.newInstance();
                threadPoolManager.addExecuteTask(new Runnable(){

                    @Override
                    public void run() {
                        SecurityPersonServiceImpl.this.securityCertificateDao.updatePushState(idNnums, false);
                        SecurityPersonServiceImpl.this.gradeCertificateDao.updatePushState(idNnums, false);
                    }
                });
            }
        }
        return result;
    }

    public void changePersonPhone(SecurityPersonDTO person) {
        SecurityPerson dbPerson = this.personDao.findById(person.getId());
        if (dbPerson == null) {
            throw new ArsException("\u4fdd\u5b89\u4eba\u5458\u4fe1\u606f\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u8be5\u4eba\u5458!");
        }
        dbPerson.setPhone(person.getPhone());
        this.personDaoAop.updateSelective(dbPerson);
    }

    public void saveOrUpdateForSaas(SecurityPersonDTO person, SecurityCompany company) {
        final ArrayList<String> idNnums = new ArrayList<String>();
        if (StringUtil.isNotEmpty((String)person.getIdNumber())) {
            person.setIdNumber(person.getIdNumber().toUpperCase().trim());
            person.setNatives(Integer.valueOf(Integer.parseInt(person.getIdNumber().substring(0, 6))));
            person.setAge(Integer.valueOf(IdNumUtil.getAgeByIdCard((String)person.getIdNumber())));
            person.setGender(IdNumUtil.getGenderByIdCard((String)person.getIdNumber()));
        }
        if (person.getId() == null) {
            throw new ArsException("\u4fdd\u5b89\u4eba\u5458\u4fe1\u606f\u9519\u8bef\uff0c\u7f3a\u5931id!");
        }
        Date date = new Date();
        User currentUser = this.arsUtil.getCurrentUser();
        if (company == null) {
            if (2 == currentUser.getPlatform()) {
                company = this.companyDao.findByUserid(currentUser.getId());
            }
        } else {
            currentUser = company.getUser();
        }
        if (StringUtil.isNotEmpty((String)person.getPhoto())) {
            person.setPhoto(this.getPhotoPath(person.getPhoto()));
        }
        if (StringUtil.isNotEmpty((String)person.getIdPhoto())) {
            person.setIdPhoto(this.getPhotoPath(person.getIdPhoto()));
        }
        SecurityPerson dbPerson = this.personDao.findById(person.getId());
        SecurityCompanyPerson relation = null;
        if (dbPerson != null) {
            dbPerson.setUpdateBy(currentUser.getUsername());
            dbPerson.setUpdateTime(date);
            dbPerson.setActive(Boolean.valueOf(true));
            dbPerson.setIncumbencyStatus("1");
            if (StringUtil.isNotEmpty((String)person.getIdNumber()) && !person.getIdNumber().equals(dbPerson.getIdNumber())) {
                dbPerson.setZgcertificatejgname(null);
                dbPerson.setZgcertificatejgno(null);
                dbPerson.setZgcertificatejgtime(null);
                dbPerson.setZgcredential(null);
                dbPerson.setProfessionLevel(null);
                dbPerson.setCredential(null);
                dbPerson.setZgcertificatejgtime(null);
                dbPerson.setTraincompanyname(null);
                if (StringUtil.isNotEmpty((String)dbPerson.getIdNumber())) {
                    idNnums.add(dbPerson.getIdNumber());
                }
                idNnums.add(person.getIdNumber());
            }
            BeanUtils.copyPropertiesIgnore((Object)person, (Object)dbPerson, (Boolean)true);
            relation = this.companyPersonService.findSingleByPerson(dbPerson);
            dbPerson.setAreacode(company.getAreaCode());
            dbPerson.setLeaveDate(null);
            this.personDaoAop.update(dbPerson);
        } else {
            person.setCreateTime(new Date());
            person.setAreacode(company.getAreaCode());
            person.setNativeCode(currentUser.getNativeCode());
            person.setUpdateBy(currentUser.getRealname());
            person.setUpdateTime(date);
            person.setCreateTime(person.getCreateTime());
            person.setIncumbencyStatus("1");
            person.setQualified(Boolean.valueOf(true));
            person.setGuardStatus(Integer.valueOf(3));
            person.setActive(Boolean.valueOf(true));
            if (person.getExp() == null) {
                person.setExp(Integer.valueOf(0));
            }
            if (person.getInsured() == null) {
                person.setInsured("0");
            }
            if (person.getEdu() == null) {
                person.setEdu(Integer.valueOf(4));
            }
            this.personDao.save((SecurityPerson)person);
            dbPerson = person;
            idNnums.add(person.getIdNumber());
        }
        logger.info("update relationship...");
        boolean editRelation = true;
        if (relation == null) {
            relation = new SecurityCompanyPerson();
            relation.setCreateTime(new Date());
            relation.setCompany(company);
            relation.setPerson((SecurityPerson)person);
        } else if (person.getDeptId() != null && person.getDeptId().longValue() == relation.getOrg().getId().longValue()) {
            editRelation = false;
        } else if ("1".equals(relation.getOrg().getIsSaasSpecial())) {
            editRelation = false;
        }
        if (person.getEntrydate() != null) {
            relation.setEntryDate(person.getEntrydate());
        }
        if (editRelation) {
            Organization org = new Organization();
            if (person.getDeptId() != null) {
                org.setId(person.getDeptId());
                relation.setOrg(org);
            } else {
                Organization dborg = this.orgDao.findByCompanyWithSaasSpecial(company.getId());
                if (null == dborg) {
                    org.setName("\u65e0\u90e8\u95e8\u4eba\u5458");
                    org.setCompany(company);
                    org.setActive(Boolean.valueOf(true));
                    org.setCreateTime(new Date());
                    org.setUpdateTime(new Date());
                    org.setUpdateBy(currentUser.getUsername());
                    org.setNativeCode(currentUser.getNativeCode());
                    org.setIsSaasSpecial("1");
                    this.orgDao.save(org);
                    relation.setOrg(org);
                } else {
                    relation.setOrg(dborg);
                }
            }
            relation.setUpdateBy(currentUser.getRealname());
            relation.setNativeCode(company.getNativeCode());
            relation.setUpdateTime(date);
            relation.setActive(Boolean.valueOf(true));
            if (relation.getId() == null) {
                this.companyPersonService.save(relation);
            } else {
                this.companyPersonService.update(relation);
            }
            if (idNnums != null && idNnums.size() > 0) {
                ThreadPoolManager threadPoolManager = ThreadPoolManager.newInstance();
                threadPoolManager.addExecuteTask(new Runnable(){

                    @Override
                    public void run() {
                        SecurityPersonServiceImpl.this.securityCertificateDao.updatePushState(idNnums, false);
                        SecurityPersonServiceImpl.this.gradeCertificateDao.updatePushState(idNnums, false);
                    }
                });
            }
        }
    }

    public PageResult searchPersonList_table(Map<Object, Object> p) {
        User user = this.arsUtil.getCurrentUser();
        if (user.getPlatform() == 1) {
            p.put("nativeCode", user.getNativeCode());
            p.put("path", user.getPolice().getPath());
            p.put("userId", user.getId());
        }
        if (p.get("areaCode") != null) {
            if (p.get("areaCode").toString().endsWith("0000")) {
                p.put("areaCode", p.get("areaCode").toString().substring(0, 2) + "____");
            } else if (p.get("areaCode").toString().endsWith("00")) {
                p.put("areaCode", p.get("areaCode").toString().substring(0, 4) + "__");
            } else {
                p.put("areaCode", p.get("areaCode").toString());
            }
        }
        if (null != p.get("keyword") && StringUtil.isNotEmpty((String)p.get("keyword").toString())) {
            this.searchHistoryService.saveOrUpdate(p.get("keyword").toString(), Constants.SEARCHTYPE_PERSON, user);
        }
        if (user.getPlatform() == 2) {
            SecurityCompany company = this.companyService.findByUserid(user.getId());
            p.put("companyId", company.getId());
        }
        return new PageResult(Integer.valueOf(this.personDao.queryAllCntPersonListtable(p)), (Object)this.personDao.queryPersonListtable(p));
    }

    public void refreshPersonCensorStatus() {
        this.personDao.refreshPersonCensorStatus();
    }

    public void refreshPersonCensorCriminalStatus() {
        this.personDao.refreshPersonCensorCriminalStatus();
    }

    public Map<String, Object> countNewOldSystemPerson(PersonPageSearchDto dto) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Long oldCount = this.personDao.searchForPageForOldCount(dto);
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        Long newCount = this.personDao.searchForPageForNewCount(dto);
        result.put("oldCount", oldCount);
        result.put("newCount", newCount);
        result.put("countSum", newCount + oldCount);
        return result;
    }

    public List<SecurityPerson> findByOrgId(Long orgId) {
        return this.personDao.findByOrgId(orgId);
    }

    public void selectExperienceById(Long id, Long relationId, AjaxPageResponse<PersonDto> page) {
        this.personDao.selectExperienceById(id, relationId, page);
    }

    public void updateCensorStatusList(List<SecurityPerson> successPersonList) {
        this.personDaoAop.updateCensorStatusList(successPersonList);
    }
}

