/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SbBusinessManagementDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbBusinessManagementSearchDto;
import com.bcxin.ars.model.SbBusinessManagement;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SbBusinessManagementService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.webservice.ClientUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=SbBusinessManagement.class)
public class SbBusinessManagementServiceImpl
implements SbBusinessManagementService {
    @Autowired
    private SbBusinessManagementDao sbBusinessManagementDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ClientUtil clientUtil;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    public void saveOrUpdate(SbBusinessManagement sbBusinessManagement) {
        SbBusinessManagement dbSbBusinessManagement;
        User user = this.arsUtil.getCurrentUser();
        if (null != sbBusinessManagement.getSecurityScope() && !sbBusinessManagement.getSecurityScope().contains("20") || null == sbBusinessManagement.getSecurityScope()) {
            sbBusinessManagement.setOtherSecScopeType(null);
        }
        if ((dbSbBusinessManagement = this.sbBusinessManagementDao.findById(sbBusinessManagement.getId())) != null) {
            dbSbBusinessManagement.setUpdateTime(new Date());
            dbSbBusinessManagement.setUpdateBy(user.getRealname());
            BeanUtils.copyPropertiesIgnore((Object)sbBusinessManagement, (Object)dbSbBusinessManagement, (Boolean)true);
            if (!StringUtils.isEmpty((Object)sbBusinessManagement.getCrossCityBusinessProvince())) {
                dbSbBusinessManagement.setCrossCityBusinessProvince(sbBusinessManagement.getCrossCityBusinessProvince());
                if (sbBusinessManagement.getCrossCityBusinessProvince().equals("\u53f0\u6e7e\u7701")) {
                    dbSbBusinessManagement.setCrossCityBusinessCity("");
                    dbSbBusinessManagement.setCrossCityBusinessCounty("");
                } else if (sbBusinessManagement.getCrossCityBusinessProvince().equals("\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a") || sbBusinessManagement.getCrossCityBusinessProvince().equals("\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a")) {
                    dbSbBusinessManagement.setCrossCityBusinessCounty("");
                    dbSbBusinessManagement.setCrossCityBusinessCity(sbBusinessManagement.getCrossCityBusinessCity());
                } else {
                    if (!StringUtils.isEmpty((Object)sbBusinessManagement.getCrossCityBusinessCity())) {
                        dbSbBusinessManagement.setCrossCityBusinessCity(sbBusinessManagement.getCrossCityBusinessCity());
                    }
                    if (!StringUtils.isEmpty((Object)sbBusinessManagement.getCrossCityBusinessCounty())) {
                        dbSbBusinessManagement.setCrossCityBusinessCounty(sbBusinessManagement.getCrossCityBusinessCounty());
                    }
                }
            }
            this.sbBusinessManagementDao.update(dbSbBusinessManagement);
        } else {
            if (user.getPlatform() == 2) {
                sbBusinessManagement.setUserid(user.getId());
            }
            sbBusinessManagement.setCreateTime(new Date());
            sbBusinessManagement.setUpdateTime(sbBusinessManagement.getCreateTime());
            sbBusinessManagement.setActive(Boolean.valueOf(true));
            sbBusinessManagement.setUpdateBy(user.getUsername());
            if (sbBusinessManagement.getId() == null) {
                sbBusinessManagement.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            }
            this.sbBusinessManagementDao.save(sbBusinessManagement);
        }
    }

    public void delete(SbBusinessManagement sbBusinessManagement) {
        sbBusinessManagement.setUpdateTime(new Date());
        this.sbBusinessManagementDao.delete(sbBusinessManagement);
    }

    public SbBusinessManagement findById(long id) {
        return this.sbBusinessManagementDao.findById(Long.valueOf(id));
    }

    public SbBusinessManagementSearchDto search(SbBusinessManagementSearchDto dto) {
        SbBusinessManagementSearchDto resultDto = new SbBusinessManagementSearchDto();
        List list = this.sbBusinessManagementDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(Long.valueOf(this.sbBusinessManagementDao.count(dto)));
        return resultDto;
    }

    public List<SbBusinessManagement> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.sbBusinessManagementDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(SbBusinessManagement sbBusinessManagement) {
        if (sbBusinessManagement.getActive() == null) {
            sbBusinessManagement.setActive(Boolean.valueOf(true));
        }
        if (!sbBusinessManagement.getActive().booleanValue()) {
            this.sbBusinessManagementDao.delete(sbBusinessManagement);
        } else {
            SbBusinessManagement dbSbBusinessManagement = this.sbBusinessManagementDao.findById(sbBusinessManagement.getId());
            if (dbSbBusinessManagement == null) {
                this.sbBusinessManagementDao.saveForDS(sbBusinessManagement);
            } else if (sbBusinessManagement.getUpdateTime().getTime() > dbSbBusinessManagement.getUpdateTime().getTime()) {
                this.sbBusinessManagementDao.update(sbBusinessManagement);
            }
        }
    }
}

