/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.RoleDao;
import com.bcxin.ars.dao.SecurityCompanyPersonDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.UserRoleDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Role;
import com.bcxin.ars.service.RoleService;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Role.class)
public class RoleServiceImpl
implements RoleService {
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private SecurityCompanyPersonDao companyPersonDao;
    @Autowired
    private ArsUtil arsUtil;

    public List<Role> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.roleDao.searchForDataSynchronization(dto);
    }

    public void saveOrUpdate(Role role) {
        Role checkRole = this.roleDao.findByCompanyRoleName(role.getCompany().getId(), role.getName());
        if (role.getId() == null) {
            if (checkRole != null) {
                throw new ArsException("\u89d2\u8272\u540d\u5df2\u5b58\u5728\uff01");
            }
            role.setNativeCode(this.arsUtil.getCurrentNatvie());
            role.setActive(Boolean.valueOf(true));
            role.setCreateTime(new Date());
            role.setUpdateTime(new Date());
            role.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
            this.roleDao.save(role);
        } else {
            if (checkRole != null && checkRole.getId() != role.getId()) {
                throw new ArsException("\u89d2\u8272\u540d\u5df2\u5b58\u5728\uff01");
            }
            Role dbRole = this.roleDao.findById(role.getId());
            if (dbRole != null) {
                dbRole.setUpdateTime(new Date());
                dbRole.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
                if (!StringUtils.isEmpty((Object)role.getName())) {
                    dbRole.setName(role.getName());
                }
                if (role.getCompany() != null && role.getCompany().getId() != null && role.getCompany().getId() > 0L) {
                    dbRole.setCompany(role.getCompany());
                }
                this.roleDao.update(dbRole);
            }
        }
    }

    public void delete(Role role) {
        List userRoleList = this.userRoleDao.findByRoleId(role.getId());
        if (userRoleList.size() > 0) {
            throw new ArsException("\u8be5\u89d2\u8272\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002");
        }
        role.setUpdateTime(new Date());
        role.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
        this.roleDao.delete(role);
    }

    public Role findById(Long id) {
        return this.roleDao.findById(id);
    }

    public List<Role> findByCompany(Long companyId) {
        return this.roleDao.findByCompany(companyId);
    }

    public List<Role> findByCompanyAll(Long companyId) {
        return this.roleDao.findByCompanyAll(companyId);
    }

    public void saveOrUpdateForDS(Role role) {
        if (role.getActive() == null) {
            role.setActive(Boolean.valueOf(true));
        }
        if (!role.getActive().booleanValue()) {
            this.roleDao.delete(role);
            return;
        }
        Role dbRole = this.findById(role.getId());
        if (dbRole == null) {
            this.roleDao.saveForDS(role);
        } else if (role.getUpdateTime().getTime() > dbRole.getUpdateTime().getTime()) {
            this.roleDao.update(role);
        }
    }

    public List<Role> findByUserId(Long userId) {
        return this.roleDao.findByUserId(userId);
    }

    public List<Role> findByUserIdCompanyId(Long userId, Long companyId) {
        return this.roleDao.findByUserIdCompanyId(userId, companyId);
    }
}

