/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dao.DataAuthDao;
import com.bcxin.ars.dao.PermissionDao;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.PoliceRoleDao;
import com.bcxin.ars.dao.ProblemPersonDao;
import com.bcxin.ars.dao.ProblemPersonDaoAop;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.UserRoleDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.LayTree;
import com.bcxin.ars.dto.MenuTree;
import com.bcxin.ars.dto.OrgUserDto;
import com.bcxin.ars.dto.PoliceDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.Tree;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.dto.sb.PoliceSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.ProblemPerson;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.PoliceRoleService;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BuildWebServiceEntity;
import com.bcxin.ars.util.CipherDESUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.webservice.ClientUtil;
import com.bcxin.ars.webservice.Policesecsuporg;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Police.class)
@DataSyncOutAnnotation(getClazz=Police.class)
public class PoliceServiceImpl
implements PoliceService {
    private static final Logger logger = LoggerFactory.getLogger(PoliceServiceImpl.class);
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private PoliceRoleDao policeRoleDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private PermissionDao permissionDao;
    @Autowired
    private DataAuthDao dataAuthDao;
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private ProblemPersonDao problemPersonDao;
    @Autowired
    private ProblemPersonDaoAop problemPersonDaoAop;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ClientUtil clientUtil;
    @Autowired
    private PoliceRoleService policeRoleService;
    @Autowired
    private SecurityCompanyService securityCompanyService;
    @Value(value="${personcertificate-download-folder}")
    private String tempftpFolder;

    public void isRepet(PoliceSearchDto policeSearchDto, Police police) {
        policeSearchDto.setAddOrgname(police.getOrgname());
        if (this.policeDao.count(policeSearchDto) > 0L) {
            throw new ArsException("\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u91cd\u590d!");
        }
    }

    public void updatenum(Police police) {
        User user = this.arsUtil.getCurrentUser();
        Police dbPolice = this.policeDao.findById(police.getId());
        dbPolice.setUpdateTime(new Date());
        dbPolice.setUpdateBy(user.getRealname());
        dbPolice.setUpdateflag(Boolean.valueOf(true));
        this.policeDao.update(dbPolice);
    }

    public void saveOrUpdate(Police police) {
        User user = this.arsUtil.getCurrentUser();
        PoliceSearchDto policeSearchDto = new PoliceSearchDto();
        if (police.getId() != null) {
            this.isOnlyoneByareacode(police);
            Police dbPolice = this.policeDao.findById(police.getId());
            if ("1".equals(police.getOptype())) {
                if (null != dbPolice.getOrderno() && !"".equals(dbPolice.getOrderno())) {
                    dbPolice.setOrderno(Integer.valueOf(dbPolice.getOrderno() - 1));
                }
            } else if ("2".equals(police.getOptype())) {
                if (null != dbPolice.getOrderno() && !"".equals(dbPolice.getOrderno())) {
                    dbPolice.setOrderno(Integer.valueOf(dbPolice.getOrderno() + 1));
                }
            } else if ("3".equals(police.getOptype())) {
                PoliceSearchDto dto = new PoliceSearchDto();
                dto.setSearchCondition(police.getParentorg() == null ? "" : police.getParentorg().toString());
                police.setOrderno(Integer.valueOf((int)this.policeDao.count(dto) + 1));
                police.setUserid(user.getId());
                police.setCreateTime(new Date());
                police.setUpdateTime(police.getCreateTime());
                police.setActive(Boolean.valueOf(true));
                police.setUpdateBy(user.getUsername());
                police.setNativeCode(this.arsUtil.getCurrentNatvie());
                this.isRepet(policeSearchDto, police);
                police.setUpdateflag(Boolean.valueOf(true));
                this.policeDao.save(police);
                new Thread(() -> {
                    try {
                        String[] srccol = new String[]{"code", "orgname", "address", "contact", "tel", "phone"};
                        String[] desccol = new String[]{"jgjgbm", "jgjgmc", "bgdz", "fzrmc", "zbdh", "czdh"};
                        String[] key = new String[]{};
                        String[] value = new String[]{};
                        Object desc = BuildWebServiceEntity.buildWebServiceEntity((String[])srccol, (String[])desccol, (Object)police, (Object)new Policesecsuporg(), (String[])key, (String[])value);
                        Policesecsuporg policesecsuporg = (Policesecsuporg)desc;
                        this.clientUtil.send("xxba_policesecsuporg", (Object)policesecsuporg);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }).start();
                Police newPolice = this.policeDao.findById(police.getId());
                Police parentPolice = this.policeDao.findById(Long.valueOf(police.getParentorg()));
                newPolice.setPath(parentPolice.getPath() + newPolice.getId().toString() + "/");
                newPolice.setUpdateflag(Boolean.valueOf(true));
                this.policeDao.update(newPolice);
            } else {
                Police policeByorgname = this.policeDao.findByOrgname(police.getOrgname());
                if (null != policeByorgname && !policeByorgname.getId().equals(police.getId())) {
                    this.isRepet(policeSearchDto, police);
                }
                dbPolice.setUpdateTime(new Date());
                dbPolice.setUpdateBy(user.getRealname());
                dbPolice.setUpdateflag(Boolean.valueOf(true));
                if (!StringUtils.isEmpty((Object)police.getAddress())) {
                    dbPolice.setAddress(police.getAddress());
                }
                if (!StringUtils.isEmpty((Object)police.getArea())) {
                    dbPolice.setArea(police.getArea());
                }
                if (!StringUtils.isEmpty((Object)police.getContact())) {
                    dbPolice.setContact(police.getContact());
                }
                if (!StringUtils.isEmpty((Object)police.getOrderno())) {
                    dbPolice.setOrderno(police.getOrderno());
                }
                if (!StringUtils.isEmpty((Object)police.getRemarks())) {
                    dbPolice.setRemarks(police.getRemarks());
                }
                if (!StringUtils.isEmpty((Object)police.getOrgname())) {
                    dbPolice.setOrgname(police.getOrgname());
                }
                if (!StringUtils.isEmpty((Object)police.getParentorg())) {
                    dbPolice.setParentorg(police.getParentorg());
                }
                if (!StringUtils.isEmpty((Object)police.getPhone())) {
                    dbPolice.setPhone(police.getPhone());
                }
                if (!StringUtils.isEmpty((Object)police.getShortname())) {
                    dbPolice.setShortname(police.getShortname());
                }
                if (!StringUtils.isEmpty((Object)police.getTel())) {
                    dbPolice.setTel(police.getTel());
                }
                if (!StringUtils.isEmpty((Object)police.getCode())) {
                    dbPolice.setCode(police.getCode());
                }
                if (!StringUtils.isEmpty((Object)police.getAreacode())) {
                    dbPolice.setAreacode(police.getAreacode());
                }
                if (!StringUtils.isEmpty((Object)police.getOrgtype())) {
                    dbPolice.setOrgtype(police.getOrgtype());
                }
            }
            this.policeDao.update(dbPolice);
            ProblemPerson problemPerson = new ProblemPerson();
            problemPerson.setOrgId(dbPolice.getId());
            problemPerson.setOrgName(dbPolice.getOrgname());
            problemPerson.setUpdateTime(new Date());
            this.problemPersonDaoAop.updateOrgInfo(problemPerson);
        } else {
            PoliceSearchDto dto = new PoliceSearchDto();
            dto.setSearchCondition(police.getParentorg() == null ? "" : police.getParentorg().toString());
            police.setOrderno(Integer.valueOf((int)this.policeDao.count(dto) + 1));
            police.setUserid(user.getId());
            police.setCreateTime(new Date());
            police.setUpdateTime(police.getCreateTime());
            police.setActive(Boolean.valueOf(true));
            police.setUpdateBy(user.getUsername());
            police.setNativeCode(this.arsUtil.getCurrentNatvie());
            this.isRepet(policeSearchDto, police);
            this.isOnlyoneByareacode(police);
            police.setUpdateflag(Boolean.valueOf(true));
            this.policeDao.save(police);
            new Thread(() -> {
                try {
                    String[] srccol = new String[]{"code", "orgname", "address", "contact", "tel", "phone"};
                    String[] desccol = new String[]{"jgjgbm", "jgjgmc", "bgdz", "fzrmc", "zbdh", "czdh"};
                    String[] key = new String[]{};
                    String[] value = new String[]{};
                    Object desc = BuildWebServiceEntity.buildWebServiceEntity((String[])srccol, (String[])desccol, (Object)police, (Object)new Policesecsuporg(), (String[])key, (String[])value);
                    Policesecsuporg policesecsuporg = (Policesecsuporg)desc;
                    this.clientUtil.send("xxba_policesecsuporg", (Object)policesecsuporg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
            Police newPolice = this.policeDao.findById(police.getId());
            Police parentPolice = this.policeDao.findById(Long.valueOf(police.getParentorg()));
            newPolice.setPath(parentPolice.getPath() + newPolice.getId().toString() + "/");
            newPolice.setUpdateflag(Boolean.valueOf(true));
            this.policeDao.update(newPolice);
        }
    }

    private void isOnlyoneByareacode(Police police) {
        if (!"4".equals(police.getOrgtype())) {
            Police searchPolice = new Police();
            searchPolice.setAreacode(police.getAreacode());
            searchPolice.setId(police.getId());
            searchPolice.setOrgtype("4");
            List policeList = this.policeDao.findPoliceByAreacodeApprove(searchPolice);
            if (policeList.size() > 0) {
                throw new ArsException("\u540c\u4e00\u4e2a\u533a\u57df\u4e0d\u80fd\u521b\u5efa\u8d85\u8fc7\u4e24\u4e2a\u673a\u6784\uff08\u6d3e\u51fa\u6240\u9664\u5916\uff09!");
            }
        }
    }

    public void delete(Police police) {
        this.policeRoleService.deleteRoleByOrgId(police.getId());
        police.setUpdateTime(new Date());
        police.setUpdateflag(Boolean.valueOf(true));
        this.policeDao.delete(police);
    }

    public Police findByOrgname(String orgname) {
        return this.policeDao.findByOrgname(orgname);
    }

    public Police findById(long id) {
        return this.policeDao.findById(Long.valueOf(id));
    }

    public PoliceSearchDto search(PoliceSearchDto dto) {
        PoliceSearchDto resultDto = new PoliceSearchDto();
        List list = this.policeDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(Long.valueOf(this.policeDao.count(dto)));
        return resultDto;
    }

    public PoliceSearchDto searchAll(PoliceSearchDto dto) {
        PoliceSearchDto resultDto = new PoliceSearchDto();
        List list = this.policeDao.searchAll(dto);
        resultDto.setData(list);
        return resultDto;
    }

    public List<Tree> searchForTree(PoliceSearchDto dto) {
        User currentUser = this.arsUtil.getCurrentUser();
        dto.setPoliceBusiness(true);
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        if (dto.getParentorg() == null && dto.getId() != null) {
            dto.setParentorg(dto.getId());
        }
        List list = this.policeDao.searchForTree(dto);
        ArrayList<Tree> resultList = new ArrayList<Tree>();
        if (list != null && list.size() > 0) {
            Map<String, List<Tree>> treeMap = list.stream().collect(Collectors.groupingBy(Tree::getId));
            Map<String, List<Tree>> groupMap = list.stream().filter(menu -> menu.getParentId() != null).collect(Collectors.groupingBy(Tree::getParentId));
            for (Tree tree : list) {
                if (groupMap.get(tree.getId()) != null) {
                    tree.setChildren(groupMap.get(tree.getId()));
                } else {
                    tree.setExpanded(true);
                    tree.setState("open");
                }
                if (tree.getParentId() != null && treeMap.get(tree.getParentId()) != null) continue;
                resultList.add(tree);
            }
        }
        return resultList;
    }

    public List<LayTree> searchForLayTree(PoliceSearchDto dto) {
        User currentUser = this.arsUtil.getCurrentUser();
        dto.setPoliceBusiness(true);
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        if (dto.getParentorg() == null && dto.getId() != null) {
            dto.setParentorg(dto.getId());
        }
        List list = this.policeDao.searchForLayTree(dto);
        ArrayList<LayTree> resultList = new ArrayList<LayTree>();
        if (list != null && list.size() > 0) {
            Map<String, List<LayTree>> treeMap = list.stream().collect(Collectors.groupingBy(LayTree::getId));
            Map<String, List<LayTree>> groupMap = list.stream().filter(menu -> menu.getParentId() != null).collect(Collectors.groupingBy(LayTree::getParentId));
            for (LayTree tree : list) {
                if (groupMap.get(tree.getId()) != null) {
                    tree.setChildren(groupMap.get(tree.getId()));
                } else {
                    tree.setOpen(true);
                }
                if (tree.getParentId() != null && treeMap.get(tree.getParentId()) != null) continue;
                resultList.add(tree);
            }
        }
        return resultList;
    }

    public List<MenuTree> searchForMenuTree(PoliceSearchDto dto) {
        User currentUser = this.arsUtil.getCurrentUser();
        dto.setPoliceBusiness(true);
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        if (dto.getParentorg() == null && dto.getId() != null) {
            dto.setParentorg(dto.getId());
        }
        List list = this.policeDao.searchForMenuTree(dto);
        ArrayList<MenuTree> resultList = new ArrayList<MenuTree>();
        if (list != null && list.size() > 0) {
            List roleList;
            boolean disabled = false;
            if (dto.getRoleId() != null && (roleList = currentUser.getRoles()) != null && roleList.size() > 0) {
                for (PoliceRole role : roleList) {
                    if (role.getId().longValue() != dto.getRoleId().longValue()) continue;
                    disabled = true;
                }
            }
            Map<String, List<MenuTree>> treeMap = list.stream().collect(Collectors.groupingBy(MenuTree::getId));
            Map<String, List<MenuTree>> groupMap = list.stream().filter(menu -> menu.getParentId() != null).collect(Collectors.groupingBy(MenuTree::getParentId));
            for (MenuTree menuTree : list) {
                menuTree.setDisabled(disabled);
                if (groupMap.get(menuTree.getId()) != null) {
                    menuTree.setChildren(groupMap.get(menuTree.getId()));
                    menuTree.setChecked(false);
                }
                if (menuTree.getParentId() != null && treeMap.get(menuTree.getParentId()) != null) continue;
                menuTree.setSpread(true);
                resultList.add(menuTree);
            }
        }
        return resultList;
    }

    public PoliceSearchDto searchArea(PoliceSearchDto dto) {
        PoliceSearchDto resultDto = new PoliceSearchDto();
        List list = this.policeDao.searchArea(dto);
        resultDto.setData(list);
        return resultDto;
    }

    public List<Police> findByParentOrg(Long parentorg) {
        List list = this.policeDao.findByParentOrg(parentorg);
        return list;
    }

    public List<Police> searchParentorg(Police police) {
        List list = this.policeDao.searchParentorg(police);
        return list;
    }

    public List<TreeView> searchForTreeView(PoliceSearchDto dto) {
        User currentUser = this.arsUtil.getCurrentUser();
        dto.setPoliceBusiness(true);
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        if (dto.getParentorg() == null && dto.getId() != null) {
            dto.setParentorg(dto.getId());
        }
        List list = this.policeDao.searchPoliceForTreeViewByprint(dto);
        ArrayList<TreeView> resultList = new ArrayList<TreeView>();
        if (list != null && list.size() > 0) {
            Map<String, List<TreeView>> treeMap = list.stream().collect(Collectors.groupingBy(TreeView::getNodeid));
            Map<String, List<TreeView>> groupMap = list.stream().filter(menu -> menu.getParentid() != null).collect(Collectors.groupingBy(TreeView::getParentid));
            for (TreeView menuTree : list) {
                if (groupMap.get(menuTree.getNodeid()) != null) {
                    menuTree.setNodes(groupMap.get(menuTree.getNodeid()));
                }
                if (menuTree.getParentid() != null && treeMap.get(menuTree.getParentid()) != null) continue;
                menuTree.setShowExpanded(true);
                resultList.add(menuTree);
            }
        }
        return resultList;
    }

    public List<TreeView> findAllForTreeViewPower(PoliceSearchDto dto) {
        User currentUser = this.arsUtil.getCurrentUser();
        dto.setPoliceBusiness(true);
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        if (dto.getParentorg() == null && dto.getId() != null) {
            dto.setParentorg(dto.getId());
        }
        List list = this.policeDao.searchPoliceForTreeViewByprint(dto);
        ArrayList<TreeView> resultList = new ArrayList<TreeView>();
        if (list != null && list.size() > 0) {
            Map<String, List<TreeView>> treeMap = list.stream().collect(Collectors.groupingBy(TreeView::getNodeid));
            Map<String, List<TreeView>> groupMap = list.stream().filter(menu -> menu.getParentid() != null).collect(Collectors.groupingBy(TreeView::getParentid));
            for (TreeView menuTree : list) {
                if (groupMap.get(menuTree.getNodeid()) != null) {
                    menuTree.setNodes(groupMap.get(menuTree.getNodeid()));
                }
                if (menuTree.getParentid() != null && treeMap.get(menuTree.getParentid()) != null) continue;
                menuTree.setShowExpanded(true);
                resultList.add(menuTree);
            }
        }
        return resultList;
    }

    public List<Police> findByType(String type) {
        return this.policeDao.findByType(type);
    }

    public List<TreeView> searchForTreeViewByprint(PoliceSearchDto dto) {
        User currentUser = this.arsUtil.getCurrentUser();
        dto.setPoliceBusiness(true);
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        if (dto.getParentorg() == null && dto.getId() != null) {
            dto.setParentorg(dto.getId());
        }
        List list = this.policeDao.searchPoliceForTreeViewByprint(dto);
        ArrayList<TreeView> resultList = new ArrayList<TreeView>();
        if (list != null && list.size() > 0) {
            Map<String, List<TreeView>> treeMap = list.stream().collect(Collectors.groupingBy(TreeView::getNodeid));
            Map<String, List<TreeView>> groupMap = list.stream().filter(menu -> menu.getParentid() != null).collect(Collectors.groupingBy(TreeView::getParentid));
            for (TreeView menuTree : list) {
                if (groupMap.get(menuTree.getNodeid()) != null) {
                    menuTree.setNodes(groupMap.get(menuTree.getNodeid()));
                }
                if (menuTree.getParentid() != null && treeMap.get(menuTree.getParentid()) != null) continue;
                menuTree.setShowExpanded(true);
                resultList.add(menuTree);
            }
        }
        return resultList;
    }

    public List<TreeView> searchPoliceForTreeViewByprint(PoliceSearchDto dto) {
        User currentUser = this.arsUtil.getCurrentUser();
        dto.setPoliceBusiness(true);
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        if (dto.getParentorg() == null && dto.getId() != null) {
            dto.setParentorg(dto.getId());
        }
        List list = this.policeDao.searchPoliceForTreeViewByprint(dto);
        ArrayList<TreeView> resultList = new ArrayList<TreeView>();
        if (list != null && list.size() > 0) {
            Map<String, List<TreeView>> treeMap = list.stream().collect(Collectors.groupingBy(TreeView::getNodeid));
            Map<String, List<TreeView>> groupMap = list.stream().filter(menu -> menu.getParentid() != null).collect(Collectors.groupingBy(TreeView::getParentid));
            for (TreeView menuTree : list) {
                if (groupMap.get(menuTree.getNodeid()) != null) {
                    menuTree.setNodes(groupMap.get(menuTree.getNodeid()));
                }
                if (menuTree.getParentid() != null && treeMap.get(menuTree.getParentid()) != null) continue;
                menuTree.setShowExpanded(true);
                resultList.add(menuTree);
            }
        }
        return resultList;
    }

    public List<Police> findByAreaUserId(User user) {
        Police police = this.policeDao.findById(user.getOrgid());
        police.setUserid(user.getId());
        return this.policeDao.findByAreaUserId(police);
    }

    public List<Police> findAll() {
        return this.policeDao.findAll();
    }

    public void saveOrUpdateForDS(Police police) {
        Police dbPolice = this.policeDao.findById(police.getId());
        if (dbPolice != null && police.getUpdateTime().getTime() > dbPolice.getUpdateTime().getTime()) {
            if (!police.getActive().booleanValue()) {
                this.policeDao.delete(police);
            } else {
                this.policeDao.update(police);
            }
        }
    }

    public List<Police> findPoliceByAreacode(Police police) {
        return this.policeDao.findPoliceByAreacode(police);
    }

    private void writeTxtFile(String readStr, String type) {
        try {
            String basePath = this.tempftpFolder;
            String filePath = basePath + DateUtil.getCurrentDate() + File.separator;
            String fileName = type;
            String fileType = ".data";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
                System.out.println("\u6587\u4ef6\u5939\u5df2\u521b\u5efa");
            }
            String fullFilePath = filePath + fileName + "_" + DateUtil.getCurrentDateTime((String)"yyyyMMddHHmmss") + fileType;
            File newFile = new File(fullFilePath);
            Files.write((byte[])readStr.getBytes(), (File)newFile);
        }
        catch (Exception e) {
            System.out.println("\u5bfc\u51fa\u5931\u8d25\uff01");
        }
    }

    public void autoExportPolice() {
        List policeList = this.policeDao.searchForExport(DateUtil.getYesterday());
        if (policeList != null && policeList.size() > 0) {
            try {
                for (Police p : policeList) {
                    p.setUpdateflag(Boolean.valueOf(false));
                    String policeStr = JSONArray.toJSONString((Object)p);
                    System.out.println(policeStr);
                    String content = CipherDESUtil.parseByte2HexStr((byte[])CipherDESUtil.encrypt((byte[])policeStr.getBytes(), (String)Constants.APPROVAL_KEY));
                    this.writeTxtFile(content, "police");
                    this.policeDao.updateFlag(p);
                }
            }
            catch (Exception e) {
                System.out.println("\u5bfc\u51fa\u5931\u8d25\uff01");
            }
        }
    }

    public OrgUserDto findOrgUserForDS(String startDate) {
        OrgUserDto orgUserDto = new OrgUserDto();
        List policelist = this.policeDao.searchForExport(startDate);
        List policeRolelist = this.policeRoleDao.searchFromInToOutForExport(startDate);
        List userlist = this.userDao.searchFromInToOutForExport(startDate);
        orgUserDto.setPolicelist(policelist);
        orgUserDto.setPoliceRolelist(policeRolelist);
        orgUserDto.setUserlist(userlist);
        return orgUserDto;
    }

    @Deprecated
    public void saveOrUpdateForImport(Police police) {
        police.setUpdateflag(Boolean.valueOf(false));
        police.setUpdateTime(new Date());
        Police dbPolice = this.policeDao.findById(police.getId());
        if (dbPolice == null) {
            this.policeDao.saveForDS(police);
        } else if (police.getUpdateTime().getTime() > dbPolice.getUpdateTime().getTime()) {
            this.policeDao.updateForDS(police);
        }
    }

    public List<Police> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.policeDao.searchForDataSynchronization(searchDto);
    }

    public void updateExport(PoliceSearchDto policeSearchDto) {
        this.policeDao.updateExport(policeSearchDto);
    }

    public List<PoliceDto> searchForSaas(PoliceSearchDto policeSearchDto) {
        return this.policeDao.searchForSaas(policeSearchDto);
    }

    public List<Police> findDSOutList(String startDate) {
        return this.policeDao.searchForExport(startDate);
    }

    public void importBatch(List<Police> list) {
        List dbList = this.policeDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (Police detail : list) {
                detail.setUpdateflag(Boolean.valueOf(false));
                try {
                    detail.setUpdateTime(DateUtil.dateAdd((int)6, (Date)detail.getUpdateTime(), (int)1));
                }
                catch (Exception exception) {}
            }
            this.policeDao.saveBatch(list);
        }
    }

    public List<Police> findDataPoliceForUserID(Long userId) {
        return this.policeDao.findDataPoliceForUserID(userId);
    }

    public Police getApprovalMinOrgTypePolice(String areaCode, String businessTypeCode, String sponsorlicenseType) {
        SecurityCompany company;
        StringBuffer tempCode = new StringBuffer();
        if ("008".equals(businessTypeCode) && StringUtil.isEmpty((String)sponsorlicenseType) && (company = this.securityCompanyService.getCurrentUserCompany()) != null) {
            String string = sponsorlicenseType = StringUtil.isEmpty((String)company.getSponsorlicenseType()) ? "01" : company.getSponsorlicenseType();
        }
        if ("450000".equals(areaCode)) {
            tempCode.append(BusinessType.getBusinessTypeName((String)businessTypeCode, (String)sponsorlicenseType));
        } else {
            tempCode.append(BusinessType.getBusinessTypeName((String)businessTypeCode, (String)sponsorlicenseType)).append("-").append(areaCode);
        }
        return this.policeDao.getApprovalMinOrgTypePolice(tempCode.toString());
    }
}

