/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.OrderTransactionDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.OrderTransaction;
import com.bcxin.ars.service.OrderTransactionService;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrderTransactionServiceImpl
implements OrderTransactionService {
    @Autowired
    private OrderTransactionDao orderTransactionDao;
    @Autowired
    private ArsUtil arsUtil;

    public void save(OrderTransaction orderTransaction) {
        this.orderTransactionDao.save(orderTransaction);
    }

    public OrderTransaction findById(Long id) {
        return this.orderTransactionDao.findById(id);
    }

    public OrderTransaction findByOrderId(Long orderId) {
        return this.orderTransactionDao.findByOrderId(orderId);
    }

    public void update(OrderTransaction transaction) {
        transaction.setUpdateTime(new Date());
        this.orderTransactionDao.update(transaction);
    }

    public OrderTransaction findByOrderNo(String orderNo) {
        return this.orderTransactionDao.findByOrderNo(orderNo);
    }

    public List<OrderTransaction> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.orderTransactionDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(OrderTransaction orderTransaction) {
        if (orderTransaction.getActive() == null) {
            orderTransaction.setActive(Boolean.valueOf(true));
        }
        if (!orderTransaction.getActive().booleanValue()) {
            this.orderTransactionDao.delete(orderTransaction);
        } else {
            OrderTransaction dbOrderTransaction = this.orderTransactionDao.findById(orderTransaction.getId());
            if (dbOrderTransaction == null) {
                this.orderTransactionDao.saveForDS(orderTransaction);
            } else if (orderTransaction.getUpdateTime().getTime() > dbOrderTransaction.getUpdateTime().getTime()) {
                this.orderTransactionDao.update(orderTransaction);
            }
        }
    }
}

