/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.ModuleDao;
import com.bcxin.ars.dao.PermissionDao;
import com.bcxin.ars.dto.ZTree;
import com.bcxin.ars.model.Module;
import com.bcxin.ars.model.Permission;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.ModuleService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModuleServiceImpl
implements ModuleService {
    @Autowired
    private ModuleDao moduleDao;
    @Autowired
    private PermissionDao permissionDao;
    @Autowired
    private ArsUtil arsUtil;

    public List<Module> findByUserId(Long userid) {
        return this.moduleDao.findByUserId(userid);
    }

    public Map<Long, Module> findAll() {
        List list = this.moduleDao.findAll();
        HashMap<Long, Module> data = new HashMap<Long, Module>();
        for (Module module : list) {
            data.put(module.getId(), module);
        }
        return data;
    }

    public List<Module> findAllPerson() {
        return this.moduleDao.findAllPerson();
    }

    public List<Module> findAllPolice(Long userId) {
        Module module = new Module();
        module.setModuletype(Long.valueOf(Constants.POLICE_ROLE));
        module.setUserId(userId);
        return this.moduleDao.findByType(module);
    }

    public List<ZTree> getModuleTree() {
        User user = this.arsUtil.getCurrentUser();
        Module module = new Module();
        module.setModuletype(Long.valueOf(Constants.POLICE_ROLE));
        module.setUserId(user.getId());
        List list = this.moduleDao.getModuleTreeForAdmin(module);
        ArrayList<ZTree> resultList = new ArrayList<ZTree>();
        if ("1".equals(user.getIsAdmin())) {
            return list;
        }
        List permissionList = this.permissionDao.findByGAUserId(user.getId());
        List ids = permissionList.stream().map(Permission::getModulePId).collect(Collectors.toList());
        HashMap<String, String> mKeyMap = new HashMap<String, String>();
        if (ids != null) {
            List modules = this.moduleDao.findByIdArray(ids);
            for (Module dbModule : modules) {
                mKeyMap.put("M" + dbModule.getpId(), dbModule.getpId() + "");
            }
        }
        HashMap<String, String> oKeyMap = new HashMap<String, String>();
        for (Permission permission : permissionList) {
            mKeyMap.put("M" + permission.getModulePId(), permission.getModulePId() + "");
            mKeyMap.put("M" + permission.getModule().getId(), permission.getModule().getId() + "");
            oKeyMap.put(permission.getOperation().getId() + "", permission.getOperation().getId() + "");
        }
        for (ZTree zTree : list) {
            if (zTree.getType().equals("0")) {
                if (!StringUtil.isEmpty((String)zTree.getpId()) && mKeyMap.get(zTree.getId()) == null) continue;
                resultList.add(zTree);
                continue;
            }
            if (oKeyMap.get(zTree.getId()) == null) continue;
            resultList.add(zTree);
        }
        return resultList;
    }

    public List<Module> findByIdArray(List<Long> ids) {
        return this.moduleDao.findByIdArray(ids);
    }
}

