/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dto.page.ConfigPageSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.EmailUtils;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ConfigServiceImpl
implements ConfigService {
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public List<Config> findAll() {
        return this.configDao.findAll();
    }

    public Config findByKey(String key) {
        return this.configDao.findByKey(key);
    }

    public Config getConfigByKey(String key) {
        return this.configUtils.getConfigByKey(key);
    }

    public String getValueByKey(String key) {
        Config config = this.configUtils.getConfigByKey(key);
        if (config != null) {
            return config.getValue();
        }
        return "";
    }

    public Config findByKeyAndName(String key, String name) {
        return this.configDao.findByKeyAndName(key, name);
    }

    public void update(Config config) {
        this.configDao.update(config);
    }

    public List<Config> findByLikeKey(String key) {
        return this.configDao.findByLikeKey(key);
    }

    public List<Config> findDSOutList(String startDate) {
        ArrayList<Config> list = new ArrayList<Config>();
        Config config = this.configDao.findByKey("lastDate");
        config.setUpdateTime(new Date());
        list.add(config);
        return list;
    }

    public void importBatch(List<Config> list) {
        Config receiveUserConfig = this.configUtils.getConfigByKey("DATASYNC_RECEIVEUSER");
        Config currentNativeName = this.configUtils.getConfigByKey("current_native_name");
        if (receiveUserConfig != null && currentNativeName != null) {
            list.forEach(config -> {
                if ("lastDate".equals(config.getKey())) {
                    String lastDate = config.getValue();
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(config.getUpdateTime());
                    if (!DateUtil.getCurrentDate().equals(lastDate) && calendar.get(11) > 3) {
                        new Thread(() -> {
                            String sendHtml = "{currentNativeName}\u73af\u5883\u5916\u5230\u5185\u540c\u6b65\u5f02\u5e38\uff0c\u6765\u6e90\uff1a{url}<br>\u6700\u540e\u540c\u6b65\u65e5\u671f\u4e3a{lastDate}\uff0c\u6700\u540e\u66f4\u65b0\u65f6\u95f4\u4e3a{updateTime}".replace("{lastDate}", lastDate).replace("{updateTime}", DateUtil.convertDateToString((Date)config.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss")).replace("{currentNativeName}", currentNativeName.getValue()).replace("url", this.configUtils.getWebHost());
                            String receiveUser = receiveUserConfig.getValue();
                            EmailUtils emailUtil = new EmailUtils();
                            emailUtil.sendEmail("\u767e\u4fdd\u76fe\u6570\u636e\u540c\u6b65\u5f02\u5e38\u63d0\u9192", sendHtml, receiveUser);
                        }).start();
                    }
                }
            });
        }
    }

    public void delete(Config config) {
        User currentUser = this.arsUtil.getCurrentUser();
        config.setUpdateTime(new Date());
        config.setUpdateBy(currentUser.getUsername());
        this.configDao.delete(config);
    }

    public void save(Config config) {
        User currentUser = this.arsUtil.getCurrentUser();
        Config checkConfig = this.configUtils.getConfigByKey(config.getKey());
        if (checkConfig != null && !checkConfig.getId().equals(config.getId())) {
            throw new ArsException("\u8be5\u914d\u7f6e\u5df2\u5b58\u5728\uff01");
        }
        if (config.getId() == null) {
            config.setCreateTime(new Date());
        } else {
            Config dbConfig = this.configDao.findById(config.getId());
            BeanUtils.copyPropertiesIgnore((Object)config, (Object)dbConfig, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbConfig, (Object)config, (Boolean)false);
        }
        config.setActive(Boolean.valueOf(true));
        config.setUpdateBy(currentUser.getUsername());
        config.setUpdateTime(new Date());
        config.setUpdateflag(Boolean.valueOf(true));
        config.setAreaCode(currentUser.getPolice().getAreacode());
        this.configDao.save(config);
    }

    public Config findById(Long id) {
        return this.configDao.findById(id);
    }

    public void use(Config config) {
        User currentUser = this.arsUtil.getCurrentUser();
        config.setUpdateTime(new Date());
        config.setUpdateBy(currentUser.getUsername());
        this.configDao.use(config);
    }

    public void searchForPage(ConfigPageSearchDto dto, AjaxPageResponse page) {
        this.configDao.searchForPage(dto, page);
    }
}

