/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.ImgUtils;
import com.bcxin.ars.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class BaseService {
    private Logger logger = LoggerFactory.getLogger(BaseService.class);
    @Value(value="${upload-folder}")
    private String uploadFolder;
    @Value(value="${base-folder}")
    private String baseFolder;
    @Value(value="${temp-folder}")
    private String tempFolder;
    @Value(value="${pdf-folder}")
    private String pdfFolder;
    @Value(value="${personImg-folder}")
    private String personImg;

    public String getLocalPhotoPath(String url) {
        String[] urls;
        StringBuffer result = new StringBuffer("");
        for (String urlStr : urls = url.split(",")) {
            if (!StringUtil.isNotEmpty((String)(urlStr = urlStr.substring(urlStr.indexOf("getResource.do"))))) continue;
            if (StringUtil.isEmpty((String)result.toString())) {
                result.append(urlStr);
                continue;
            }
            result.append("&&" + urlStr);
        }
        return result.toString();
    }

    public String saveBase64Img(String base64Img) {
        if (StringUtil.isNotEmpty((String)base64Img)) {
            Date now = new Date();
            String fileName = now.getTime() + ".jpg";
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(this.uploadFolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String key = "upload/" + dirDate + "/" + fileName;
            String url = "getResource.do?path=" + key;
            String targetPath = this.baseFolder + key;
            if (ImgUtils.generateImage((String)base64Img, (String)targetPath)) {
                return url;
            }
        }
        return null;
    }

    public String getAttPath(String url) {
        FileOutputStream outStream = null;
        InputStream inStream = null;
        StringBuffer result = new StringBuffer("");
        try {
            String[] urls;
            for (String urlStr : urls = url.split(",")) {
                URL imgPath = new URL(urlStr);
                HttpURLConnection conn = (HttpURLConnection)imgPath.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                inStream = conn.getInputStream();
                byte[] data = BaseService.readInputStream(inStream);
                Date now = new Date();
                String[] fileTypes = urlStr.split("\\.");
                String materialFileType = fileTypes[fileTypes.length - 1];
                Random random = new Random();
                int rannum = (int)(random.nextDouble() * 90.0) + 100;
                StringBuffer fileName = new StringBuffer();
                fileName.append(now.getTime());
                fileName.append(rannum).append("." + materialFileType);
                String dirDate = DateUtil.systemDate.format(now);
                File dir = new File(this.uploadFolder + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String key = "upload/" + dirDate + "/" + fileName;
                if (StringUtil.isEmpty((String)result.toString())) {
                    result.append("getResource.do?path=" + key);
                } else {
                    result.append("&&getResource.do?path=" + key);
                }
                String targetPath = this.uploadFolder + dirDate + "/" + fileName;
                File imageFile = new File(targetPath);
                outStream = new FileOutputStream(imageFile);
                outStream.write(data);
                outStream.flush();
                this.logger.info("\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u6210\u529f!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ArsException("\u9644\u4ef6\u8f6c\u6362\u5f02\u5e38");
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPhotoPath(String url) {
        FileOutputStream outStream = null;
        InputStream inStream = null;
        StringBuffer result = new StringBuffer("");
        try {
            String[] urls;
            for (String urlStr : urls = url.split(",")) {
                URL imgPath = new URL(urlStr);
                HttpURLConnection conn = (HttpURLConnection)imgPath.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                inStream = conn.getInputStream();
                byte[] data = BaseService.readInputStream(inStream);
                Date now = new Date();
                String[] fileTypes = urlStr.split("\\.");
                String materialFileType = fileTypes[fileTypes.length - 1];
                Random random = new Random();
                int rannum = (int)(random.nextDouble() * 90.0) + 100;
                StringBuffer fileName = new StringBuffer();
                fileName.append(now.getTime());
                fileName.append(rannum).append("." + materialFileType);
                String dirDate = DateUtil.systemDate.format(now);
                File dir = new File(this.uploadFolder + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String key = "upload/" + dirDate + "/" + fileName;
                if (StringUtil.isEmpty((String)result.toString())) {
                    result.append("getResource.do?path=" + key);
                } else {
                    result.append("&&getResource.do?path=" + key);
                }
                String targetPath = this.uploadFolder + dirDate + "/" + fileName;
                File imageFile = new File(targetPath);
                outStream = new FileOutputStream(imageFile);
                outStream.write(data);
                outStream.flush();
                this.logger.info("\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u6210\u529f!");
            }
        }
        catch (Exception e) {
            result.append(url);
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result.toString();
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }

    public String getResourcePath(String path) throws Exception {
        String result = "";
        if ((path = path.replaceAll("getResource.do\\?path=", "")).startsWith("upload")) {
            result = this.baseFolder + path;
        } else if (path.startsWith("temp")) {
            result = this.baseFolder + path;
        } else if (path.startsWith("pdf")) {
            result = this.baseFolder + path;
        } else if (path.startsWith("sysAttachment")) {
            result = this.baseFolder + path;
        } else if (path.startsWith("personImg")) {
            result = this.baseFolder + path;
        } else {
            throw new Exception("\u7cfb\u7edf\u9519\u8bef\uff01\uff01\uff01");
        }
        return result;
    }

    public static void main(String[] args) {
        BaseService baseService = new BaseService();
        String url = "https://bcxin-saas-prod.obs.cn-north-1.myhuaweicloud.com:443/upload%2F2019-06-20%2F1561011269961011569.jpg";
        System.out.println("getResource.do?path=upload/2019-08-14/1565747021393.jpg".replaceAll("getResource.do\\?path=", ""));
    }
}

