/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.gxhlwWeb.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.gxhlwWebDto.AcceptDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.LoginLogService;
import com.bcxin.ars.service.PermissionService;
import com.bcxin.ars.service.PoliceRoleService;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.gxhlwWeb.GxhlwWebService;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.sys.RegisterpersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DES3;
import com.bcxin.ars.webservice.ClientUtil;
import com.bcxin.ars.webservice.Result;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class gxhlwWebServiceImpl
implements GxhlwWebService {
    Logger logger = LoggerFactory.getLogger(gxhlwWebServiceImpl.class);
    @Autowired
    private UserService userService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private PoliceService policeService;
    @Autowired
    private LoginLogService loginLogService;
    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private PoliceRoleService policeRoleService;
    @Autowired
    private ApprovalService approvalService;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private UserDao userDao;
    @Autowired
    private ClientUtil clientUtil;
    @Autowired
    private RegisterpersonService registerpersonService;
    @Value(value="${message-code-timeout}")
    private int messageCodeTimeout = 2;
    @Value(value="${login-timeout}")
    private int loginTimeout = 10;
    @Value(value="${JWT_SECRET}")
    public String JWT_SECRET = "";
    @Value(value="${BLB_PARTY}")
    public String BLB_PARTY = "ARS-NC";

    public AjaxResult verifySX(String username, String pwd, HttpServletRequest request) {
        AjaxResult ajaxResult = new AjaxResult();
        Result result = this.clientUtil.verifySXNW(username, pwd);
        if (result.getCODE().equals("200")) {
            ajaxResult = (AjaxResult)JSONObject.parseObject((String)result.getDATE().toString(), AjaxResult.class);
            if (ajaxResult.getState().equals(Constants.STATUS_SUCCESS)) {
                AcceptDto acceptDto = (AcceptDto)JSONObject.parseObject((String)ajaxResult.getData().toString(), AcceptDto.class);
                User user = new User();
                String a = acceptDto.getIdcardaddr();
                acceptDto.setIdcardaddr(null);
                user.setIdNumber(acceptDto.getIdcardaddr());
                user.setPhone(acceptDto.getMoblie());
                user.setPassword(acceptDto.getMoblie().substring(acceptDto.getMoblie().length() - 6, acceptDto.getMoblie().length()));
                user.setRealname(acceptDto.getName());
                user.setUsername(acceptDto.getMoblie());
                List data = this.userDao.searchByDto(user);
                if (data.size() == 0) {
                    AjaxResult userAjaxResult = this.registerpersonService.SXNWregister(user);
                    if (!userAjaxResult.isSuccessful()) {
                        ajaxResult.setState(Constants.STATUS_ERROR);
                        ajaxResult.setMsg("\u6ce8\u518c\u5931\u8d25");
                        throw new ArsException("\u6ce8\u518c\u5931\u8d25\uff01");
                    }
                    user.setPassword(acceptDto.getMoblie().substring(acceptDto.getMoblie().length() - 6, acceptDto.getMoblie().length()));
                } else {
                    user = (User)data.get(0);
                }
                AjaxResult loginAjaxResult = new AjaxResult();
                try {
                    loginAjaxResult = this.webLogin(user.getUsername(), user.getPassword(), 4, request);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    ajaxResult.setState(Constants.STATUS_ERROR);
                    ajaxResult.setSuccessful(false);
                    ajaxResult.setMsg("\u767b\u5f55\u5931\u8d25");
                }
                if (!loginAjaxResult.isSuccessful()) {
                    ajaxResult.setState(Constants.STATUS_ERROR);
                    ajaxResult.setMsg("\u767b\u5f55\u5931\u8d25");
                    ajaxResult.setSuccessful(false);
                    throw new ArsException("\u767b\u5f55\u5931\u8d25\uff01");
                }
                ajaxResult.setState(Constants.STATUS_SUCCESS);
                ajaxResult.setSuccessful(true);
            } else {
                ajaxResult.setState(Constants.STATUS_ERROR);
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("\u8d26\u53f7\u6216\u8005\u5bc6\u7801\u4e0d\u5339\u914d");
            }
        } else {
            ajaxResult.setState(Constants.STATUS_ERROR);
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u9a8c\u8bc1\u5931\u8d25");
        }
        return ajaxResult;
    }

    public AjaxResult verifyGXNW(String username, String key, HttpServletRequest request) {
        AjaxResult ajaxResult;
        block7: {
            ajaxResult = new AjaxResult();
            try {
                if ("BCXIN-ARS-GX-450000".equals(DES3.decode((String)key))) {
                    User user = new User();
                    user.setUsername(username);
                    User dbuser = this.userDao.find(user);
                    if (dbuser == null) {
                        ajaxResult.setState(Constants.STATUS_ERROR);
                        ajaxResult.setMsg("\u8b66\u53f7\u7528\u6237\u4e0d\u5b58\u5728");
                        ajaxResult.setSuccessful(false);
                        throw new ArsException("\u767b\u5f55\u5931\u8d25\uff01");
                    }
                    AjaxResult loginAjaxResult = new AjaxResult();
                    try {
                        loginAjaxResult = this.webLogin(user.getUsername(), user.getPassword(), 1, request);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        ajaxResult.setState(Constants.STATUS_ERROR);
                        ajaxResult.setSuccessful(false);
                        ajaxResult.setMsg("\u767b\u5f55\u5931\u8d25");
                    }
                    if (!loginAjaxResult.isSuccessful()) {
                        ajaxResult.setState(Constants.STATUS_ERROR);
                        ajaxResult.setMsg("\u767b\u5f55\u5931\u8d25");
                        ajaxResult.setSuccessful(false);
                        throw new ArsException("\u767b\u5f55\u5931\u8d25\uff01");
                    }
                    ajaxResult.setState(Constants.STATUS_SUCCESS);
                    ajaxResult.setSuccessful(true);
                    break block7;
                }
                ajaxResult.setState(Constants.STATUS_ERROR);
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("\u9a8c\u8bc1\u5931\u8d25");
            }
            catch (Exception e) {
                ajaxResult.setState(Constants.STATUS_ERROR);
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("\u9a8c\u8bc1\u5931\u8d25");
            }
        }
        return ajaxResult;
    }

    public AjaxResult webLogin(String username, String password, Integer platform, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(username, password, "DA1AFC8A62D75AE0A88B054A7F6667FC");
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            try {
                currentUser.login((AuthenticationToken)token);
            }
            catch (AuthenticationException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                result.setSuccessful(false);
                result.setMsg("\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef");
            }
            if (currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                User user = this.userService.findByUsername(username, platform.toString());
                System.out.println("\u5f53\u524d\u767b\u5f55\u7528\u6237\u662f\uff1a" + user.getUsername());
                user.setLoginstate(Integer.valueOf(1));
                if (user.getLoginNum() != null) {
                    user.setLoginNum(Integer.valueOf(user.getLoginNum() + 1));
                } else {
                    user.setLoginNum(Integer.valueOf(1));
                }
                user.setLoginDate(new Date());
                this.userService.updateLoginState(user);
                user.setSessionId(session.getId().toString());
                this.arsUtil.setCurrentUser(user, 120000 * this.loginTimeout);
                result.setData((Object)user);
                result.setSuccessful(true);
                this.loginLogService.logIn(request);
            }
        }
        catch (UnknownAccountException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            result.setSuccessful(false);
            result.setMsg("\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef");
        }
        catch (IncorrectCredentialsException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            result.setSuccessful(false);
            result.setMsg("\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef");
        }
        catch (ExcessiveAttemptsException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            result.setSuccessful(false);
            result.setMsg("\u767b\u5f55\u5931\u8d25\u591a\u6b21\uff0c\u8d26\u6237\u9501\u5b9a10\u5206\u949f");
        }
        catch (AuthenticationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return result;
    }
}

