/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.epidemic;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.epidemic.EpidemicDao;
import com.bcxin.ars.dao.epidemic.EpidemicDaoAop;
import com.bcxin.ars.dao.epidemic.RiskAreaDao;
import com.bcxin.ars.dao.task.ComTaskDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.epidemic.EpidemicSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.epidemic.Epidemic;
import com.bcxin.ars.model.epidemic.RiskArea;
import com.bcxin.ars.model.task.ComTask;
import com.bcxin.ars.service.epidemic.EpidemicService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Epidemic.class)
public class EpidemicServiceImpl
implements EpidemicService {
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private EpidemicDao epidemicDao;
    @Autowired
    private EpidemicDaoAop epidemicDaoAop;
    @Autowired
    private ComTaskDao comTaskDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private RiskAreaDao riskAreaDao;

    private void queryStreet(Epidemic record) {
        if (record.getStreetId() != null) {
            RiskArea riskArea = this.riskAreaDao.findById(record.getStreetId());
            record.setStreetName(riskArea.getStreetName());
            record.setRiskLevel(riskArea.getRiskLevel());
        }
    }

    public int insert(Epidemic record) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (currentUser == null) {
            throw new ArsException("\u7528\u6237\u4fe1\u606f\u7f3a\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\uff01");
        }
        record.setUserId(currentUser.getId());
        List list = new ArrayList();
        Epidemic queryP = new Epidemic();
        queryP.setUserId(currentUser.getId());
        if (record.getTaskId() != null) {
            queryP.setTaskId(record.getTaskId());
        } else {
            queryP.setTaskName(record.getTaskName());
        }
        list = this.epidemicDao.find(queryP);
        if (list != null && list.size() > 0) {
            if ("1".equals(record.getFilledType())) {
                throw new ArsException("\u4eca\u65e5\u5df2\u586b\u5199\u9a7b\u52e4\u70b9\u3010" + record.getTaskName() + "\u3011\u75ab\u60c5\u9632\u63a7\u4fe1\u606f");
            }
            throw new ArsException("\u4eca\u65e5\u5df2\u586b\u5199\u75ab\u60c5\u9632\u63a7\u4fe1\u606f");
        }
        this.queryCompanyInfo(record);
        this.queryTask(record);
        this.queryStreet(record);
        record.setActive(Boolean.valueOf(true));
        record.setCreateTime(new Date());
        record.setFilledByTime(new Date());
        record.setUpdateTime(new Date());
        record.setUpdateBy(currentUser == null ? "system" : currentUser.getUsername());
        return this.epidemicDao.insert(record);
    }

    public Epidemic findById(Long id) {
        return this.epidemicDao.findById(id);
    }

    private void queryCompanyInfo(Epidemic record) {
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCompany company = this.securityCompanyDao.findByUserid(currentUser.getId());
        if (company != null) {
            record.setOrgId(company.getOrgId() != null ? Long.valueOf(company.getOrgId()) : null);
            record.setAreaCode(company.getAreaCode());
            record.setOrgName(company.getOrgName());
            record.setCompanyName(company.getName());
        }
    }

    private void queryTask(Epidemic record) {
        if (record.getTaskId() != null) {
            ComTask task = this.comTaskDao.findById(record.getTaskId());
            record.setTaskAddress(task.getTaskAddress());
            record.setTaskName(task.getTaskName());
        }
    }

    public int update(Epidemic record) throws Exception {
        User currentUser = this.arsUtil.getCurrentUser();
        if (currentUser == null) {
            throw new ArsException("\u7528\u6237\u4fe1\u606f\u7f3a\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\uff01");
        }
        Epidemic dbEpidemic = this.findById(record.getId());
        if (!DateUtil.convertDateToString((Date)dbEpidemic.getCreateTime(), (String)"yyyy-MM-dd").equals(DateUtil.getCurrentDate())) {
            throw new ArsException("\u53ea\u80fd\u4fee\u6539\u5f53\u5929\u7684\u6570\u636e\uff01");
        }
        record.setUserId(currentUser.getId());
        List list = new ArrayList();
        Epidemic queryP = new Epidemic();
        queryP.setId(record.getId());
        queryP.setUserId(currentUser.getId());
        if (record.getTaskId() != null) {
            queryP.setTaskId(record.getTaskId());
        } else {
            queryP.setTaskName(record.getTaskName());
        }
        list = this.epidemicDao.find(queryP);
        if (list != null && list.size() > 0) {
            if ("1".equals(record.getFilledType())) {
                throw new ArsException("\u4eca\u65e5\u5df2\u586b\u5199\u9a7b\u52e4\u70b9\u3010" + record.getTaskName() + "\u3011\u75ab\u60c5\u9632\u63a7\u4fe1\u606f");
            }
            throw new ArsException("\u4eca\u65e5\u5df2\u586b\u5199\u75ab\u60c5\u9632\u63a7\u4fe1\u606f");
        }
        this.queryCompanyInfo(record);
        this.queryTask(record);
        this.queryStreet(record);
        record.setUpdateTime(new Date());
        record.setActive(Boolean.valueOf(true));
        record.setUpdateBy(currentUser == null ? "system" : currentUser.getUsername());
        return this.epidemicDaoAop.update(record);
    }

    public long findByStreetCount(Epidemic epidemic) {
        return this.epidemicDao.findByStreetCount(epidemic);
    }

    public List<Epidemic> searchForPage(EpidemicSearchDto searchDto, AjaxPageResponse<Epidemic> page) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (currentUser.getPlatform() == 2) {
            searchDto.setUserId(currentUser.getId());
        } else if (currentUser.getPlatform() == 1) {
            this.arsUtil.setPoliceSearchAll((SearchDto)searchDto);
        }
        return this.epidemicDao.searchForPage(searchDto, page);
    }

    public void saveOrUpdateForDS(Epidemic epidemic) {
        Epidemic dbEpidemic = this.findById(epidemic.getId());
        if (dbEpidemic != null && epidemic.getUpdateTime().getTime() >= dbEpidemic.getUpdateTime().getTime()) {
            this.epidemicDao.update(epidemic);
        } else {
            this.epidemicDao.insert(epidemic);
        }
    }

    public List<Epidemic> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.epidemicDao.searchForDataSynchronization(searchDto);
    }

    public int del(Epidemic record) {
        Epidemic dbEpidemic = this.findById((record = this.findById(record.getId())).getId());
        if (!DateUtil.convertDateToString((Date)dbEpidemic.getCreateTime(), (String)"yyyy-MM-dd").equals(DateUtil.getCurrentDate())) {
            throw new ArsException("\u53ea\u80fd\u5220\u9664\u5f53\u5929\u7684\u7684\u6570\u636e\uff01");
        }
        record.setActive(Boolean.valueOf(false));
        return this.epidemicDaoAop.update(record);
    }

    public Epidemic findNew(Long userId) {
        List list = this.epidemicDao.findByUserId(userId);
        if (list != null && list.size() > 0) {
            return (Epidemic)list.get(0);
        }
        return null;
    }

    public void saveCopyYesterdayData() {
        Epidemic epidemic = new Epidemic();
        User currentUser = this.arsUtil.getCurrentUser();
        epidemic.setUserId(currentUser.getId());
        epidemic.setFilledByTime(new Date());
        ArrayList<Epidemic> saveList = new ArrayList<Epidemic>();
        List toDayList = this.epidemicDao.findUserIdAndDate(epidemic);
        epidemic.setFilledByTime(DateUtil.convertStringToDate((String)DateUtil.getYesterday()));
        List yesterdayList = this.epidemicDao.findUserIdAndDate(epidemic);
        if (yesterdayList.size() == 0) {
            throw new ArsException("\u6628\u5929\u672a\u586b\u62a5\uff0c\u65e0\u6570\u636e\u53ef\u590d\u5236!");
        }
        for (Epidemic e : yesterdayList) {
            boolean addflag = true;
            for (Epidemic tmp : toDayList) {
                if (e.getTaskId() != null) {
                    if (!e.getTaskId().equals(tmp.getTaskId())) continue;
                    addflag = false;
                    break;
                }
                if (e.getTaskName() == null || !e.getTaskName().equals(tmp.getTaskName())) continue;
                addflag = false;
                break;
            }
            if (!addflag) continue;
            Epidemic newEpdiemic = new Epidemic();
            BeanUtils.copyPropertiesIgnore((Object)e, (Object)newEpdiemic);
            newEpdiemic.setId(null);
            newEpdiemic.setCreateTime(new Date());
            newEpdiemic.setFilledByTime(new Date());
            newEpdiemic.setUpdateTime(new Date());
            this.queryStreet(newEpdiemic);
            saveList.add(newEpdiemic);
        }
        if (saveList.size() <= 0) {
            throw new ArsException("\u6628\u5929\u6570\u636e\u5df2\u5168\u90e8\u590d\u5236\uff0c\u65e0\u987b\u518d\u64cd\u4f5c");
        }
        this.epidemicDao.saveBatch(saveList);
    }
}

