/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.approve.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.approve.ApproveAreaProDetailDao;
import com.bcxin.ars.dao.approve.ApproveAreaProcessDao;
import com.bcxin.ars.dao.approve.ApproveLinkDao;
import com.bcxin.ars.dao.approve.ApproveLinkLevelDao;
import com.bcxin.ars.dao.approve.ApproveLinkProDetailDao;
import com.bcxin.ars.dao.approve.ApproveTempConfigDao;
import com.bcxin.ars.dao.approve.ApproveTempDao;
import com.bcxin.ars.dao.approve.ApproveTempLinkDao;
import com.bcxin.ars.dao.approve.ApproveTempLinkRelaDao;
import com.bcxin.ars.dao.approve.ApproveTempProcessDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.approve.ApproveLinkProDetailDto;
import com.bcxin.ars.dto.approve.ApproveTempLinkRelaDto;
import com.bcxin.ars.dto.approve.CheckTempConfigDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.approve.ApproveAreaProcess;
import com.bcxin.ars.model.approve.ApproveLink;
import com.bcxin.ars.model.approve.ApproveLinkProDetail;
import com.bcxin.ars.model.approve.ApproveTemp;
import com.bcxin.ars.model.approve.ApproveTempConfig;
import com.bcxin.ars.model.approve.ApproveTempLink;
import com.bcxin.ars.model.approve.ApproveTempLinkRela;
import com.bcxin.ars.model.approve.ApproveTempProcess;
import com.bcxin.ars.service.approve.ApproveTempLinkService;
import com.bcxin.ars.service.util.ApprovalActivityUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.BusinessType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=ApproveTempLinkRela.class, getMethodName="updateFlagForOutToIn", getImportType=ImportType.BATCH)
public class ApproveTempLinkServiceImpl
implements ApproveTempLinkService {
    private static final Logger logger = LoggerFactory.getLogger(ApproveTempLinkServiceImpl.class);
    @Autowired
    private ApproveTempLinkDao approveTempLinkDao;
    @Autowired
    private ApproveTempLinkRelaDao approveTempLinkRelaDao;
    @Autowired
    private ApproveTempDao approveTempDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApproveAreaProcessDao approveAreaProcessDao;
    @Autowired
    private ApproveLinkProDetailDao approveLinkProDetailDao;
    @Autowired
    private ApproveAreaProDetailDao approveAreaProDetailDao;
    @Autowired
    private ApproveTempProcessDao approveTempProcessDao;
    @Autowired
    private ApproveLinkLevelDao approveLinkLevelDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ApproveLinkDao approveLinkDao;
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private ApproveTempConfigDao approveTempConfigDao;

    public void save(Long linkId, Long tempId) {
        ApproveLink approveLink = this.approveLinkDao.findById(linkId);
        ArrayList<ApproveTemp> allApproveTempList = new ArrayList<ApproveTemp>();
        ApproveTemp curApproveTemp = new ApproveTemp();
        curApproveTemp = this.approveTempDao.findById(tempId);
        if (!(curApproveTemp.getTempCode() == null || curApproveTemp.getTempCode().indexOf("activitipersoncertificateapprovalProcess") != -1 || approveLink.getLinkType() == null || " ".equals(approveLink.getLinkType()) || "5".equals(approveLink.getLinkType()) || "".equals(approveLink.getLinkType()))) {
            throw new ArsException("\u4e0d\u5141\u8bb8\u6dfb\u52a0\u7279\u6b8a\u73af\u8282\uff01");
        }
        allApproveTempList.add(curApproveTemp);
        User currentUser = this.arsUtil.getCurrentUser();
        String orgtype = currentUser.getPolice().getOrgtype();
        String createType = "";
        if (orgtype.equals("1")) {
            List approveTempCityList = this.approveTempDao.findByParentTempId(tempId);
            allApproveTempList.addAll(approveTempCityList);
            createType = "1";
        } else {
            createType = "0";
        }
        if (allApproveTempList != null && allApproveTempList.size() > 0) {
            for (ApproveTemp item : allApproveTempList) {
                ApproveTempLink dbapproveTempLink = this.approveTempLinkDao.findByTempAndLink(linkId, item.getId());
                if (dbapproveTempLink == null || !dbapproveTempLink.getActive().booleanValue()) continue;
                throw new ArsException("\u8be5\u5ba1\u6279\u73af\u8282\u5df2\u5b58\u5728\uff01");
            }
            List approveTempConfigList = this.approveTempConfigDao.find(tempId);
            for (ApproveTemp item : allApproveTempList) {
                Long policeId = item.getPoliceId();
                boolean is_exitConfig = false;
                if (approveTempConfigList != null && approveTempConfigList.size() > 0) {
                    for (ApproveTempConfig approveTempConfig : approveTempConfigList) {
                        if (!approveTempConfig.getPoliceId().equals(policeId)) continue;
                        is_exitConfig = true;
                        break;
                    }
                }
                if (is_exitConfig) continue;
                Long tempID_temp = item.getId();
                Long linkID_temp = linkId;
                List approveTempLinkList = this.approveTempLinkDao.findByTempId(tempID_temp);
                int countSj = 0;
                for (ApproveTempLink approveTempLink1 : approveTempLinkList) {
                    if (!orgtype.equals("1")) {
                        approveTempLink1.setSeq(approveTempLink1.getSeq() + 1L);
                        this.approveTempLinkDao.update(approveTempLink1);
                        continue;
                    }
                    if (approveTempLink1.getCreateType().equals("1")) {
                        approveTempLink1.setSeq(approveTempLink1.getSeq() + 1L);
                        this.approveTempLinkDao.update(approveTempLink1);
                        continue;
                    }
                    ++countSj;
                }
                ApproveTempLink approveTempLink = new ApproveTempLink();
                approveTempLink = this.approveTempLinkDao.findByTempAndLink(linkID_temp, tempID_temp);
                if (approveTempLink == null) {
                    approveTempLink = new ApproveTempLink();
                    ApproveLink approveLinkNew = new ApproveLink();
                    approveLinkNew.setId(linkID_temp);
                    ApproveTemp approveTempAdd = new ApproveTemp();
                    approveTempAdd.setId(tempID_temp);
                    approveTempLink.setApproveLink(approveLinkNew);
                    approveTempLink.setApproveTemp(approveTempAdd);
                    approveTempLink.setActive(Boolean.valueOf(true));
                    approveTempLink.setCreateTime(new Date());
                    if (orgtype.equals("1") && createType.equals("1")) {
                        if (item.getParentTempId() == null || "".equals(item.getParentTempId())) {
                            approveTempLink.setSeq(1L);
                        } else {
                            approveTempLink.setSeq((long)(countSj + 1));
                        }
                    } else {
                        approveTempLink.setSeq(1L);
                    }
                    approveTempLink.setCreateType(createType);
                    this.approveTempLinkDao.save(approveTempLink);
                } else {
                    approveTempLink.setActive(Boolean.valueOf(true));
                    approveTempLink.setUpdateBy(currentUser.getUsername());
                    approveTempLink.setUpdateTime(new Date());
                    approveTempLink.setCreateType(createType);
                    this.approveTempLinkDao.update(approveTempLink);
                }
                this.deleteApproveTempProcess(approveTempLink);
                item.setApproveSetStatus("2");
                this.approveTempDao.update(item);
            }
        }
    }

    private void deleteApproveTempProcess(ApproveTempLink approveTempLink) {
        ApproveTemp approveTemp = this.approveTempDao.findById(approveTempLink.getApproveTemp().getId());
        if (StringUtil.equals((String)approveTemp.getApproveSetStatus(), (String)"1")) {
            approveTemp.setApproveSetStatus("0");
            approveTemp.setFailureTime(new Date());
            approveTemp.setUpdateTime(new Date());
            approveTemp.setUpdateBy("2");
            this.approveTempDao.update(approveTemp);
            this.approveTempProcessDao.batchUpdateByApproveTempId(approveTemp);
        }
    }

    public void update(ApproveTempLink approveTempLink) {
        approveTempLink.setUpdateTime(new Date());
        this.approveTempLinkDao.update(approveTempLink);
        this.deleteApproveTempProcess(approveTempLink);
    }

    public void delete(Long tempLinkId) {
        ArrayList<ApproveTempLink> allApproveTempLinkList = new ArrayList<ApproveTempLink>();
        ApproveTempLink approveTempLinkCur = this.approveTempLinkDao.findById(tempLinkId);
        allApproveTempLinkList.add(approveTempLinkCur);
        User currentUser = this.arsUtil.getCurrentUser();
        String orgtype = currentUser.getPolice().getOrgtype();
        List approveTempCityList = null;
        if (orgtype.equals("1")) {
            Long tempId = approveTempLinkCur.getApproveTemp().getId();
            Long linkId = approveTempLinkCur.getApproveLink().getId();
            approveTempCityList = this.approveTempDao.findByParentTempId(tempId);
            if (approveTempCityList != null && approveTempCityList.size() > 0) {
                for (ApproveTemp approveTempCity : approveTempCityList) {
                    ApproveTempLink cityApproveTempLink = this.approveTempLinkDao.findByTempAndLink(linkId, approveTempCity.getId());
                    if (cityApproveTempLink == null) continue;
                    allApproveTempLinkList.add(cityApproveTempLink);
                }
            }
        }
        if (allApproveTempLinkList != null && allApproveTempLinkList.size() > 0) {
            for (ApproveTempLink approveTempLink : allApproveTempLinkList) {
                ApproveTemp approveTemp;
                approveTempLink.setUpdateTime(new Date());
                this.approveTempLinkDao.delete(approveTempLink);
                this.approveAreaProcessDao.deleteByApproveTempLinkId(approveTempLink);
                this.approveLinkProDetailDao.deleteByApproveTempLinkId(approveTempLink);
                this.approveAreaProDetailDao.deleteByApproveTempLinkId(approveTempLink);
                this.deleteApproveTempProcess(approveTempLink);
                List approveTempLinkList = this.approveTempLinkDao.findByMtSeq(Long.valueOf(approveTempLink.getSeq()), approveTempLink.getApproveTemp().getId());
                List approveTempLinkList1 = this.approveTempLinkDao.findByTempId(approveTempLink.getApproveTemp().getId());
                if (approveTempLinkList1.size() <= 0 && (approveTemp = this.approveTempDao.findById(approveTempLink.getApproveTemp().getId())) != null) {
                    approveTemp.setApproveSetStatus("0");
                    if (approveTemp.getId() != null) {
                        ApproveTemp dbApproveTemp = this.approveTempDao.findById(approveTemp.getId());
                        dbApproveTemp.setUpdateBy(currentUser.getUsername());
                        dbApproveTemp.setUpdateTime(new Date());
                        if (!StringUtils.isEmpty((Object)approveTemp.getTempName())) {
                            dbApproveTemp.setTempName(approveTemp.getTempName());
                        }
                        if (!StringUtils.isEmpty((Object)approveTemp.getApproveSetStatus())) {
                            dbApproveTemp.setApproveSetStatus(approveTemp.getApproveSetStatus());
                        }
                        if (!StringUtils.isEmpty((Object)approveTemp.getNoticeTemp())) {
                            dbApproveTemp.setNoticeTemp(approveTemp.getNoticeTemp());
                        }
                        if (!StringUtils.isEmpty((Object)approveTemp.getRepulseExplain())) {
                            dbApproveTemp.setRepulseExplain(approveTemp.getRepulseExplain());
                        }
                        this.approveTempDao.update(dbApproveTemp);
                    }
                }
                for (ApproveTempLink a : approveTempLinkList) {
                    a.setSeq(a.getSeq() - 1L);
                    a.setUpdateTime(new Date());
                    this.approveTempLinkDao.update(a);
                    this.deleteApproveTempProcess(a);
                }
                approveTemp = approveTempLink.getApproveTemp();
                if (approveTemp.getParentTempId() == null && !"11".equals(this.configUtils.getCurrentNative())) continue;
                try {
                    this.saveMainProcess(approveTemp);
                }
                catch (Exception e) {
                    logger.debug(e.getMessage());
                }
            }
        }
    }

    private String saveMainProcess(ApproveTemp approveTemp) throws Exception {
        Long approveTempId = approveTemp.getId();
        approveTemp = this.approveTempDao.findById(approveTempId);
        String approveTempName = approveTemp.getTempName();
        String tempCode = approveTemp.getTempCode();
        String businessTypeCode = "";
        String groupId = "";
        Config kzConfig = this.configDao.findByKey("kzzhid");
        if (kzConfig != null && StringUtil.isNotEmpty((String)kzConfig.getValue())) {
            groupId = kzConfig.getValue();
        }
        if (tempCode.contains("-")) {
            businessTypeCode = BusinessType.getBusinessType((String)tempCode.split("-")[0]);
        }
        String maxApproveLevel = this.approveTempDao.getMaxApproveLevelByApproveTempId(approveTempId);
        String configMsg = "";
        if (StringUtil.isNotEmpty((String)maxApproveLevel)) {
            User user = this.arsUtil.getCurrentUser();
            String orgtype = user.getPolice().getOrgtype();
            String superAreaCode = "";
            String superOrgtype = "";
            Long policeId = user.getPolice().getId();
            String areaCode = user.getPolice().getAreacode();
            if (orgtype.equals("1")) {
                areaCode = areaCode.substring(0, 2);
            } else if (orgtype.equals("2")) {
                areaCode = areaCode.substring(0, 2);
                superAreaCode = areaCode.substring(0, 2) + "0000";
                superOrgtype = "1";
            } else if (orgtype.equals("3")) {
                superAreaCode = areaCode.substring(0, 4) + "00";
                superOrgtype = "2";
            } else {
                superAreaCode = areaCode;
                superOrgtype = "3";
            }
            if (!orgtype.equals("1")) {
                CheckTempConfigDto checkDto = new CheckTempConfigDto();
                checkDto.setTempId(approveTempId);
                checkDto.setAreaCode(superAreaCode);
                checkDto.setOrgtype(superOrgtype);
                Long check = this.approveTempLinkRelaDao.checkTempConfigCompleteByOrgTypeAndCityCode(checkDto);
                if (check != null && check > 0L) {
                    configMsg = "\u6a21\u677f\u73af\u8282\u4e0a\u7ea7\u673a\u6784\u672a\u914d\u7f6e\u5b8c\u6210\uff01";
                    logger.info(configMsg);
                    return configMsg;
                }
            }
            List approveTempLinkRelaList = this.approveTempLinkRelaDao.findByApproveTempIdList(approveTempId);
            List policeList = new ArrayList<Police>();
            if (orgtype.equals("4")) {
                Police police = this.policeDao.findById(policeId);
                policeList.add(police);
            } else {
                policeList = this.policeDao.findPoliceByOrgTypeAndLikeAreacode(maxApproveLevel, areaCode);
            }
            if (policeList != null && policeList.size() > 0) {
                ArrayList<ApproveTempProcess> approveTempProcessList = new ArrayList<ApproveTempProcess>();
                for (Police police : policeList) {
                    String[] policeIds = police.getPath().split("/");
                    ApproveLinkProDetailDto searchDto = new ApproveLinkProDetailDto();
                    searchDto.setPoliceIds(policeIds);
                    ArrayList<ApproveTempLinkRelaDto> approveTempLinkRelaDtoList = new ArrayList<ApproveTempLinkRelaDto>();
                    if (approveTempLinkRelaList == null || approveTempLinkRelaList.size() <= 0) continue;
                    int tempLinkSize = approveTempLinkRelaList.size();
                    for (ApproveTempLinkRela approveTempLinkRela : approveTempLinkRelaList) {
                        ApproveTempLinkRelaDto approveTempLinkRelaDto;
                        Long tempLinkRelaId = approveTempLinkRela.getId();
                        String approveLevel = this.approveLinkLevelDao.getMaxApproveLevelByTempLinkRelaId(tempLinkRelaId);
                        if (StringUtil.isEmpty((String)approveLevel)) {
                            ApproveLink approveLink = this.approveLinkDao.findById(approveTempLinkRela.getApproveLinkId());
                            if (approveLink == null) continue;
                            if (StringUtils.isEmpty((Object)approveLink.getLinkType())) {
                                configMsg = "\u5ba1\u6279\u6d41\u7a0b\u672a\u542f\u52a8\uff1a\u5b58\u5728\u672a\u914d\u7f6e\u5ba1\u6279\u5355\u4f4d\u7684\u5ba1\u6279\u73af\u8282";
                                return configMsg;
                            }
                            approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
                            approveTempLinkRelaDto.setLinkName(approveLink.getLinkName());
                            approveTempLinkRelaDto.setLinkType(approveLink.getLinkType());
                            approveTempLinkRelaDtoList.add(approveTempLinkRelaDto);
                            continue;
                        }
                        searchDto.setTempLinkRelaId(tempLinkRelaId);
                        searchDto.setApproveLevel(approveLevel);
                        ApproveLinkProDetail pproveLinkProDetail = this.approveLinkProDetailDao.findListByTempLinkRelaIdAndPoliceIds(searchDto);
                        if (pproveLinkProDetail == null) break;
                        approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
                        approveTempLinkRelaDto = this.approveTempLinkRelaDao.findDtoById(pproveLinkProDetail.getTempLinkRelaId());
                        approveTempLinkRelaDto.setApproveLinkProDetailId(pproveLinkProDetail.getId());
                        approveTempLinkRelaDto.setApproveAreaProId(pproveLinkProDetail.getApproveAreaProId());
                        approveTempLinkRelaDtoList.add(approveTempLinkRelaDto);
                    }
                    if (approveTempLinkRelaDtoList == null || approveTempLinkRelaDtoList.size() <= 0 || tempLinkSize != approveTempLinkRelaDtoList.size()) continue;
                    if (businessTypeCode.equals("008")) {
                        ArrayList<ApproveAreaProcess> approveAreaProcessList = new ArrayList<ApproveAreaProcess>();
                        ApproveAreaProcess approveAreaProcess = this.approveAreaProcessDao.findById(((ApproveTempLinkRelaDto)approveTempLinkRelaDtoList.get(approveTempLinkRelaDtoList.size() - 1)).getApproveAreaProId());
                        if (approveAreaProcess != null) {
                            approveAreaProcessList.add(approveAreaProcess);
                        }
                        if (approveTempLinkRelaDtoList.size() > 1 && (approveAreaProcess = this.approveAreaProcessDao.findById(((ApproveTempLinkRelaDto)approveTempLinkRelaDtoList.get(approveTempLinkRelaDtoList.size() - 2)).getApproveAreaProId())) != null) {
                            approveAreaProcessList.add(approveAreaProcess);
                        }
                        ApprovalActivityUtil.thirdJsonUpdate(approveAreaProcessList);
                    }
                    ApproveTempProcess approveTempProcess = new ApproveTempProcess();
                    approveTempProcess.setCreateTime(new Date());
                    approveTempProcess.setUpdateTime(new Date());
                    approveTempProcess.setActive(Boolean.valueOf(true));
                    approveTempProcess.setApproveTempId(approveTempId);
                    approveTempProcess.setRegionLevel(police.getOrgtype());
                    approveTempProcess.setPoliceCode(StringUtil.isNotEmpty((String)police.getCode()) ? police.getCode().toString() : "");
                    approveTempProcess.setPoliceId(police.getId());
                    String processID = tempCode + "-" + police.getId().toString();
                    String processName = approveTempName + police.getOrgname();
                    approveTempProcess.setProcessInfo(ApprovalActivityUtil.oneJson(approveTempLinkRelaDtoList, processID, processName, groupId));
                    approveTempProcessList.add(approveTempProcess);
                }
                if (approveTempProcessList != null && approveTempProcessList.size() > 0) {
                    this.approveTempProcessDao.batchSave(approveTempProcessList);
                    ApproveTemp approveTempSave = this.approveTempDao.findById(approveTempId);
                    approveTempSave.setEffectTime(new Date());
                    approveTempSave.setUpdateTime(new Date());
                    approveTempSave.setApproveSetStatus("1");
                    this.approveTempDao.update(approveTempSave);
                }
            }
        } else {
            configMsg = "\u5ba1\u6279\u73af\u8282\u672a\u914d\u7f6e";
        }
        return configMsg;
    }

    public ApproveTempLink findById(Long id) {
        return this.approveTempLinkDao.findById(id);
    }

    public List<ApproveTempLink> findByTempId(Long tempId) {
        return this.approveTempLinkDao.findByTempId(tempId);
    }

    public List<ApproveTempLink> findByLinkId(Long linkId) {
        return this.approveTempLinkDao.findByLinkId(linkId);
    }

    public List<ApproveTempLink> findByMtSeq(Long seq, Long tempId) {
        return this.approveTempLinkDao.findByMtSeq(seq, tempId);
    }

    public void insertBatchTemp(List<ApproveTempLinkRela> approveList) {
        this.approveTempLinkRelaDao.insertBatchTemp(approveList);
    }

    public List<ApproveTempLinkRela> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.approveTempLinkRelaDao.searchForDataSynchronization(searchDto);
    }

    public ApproveTempLink findByMtSeqUp(Long seq, Long tempId) {
        return this.approveTempLinkDao.findByMtSeqUp(seq, tempId);
    }

    public ApproveTempLink findByMtSeqDown(Long seq, Long tempId) {
        return this.approveTempLinkDao.findByMtSeqDown(seq, tempId);
    }

    public void updateOrderUp(Long[] idArray) {
        User currentUser = this.arsUtil.getCurrentUser();
        String orgtype = currentUser.getPolice().getOrgtype();
        if (orgtype.equals("1")) {
            for (int i = 0; i < idArray.length; ++i) {
                ArrayList<ApproveTempLink> allApproveTempLinkList = new ArrayList<ApproveTempLink>();
                ApproveTempLink approveTempLinkCur = this.approveTempLinkDao.findById(idArray[i]);
                allApproveTempLinkList.add(approveTempLinkCur);
                List approveTempCityList = null;
                Long tempId = approveTempLinkCur.getApproveTemp().getId();
                Long linkId = approveTempLinkCur.getApproveLink().getId();
                approveTempCityList = this.approveTempDao.findByParentTempId(tempId);
                if (approveTempCityList != null && approveTempCityList.size() > 0) {
                    for (ApproveTemp approveTempCity : approveTempCityList) {
                        ApproveTempLink cityApproveTempLink = this.approveTempLinkDao.findByTempAndLink(linkId, approveTempCity.getId());
                        if (cityApproveTempLink == null) continue;
                        allApproveTempLinkList.add(cityApproveTempLink);
                    }
                }
                if (allApproveTempLinkList == null || allApproveTempLinkList.size() <= 0) continue;
                for (ApproveTempLink approveTempLink : allApproveTempLinkList) {
                    long seq = approveTempLink.getSeq();
                    ApproveTempLink approveTempLinkUp = this.approveTempLinkDao.findByMtSeqUp(Long.valueOf(approveTempLink.getSeq()), approveTempLink.getApproveTemp().getId());
                    approveTempLink.setSeq(approveTempLinkUp.getSeq());
                    approveTempLinkUp.setSeq(seq);
                    this.approveTempLinkDao.update(approveTempLink);
                    this.approveTempLinkDao.update(approveTempLinkUp);
                    ApproveTemp approveTemp = approveTempLink.getApproveTemp();
                    if (approveTemp.getParentTempId() == null && !"11".equals(this.configUtils.getCurrentNative())) continue;
                    try {
                        this.saveMainProcess(approveTemp);
                    }
                    catch (Exception e) {
                        logger.debug(e.getMessage());
                    }
                }
            }
        } else {
            Long approveTempId = null;
            for (int i = 0; i < idArray.length; ++i) {
                ApproveTempLink approveTempLink = this.approveTempLinkDao.findById(idArray[i]);
                if (i == 0) {
                    approveTempId = approveTempLink.getApproveTemp().getId();
                }
                long seq = approveTempLink.getSeq();
                ApproveTempLink approveTempLinkUp = this.approveTempLinkDao.findByMtSeqUp(Long.valueOf(approveTempLink.getSeq()), approveTempLink.getApproveTemp().getId());
                approveTempLink.setSeq(approveTempLinkUp.getSeq());
                approveTempLinkUp.setSeq(seq);
                this.approveTempLinkDao.update(approveTempLink);
                this.approveTempLinkDao.update(approveTempLinkUp);
            }
            ApproveTemp approveTemp = new ApproveTemp();
            approveTemp.setId(approveTempId);
            try {
                this.saveMainProcess(approveTemp);
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
            }
        }
    }

    public void updateOrderDown(Long[] idArray) {
        User currentUser = this.arsUtil.getCurrentUser();
        String orgtype = currentUser.getPolice().getOrgtype();
        if (orgtype.equals("1")) {
            for (int i = 0; i < idArray.length; ++i) {
                ArrayList<ApproveTempLink> allApproveTempLinkList = new ArrayList<ApproveTempLink>();
                ApproveTempLink approveTempLinkCur = this.approveTempLinkDao.findById(idArray[i]);
                allApproveTempLinkList.add(approveTempLinkCur);
                List approveTempCityList = null;
                Long tempId = approveTempLinkCur.getApproveTemp().getId();
                Long linkId = approveTempLinkCur.getApproveLink().getId();
                approveTempCityList = this.approveTempDao.findByParentTempId(tempId);
                if (approveTempCityList != null && approveTempCityList.size() > 0) {
                    for (ApproveTemp approveTempCity : approveTempCityList) {
                        ApproveTempLink cityApproveTempLink = this.approveTempLinkDao.findByTempAndLink(linkId, approveTempCity.getId());
                        if (cityApproveTempLink == null) continue;
                        allApproveTempLinkList.add(cityApproveTempLink);
                    }
                }
                if (allApproveTempLinkList == null || allApproveTempLinkList.size() <= 0) continue;
                for (ApproveTempLink approveTempLink : allApproveTempLinkList) {
                    long seq = approveTempLink.getSeq();
                    ApproveTempLink approveTempLinkDown = this.approveTempLinkDao.findByMtSeqDown(Long.valueOf(approveTempLink.getSeq()), approveTempLink.getApproveTemp().getId());
                    approveTempLink.setSeq(approveTempLinkDown.getSeq());
                    approveTempLinkDown.setSeq(seq);
                    this.approveTempLinkDao.update(approveTempLink);
                    this.approveTempLinkDao.update(approveTempLinkDown);
                    ApproveTemp approveTemp = approveTempLink.getApproveTemp();
                    if (approveTemp.getParentTempId() == null && !"11".equals(this.configUtils.getCurrentNative())) continue;
                    try {
                        this.saveMainProcess(approveTemp);
                    }
                    catch (Exception e) {
                        logger.debug(e.getMessage());
                    }
                }
            }
        } else {
            Long approveTempId = null;
            for (int i = 0; i < idArray.length; ++i) {
                ApproveTempLink approveTempLink = this.approveTempLinkDao.findById(idArray[i]);
                if (i == 0) {
                    approveTempId = approveTempLink.getApproveTemp().getId();
                }
                long seq = approveTempLink.getSeq();
                ApproveTempLink approveTempLinkDown = this.approveTempLinkDao.findByMtSeqDown(Long.valueOf(approveTempLink.getSeq()), approveTempLink.getApproveTemp().getId());
                approveTempLink.setSeq(approveTempLinkDown.getSeq());
                approveTempLinkDown.setSeq(seq);
                this.approveTempLinkDao.update(approveTempLink);
                this.approveTempLinkDao.update(approveTempLinkDown);
            }
            ApproveTemp approveTemp = new ApproveTemp();
            approveTemp.setId(approveTempId);
            try {
                this.saveMainProcess(approveTemp);
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
            }
        }
    }

    public void updateFlagForOutToIn(List<ApproveTempLinkRela> linkRelaList) {
        this.approveTempLinkRelaDao.updateFlagForOutToIn(linkRelaList);
    }
}

