package com.bcxin.ars.rest.task;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.task.PerTaskCardRecord;
import com.bcxin.ars.service.task.PerTaskCardRecordService;
import com.bcxin.ars.service.task.PersonClockInService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 *任务打卡记录
 */
@Controller
@RequestMapping("perTaskCardRecord")
public class PerTaskCardRecordController {
    private Logger logger = LoggerFactory.getLogger(PerTaskCardRecordController.class);
    @Autowired
    private PerTaskCardRecordService perTaskCardRecordService;
    @Autowired
    private PersonClockInService personClockInService;
    /**
     *保存打卡记录
     * @param cardRecord
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(String cardRecord){
        AjaxResult result = new AjaxResult();
        try {
            PerTaskCardRecord perTaskCardRecord = JSONObject.parseObject(cardRecord,PerTaskCardRecord.class);
            perTaskCardRecordService.save(perTaskCardRecord);
            personClockInService.savePerClockIn(perTaskCardRecord);
            result.setSuccessful(true);
            result.setMsg("保存成功");
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
            throw e;
        }
        return result;
    }
}
