package com.bcxin.ars.rest.task;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.task.ComTask;
import com.bcxin.ars.service.task.ComTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 驻勤点
 * @author linqinglin
 * @date 2019/10/11 0011 11:02
 */
@Controller
@RequestMapping("comTask")
public class ComTaskController {

    private Logger logger = LoggerFactory.getLogger(ComTaskController.class);

    @Autowired
    private ComTaskService comTaskService;

    /**
     * 保存驻勤点
     * @param comTask
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(String comTask){
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setMsg("保存成功");
            comTaskService.save(JSONObject.parseObject(comTask,ComTask.class));
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
            throw e;
        }
        return result;
    }

    /**
     * 删除驻勤点
     * @param taskIdList
     * @return
     */
    @RequestMapping("delete")
    @ResponseBody
    public AjaxResult delete(Long[] taskIdList){
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setMsg("删除成功");
            comTaskService.deleteBatch(taskIdList);
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
            throw e;
        }
        return result;
    }

    /**
     * 驻勤点新增人员
     * @param comTask
     * @param perIdListStr
     * @return
     */
    @RequestMapping("addPersons")
    @ResponseBody
    public AjaxResult addPersons(ComTask comTask,String perIdListStr){
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setMsg("新增成功");
            comTaskService.addPersons(comTask,perIdListStr);
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
            throw e;
        }
        return result;
    }

    /**
     * 驻勤点移除人员
     * @param comTask
     * @param perIdListStr
     * @return
     */
    @RequestMapping("removePersons")
    @ResponseBody
    public AjaxResult removePersons(ComTask comTask,String perIdListStr){
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setMsg("移除成功");
            comTaskService.removePersons(comTask,perIdListStr);
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
            throw e;
        }
        return result;
    }

}
