package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Legalchange;
import com.bcxin.ars.service.sb.LegalchangeService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
/**
 * 广西公安厅互联网+平台对接 服务公司（培训单位）项目变更申报
 * @author subh
 * @since jdk1.8
 * @see LegalchangeService#saveOrUpdate
 * @see ArsUtil#getCurrentUser
 */
@Controller
@RequestMapping("legalchange")
public class LegalchangeController {
	/**
	 * 日志
	 */
    Logger logger = LoggerFactory.getLogger(LegalchangeController.class);
	
	@Autowired
	private LegalchangeService legalchangeService;

	
	@Autowired
	private ArsUtil arsUtil;
	/**
	 * 服务公司（培训单位）项目变更申报新增或更新
	 * @param legalchange  服务公司（培训单位）项目变更申报表单数据
	 * @return 返回执行结果对象
	 * @throws Exception  系统异常
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody  AjaxResult saveOrUpdate(Legalchange legalchange) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				legalchangeService.saveOrUpdate(legalchange);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


}
