package com.bcxin.ars.rest;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SbRewardSearchDto;
import com.bcxin.ars.model.SbReward;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SbRewardService;
import com.bcxin.ars.service.SecurityPersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.List;

/**
 * 保安奖励
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年8月2日 上午9:42:54
 * @注意事项 </b>
 * <b>
 */

@Controller
@RequestMapping("sbReward")
public class SbRewardController {
	
	private static final Logger logger = LoggerFactory.getLogger(SbRewardController.class);
	
	@Autowired
	private SbRewardService sbRewardService;



	/**
	 * 创建或更新保安奖励信息
	 * @param dto 保安奖励信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(SbRewardSearchDto dto, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<SbReward> sbRewardList = JSON.parseArray(dto.getSbRewardList(), SbReward.class);
			sbRewardService.saveOrUpdateForSAAS(sbRewardList);
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(),e);
			result.setSuccessful(false);
			result.setMsg(e.getMessage());
		}
		return result;
	}
	/**
	 * 删除保安奖励信息
	 * @return
	 */
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(Long awardId) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<SbReward> sbRewardList = sbRewardService.findByAwardId(awardId);

			if(null!=sbRewardList  && sbRewardList.size()>0) {
				sbRewardService.deleteByawardId(awardId);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，awardId:" + awardId);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


}
