package com.bcxin.ars.dao.sb;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.sb.Yearreportdata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/06/18 0018 13:09
 */
@Service
public class YearreportdataDaoAop {


    @Autowired
    private YearreportdataDAO yearreportdataDao;

    @DataChangeAnnotation(getEntityClazz = Yearreportdata.class,
            getDaoClazz = YearreportdataDAO.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updatePoliceId(Yearreportdata yearreportdata){
        yearreportdataDao.updatePoliceId(yearreportdata);
    }

    @DataChangeAnnotation(getEntityClazz = Yearreportdata.class,
            getDaoClazz = YearreportdataDAO.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateStatistics(Yearreportdata yearreportdata){
        yearreportdataDao.updateStatistics(yearreportdata);
    }

    @DataChangeAnnotation(getEntityClazz = Yearreportdata.class,
            getDaoClazz = YearreportdataDAO.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateSealState(Yearreportdata yearreportdata){
        yearreportdataDao.updateSealState(yearreportdata);
    }

    @DataChangeAnnotation(getEntityClazz = Yearreportdata.class,
            getDaoClazz = YearreportdataDAO.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateOperator(Yearreportdata yearreportdata){
        yearreportdataDao.updateOperator(yearreportdata);
    }

    @DataChangeAnnotation(getEntityClazz = Yearreportdata.class,
            getDaoClazz = YearreportdataDAO.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void update(Yearreportdata yearreportdata){
        yearreportdataDao.update(yearreportdata);
    }

    @DataChangeAnnotation(getEntityClazz = Yearreportdata.class,
            getDaoClazz = YearreportdataDAO.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void updateBatch(List<Yearreportdata> list){
        yearreportdataDao.updateBatch(list);
    }

}
