package com.bcxin.ars.dao.sb;

import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.bcxin.ars.model.sb.Sponsorlicense;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author linqinglin
 * @date 2020/05/11 0011 17:28
 */
@Service
public class SponsorlicenseDaoAop {

    @Autowired
    private SponsorlicenseDao sponsorlicenseDao;

    @DataChangeAnnotation(getEntityClazz = Sponsorlicense.class,
            getDaoClazz = SponsorlicenseDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void updateCensorStatus(Sponsorlicense sponsorlicense) {
        sponsorlicenseDao.updateCensorStatus(sponsorlicense);
    }

    @DataChangeAnnotation(getEntityClazz = Sponsorlicense.class,
            getDaoClazz = SponsorlicenseDao.class,
            getParamClazz = Long.class,
            getSearchMethodName = "findByIdWithOutCache")
    public void update(Sponsorlicense sponsorlicense) {
        sponsorlicenseDao.update(sponsorlicense);
    }

    @DataChangeAnnotation(getEntityClazz = Sponsorlicense.class,
            getDaoClazz = SponsorlicenseDao.class,
            getParamType = ParamType.ENTITY,
            getParamClazz = List.class,
            getSearchMethodName = "findByBatchIdWithOutCache")
    public void updateBatch(List<Sponsorlicense> list){
        sponsorlicenseDao.updateBatch(list);
    }
}
