/*
 * Decompiled with CFR 0.152.
 */
package com.glodon.paas.foundation.restclient;

import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class RESTStreamRequestBody
extends RequestBody {
    private InputStream inputStream;
    private MediaType mediaType;
    private long contentLength;

    public static RequestBody create(MediaType mediaType, long contentLength, InputStream inputStream) {
        return new RESTStreamRequestBody(inputStream, contentLength, mediaType);
    }

    private RESTStreamRequestBody(InputStream inputStream, long contentLength, MediaType mediaType) {
        this.inputStream = inputStream;
        this.mediaType = mediaType;
        this.contentLength = contentLength;
    }

    public MediaType contentType() {
        return this.mediaType;
    }

    public long contentLength() {
        return this.contentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) throws IOException {
        Source source = null;
        try {
            source = Okio.source((InputStream)this.inputStream);
            sink.writeAll(source);
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (RuntimeException var2) {
                    throw var2;
                }
                catch (Exception exception) {}
            }
        }
    }
}

