/*
 * Decompiled with CFR 0.152.
 */
package com.glodon.paas.foundation.restclient;

public class RESTException
extends RuntimeException {
    private static final long serialVersionUID = 5232800682194546643L;
    private String method;
    private String requestUrl;
    private long errorCode;
    private String errorMessage;
    private int httpStatusCode;

    public RESTException(String method, String requestUrl, long errorCode, String errorMessage) {
        this.method = method;
        this.requestUrl = requestUrl;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.httpStatusCode = 200;
    }

    public RESTException(String method, String requestUrl, Throwable cause) {
        super(cause);
        this.method = method;
        this.requestUrl = requestUrl;
        this.errorCode = -1L;
        this.errorMessage = "other exception triggered, may be IO exception thrown by okhttp";
        this.httpStatusCode = -1;
    }

    public RESTException(int httpErrorStatusCode, String method, String requestUrl, String response) {
        this.method = method;
        this.requestUrl = requestUrl;
        this.errorCode = -1L;
        this.errorMessage = response;
        this.httpStatusCode = httpErrorStatusCode;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getMethod() {
        return this.method;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }

    @Override
    public String toString() {
        if (this.httpStatusCode != 0) {
            return String.format("Calling %s %s error, http request error, status: %d, response: %s", this.method, this.requestUrl, this.httpStatusCode, this.errorMessage);
        }
        return String.format("Calling %s %s error, error code: %d, error message: %s", this.method, this.requestUrl, this.errorCode, this.errorMessage);
    }
}

