/*
 * Decompiled with CFR 0.152.
 */
package com.glodon.paas.foundation.restclient;

import com.glodon.paas.foundation.restclient.CustomHttpLoggingInterceptor;
import com.glodon.paas.foundation.restclient.DefaultResponseChecker;
import com.glodon.paas.foundation.restclient.RESTException;
import com.glodon.paas.foundation.restclient.RESTResponseChecker;
import com.glodon.paas.foundation.restclient.RESTTokenFetcher;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.Buffer;
import okio.BufferedSource;
import org.apache.commons.lang3.StringUtils;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class RESTClientBuilder {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String AUTH_HEADER_NAME = "Authorization";
    protected static final String AUTH_HEADER_VALUE_FORMAT = "Bearer %s";
    private OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
    private GsonBuilder gsonBuilder = new GsonBuilder();
    private Retrofit.Builder retrofitBuilder = new Retrofit.Builder();
    private RESTResponseChecker responseChecker;
    private RESTTokenFetcher tokenFetcher;
    private long connectTimeoutMilli = 10000L;
    private long writeTimeoutMilli = 10000L;
    private long readTimeoutMilli = 10000L;
    private int retryTimes = 0;

    private static boolean _matchMediaType(MediaType t1, MediaType t2) {
        if (t1 == null && t2 == null) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)t1.type(), (CharSequence)t2.type()) && StringUtils.equalsIgnoreCase((CharSequence)t1.subtype(), (CharSequence)t2.subtype());
    }

    private static RESTResponseChecker _createDefaultResponseChecker() {
        return new DefaultResponseChecker();
    }

    private static String _extractString(ResponseBody responseBody, Charset charset) throws IOException {
        BufferedSource source = responseBody.source();
        source.request(Long.MAX_VALUE);
        Buffer buffer = source.buffer();
        return buffer.readString(charset);
    }

    private void _applyHttpInterceptor() {
        final RESTResponseChecker checker = this.responseChecker == null ? RESTClientBuilder._createDefaultResponseChecker() : this.responseChecker;
        final RESTTokenFetcher fetcher = this.tokenFetcher;
        this.httpClientBuilder.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                String token;
                String originAuthHeaderValue;
                Request request = chain.request();
                if (fetcher != null && ((originAuthHeaderValue = request.headers().get(RESTClientBuilder.AUTH_HEADER_NAME)) == null || originAuthHeaderValue.isEmpty()) && (token = fetcher.fetch()) != null && !token.isEmpty()) {
                    request = request.newBuilder().addHeader(RESTClientBuilder.AUTH_HEADER_NAME, String.format(RESTClientBuilder.AUTH_HEADER_VALUE_FORMAT, token)).build();
                }
                Response response = chain.proceed(request);
                ResponseBody responseBody = response.body();
                Charset charset = UTF8;
                MediaType contentType = responseBody.contentType();
                if (contentType != null) {
                    charset = contentType.charset(UTF8);
                }
                if (!response.isSuccessful()) {
                    throw new RESTException(response.code(), request.method(), request.url().toString(), RESTClientBuilder._extractString(responseBody, charset));
                }
                if (RESTClientBuilder._matchMediaType(MEDIA_TYPE_JSON, contentType)) {
                    String bodyString = RESTClientBuilder._extractString(responseBody, charset);
                    checker.check(request, bodyString);
                    return response.newBuilder().body(ResponseBody.create((MediaType)responseBody.contentType(), (String)bodyString)).build();
                }
                return response;
            }
        });
    }

    private void _applyTimeoutRetryInterceptor() {
        this.httpClientBuilder.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Response response = null;
                int i = 0;
                int tryTimes = RESTClientBuilder.this.retryTimes + 1;
                while (i++ < tryTimes) {
                    if (i > 1) {
                        if (response != null && response.code() != 504) break;
                        try {
                            Thread.sleep(RESTClientBuilder.this.retryIntervalTime(i - 1));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    try {
                        response = chain.proceed(request);
                    }
                    catch (SocketTimeoutException e) {
                        if (i != tryTimes) continue;
                        throw e;
                    }
                }
                return response;
            }
        });
    }

    private void _applyInterceptors() {
        this._applyHttpInterceptor();
        this._applyTimeoutRetryInterceptor();
    }

    private long retryIntervalTime(int times) {
        return new Random().nextInt(100) + (times - 1) * 1000 + 500;
    }

    public <T> T build(Class<T> service) {
        this._applyInterceptors();
        OkHttpClient httpClient = this.httpClientBuilder.connectTimeout(this.connectTimeoutMilli, TimeUnit.MILLISECONDS).writeTimeout(this.writeTimeoutMilli, TimeUnit.MILLISECONDS).readTimeout(this.readTimeoutMilli, TimeUnit.MILLISECONDS).build();
        Gson gson = this.gsonBuilder.create();
        this.retrofitBuilder.client(httpClient);
        this.retrofitBuilder = this.retrofitBuilder.addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson));
        Retrofit retrofit = this.retrofitBuilder.build();
        return (T)retrofit.create(service);
    }

    public RESTClientBuilder registerJSONTypeAdapter(Type type, Object typeAdapter) {
        this.gsonBuilder.registerTypeAdapter(type, typeAdapter);
        return this;
    }

    public RESTClientBuilder serviceBaseUrl(String baseUrl) {
        this.retrofitBuilder.baseUrl(baseUrl);
        return this;
    }

    public RESTClientBuilder responseChecker(RESTResponseChecker responseChecker) {
        this.responseChecker = responseChecker;
        return this;
    }

    public RESTClientBuilder tokenFetcher(RESTTokenFetcher tokenFetcher) {
        this.tokenFetcher = tokenFetcher;
        return this;
    }

    public RESTClientBuilder timeoutRetryTimes(int retryTimes) {
        if (retryTimes >= 0) {
            this.retryTimes = retryTimes;
        }
        return this;
    }

    public RESTClientBuilder timeoutMilli(long connect, long write, long read) {
        if (connect > 0L) {
            this.connectTimeoutMilli = connect;
        }
        if (write > 0L) {
            this.writeTimeoutMilli = write;
        }
        if (read > 0L) {
            this.readTimeoutMilli = read;
        }
        return this;
    }

    public RESTClientBuilder enableHttpLoggingInterceptor() {
        List<MediaType> excludeRequestBodyTypes = Collections.singletonList(MediaType.parse((String)"application/octet-stream"));
        return this.enableHttpLoggingInterceptor(excludeRequestBodyTypes);
    }

    public RESTClientBuilder enableHttpLoggingInterceptor(List<MediaType> excludeRequestBodyTypes) {
        CustomHttpLoggingInterceptor loggingInterceptor = new CustomHttpLoggingInterceptor(excludeRequestBodyTypes);
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        this.httpClientBuilder.addInterceptor((Interceptor)loggingInterceptor);
        return this;
    }

    public RESTClientBuilder enableGsonComplexMapKeySerialization() {
        this.gsonBuilder.enableComplexMapKeySerialization();
        return this;
    }

    public RESTClientBuilder setGsonserializeNulls() {
        this.gsonBuilder.serializeNulls();
        return this;
    }

    public RESTClientBuilder setGsonDateFormat(int pattern) {
        this.gsonBuilder.setDateFormat(pattern);
        return this;
    }

    public RESTClientBuilder setGsonFieldNamingPolicy(FieldNamingPolicy policy) {
        this.gsonBuilder.setFieldNamingPolicy(policy);
        return this;
    }

    public RESTClientBuilder setGsonPrettyPrinting() {
        this.gsonBuilder.setPrettyPrinting();
        return this;
    }

    public RESTClientBuilder setGsonVersion(double version) {
        this.gsonBuilder.setVersion(version);
        return this;
    }
}

