/*
 * Decompiled with CFR 0.152.
 */
package com.glodon.paas.foundation.restclient;

import com.glodon.paas.foundation.restclient.RESTException;
import com.glodon.paas.foundation.restclient.RESTResponseChecker;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import okhttp3.Request;

public class DefaultResponseChecker
implements RESTResponseChecker {
    @Override
    public void check(Request request, String responseString) throws RESTException {
        String url = request.url().toString();
        long code = 0L;
        String message = "";
        try {
            JsonReader reader = new JsonReader((Reader)new StringReader(responseString));
            reader.beginObject();
            while (reader.hasNext()) {
                String key;
                block6 : switch (key = reader.nextName()) {
                    case "code": {
                        switch (reader.peek()) {
                            case STRING: {
                                code = Long.parseLong(reader.nextString());
                                break block6;
                            }
                            case NUMBER: {
                                code = reader.nextLong();
                                break block6;
                            }
                        }
                        throw new RESTException(request.method(), url, -1L, "unrecognized code in response!");
                    }
                    case "message": {
                        message = reader.nextString();
                        break;
                    }
                    case "data": {
                        reader.skipValue();
                    }
                }
            }
            reader.endObject();
            reader.close();
        }
        catch (IOException e) {
            throw new RESTException(request.method(), url, e);
        }
        if (code != 0L) {
            throw new RESTException(request.method(), url, code, message);
        }
    }
}

