/*
 * Decompiled with CFR 0.152.
 */
package com.glodon.paas.foundation.restclient;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.Buffer;
import okio.BufferedSource;

public class CustomHttpLoggingInterceptor
implements Interceptor {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private volatile HttpLoggingInterceptor.Level level;
    private final HttpLoggingInterceptor.Logger logger;
    private final HttpLoggingInterceptor basicLoggingInterceptor;
    private final List<MediaType> excludeRequestBodyTypes;

    public CustomHttpLoggingInterceptor(List<MediaType> excludeRequestBodyTypes) {
        this(excludeRequestBodyTypes, HttpLoggingInterceptor.Logger.DEFAULT);
    }

    public CustomHttpLoggingInterceptor(List<MediaType> excludeRequestBodyTypes, HttpLoggingInterceptor.Logger logger) {
        this.excludeRequestBodyTypes = excludeRequestBodyTypes;
        this.basicLoggingInterceptor = new HttpLoggingInterceptor(logger);
        this.logger = logger;
    }

    public void setLevel(HttpLoggingInterceptor.Level level) {
        this.level = level;
        this.basicLoggingInterceptor.setLevel(level);
    }

    public HttpLoggingInterceptor.Level getLevel() {
        return this.level;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        RequestBody body = chain.request().body();
        if (this.level == HttpLoggingInterceptor.Level.BODY && body != null && this.excludeRequestBodyTypes != null && this.excludeRequestBodyTypes.contains(body.contentType())) {
            this.basicLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
            Response response = this.basicLoggingInterceptor.intercept(chain);
            this.logResponseBodyWithoutConsuming(response);
            this.basicLoggingInterceptor.setLevel(this.level);
            return response;
        }
        return this.basicLoggingInterceptor.intercept(chain);
    }

    private void logResponseBodyWithoutConsuming(Response response) throws IOException {
        if (!HttpHeaders.hasBody((Response)response)) {
            return;
        }
        this.logger.log("response body log start-->");
        if (this.bodyEncoded(response.headers())) {
            this.logger.log("<-- END HTTP (encoded body omitted)");
        } else {
            ResponseBody responseBody = response.body();
            BufferedSource source = responseBody.source();
            long contentLength = responseBody.contentLength();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            Charset charset = UTF8;
            MediaType contentType = responseBody.contentType();
            if (contentType != null) {
                try {
                    charset = contentType.charset(UTF8);
                }
                catch (UnsupportedCharsetException var26) {
                    this.logger.log("");
                    this.logger.log("Couldn't decode the response body; charset is likely malformed.");
                    this.logger.log("<-- END HTTP");
                    return;
                }
            }
            if (!this.isPlaintext(buffer)) {
                this.logger.log("");
                this.logger.log("<-- END HTTP (binary " + buffer.size() + "-byte body omitted)");
                return;
            }
            if (contentLength != 0L) {
                this.logger.log("");
                this.logger.log(buffer.clone().readString(charset));
            }
            this.logger.log("<-- END HTTP (" + buffer.size() + "-byte body)");
        }
    }

    private boolean bodyEncoded(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding != null && !contentEncoding.equalsIgnoreCase("identity");
    }

    private boolean isPlaintext(Buffer buffer) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException var6) {
            return false;
        }
    }
}

