/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.utils;

import javax.servlet.http.HttpServletRequest;

public class ServletRequestUtils {
    public static String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) && "0:0:0:0:0:0:0:1".equals(ip = request.getRemoteAddr())) {
            ip = "127.0.0.1";
        }
        if (ip != null && ip.length() > 0) {
            for (String ipAddr : ip.split(",")) {
                if ("unknown".equalsIgnoreCase(ip)) continue;
                return ipAddr;
            }
        }
        return ip;
    }

    public static String buildFullRequestUrl(HttpServletRequest request) {
        StringBuilder url = new StringBuilder();
        url.append(request.getScheme().toLowerCase()).append("://").append(request.getServerName());
        if ("http".equals(request.getScheme())) {
            if (request.getServerPort() != 80) {
                url.append(":").append(request.getServerPort());
            }
        } else if ("https".equals(request.getScheme()) && request.getServerPort() != 443) {
            url.append(":").append(request.getServerPort());
        }
        url.append(request.getRequestURI());
        if (request.getQueryString() != null) {
            url.append("?").append(request.getQueryString());
        }
        return url.toString();
    }
}

