/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RelativeDateFormat {
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final String ONE_SECOND_DISPLAY = "\u79d2";
    private static final String ONE_MINUTE_DISPLAY = "\u5206\u949f";
    private static final String ONE_HOUR_DISPLAY = "\u5c0f\u65f6";
    private static final String AGO = "\u524d";
    private static final String LATER = "\u540e";

    public static void main(String[] args) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:m:s");
        Date date = null;
        try {
            date = format.parse("2016-03-20 10:19:00");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        System.out.println(RelativeDateFormat.format(date));
    }

    public static String format(Date date) {
        long delta = new Date().getTime() - date.getTime();
        String agoOrLater = AGO;
        if (delta < 0L) {
            agoOrLater = LATER;
        }
        if ((delta = Math.abs(delta)) < 60000L) {
            long seconds = RelativeDateFormat.toSeconds(delta);
            return (seconds <= 0L ? 1L : seconds) + ONE_SECOND_DISPLAY + agoOrLater;
        }
        if (delta < 3600000L) {
            long minutes = RelativeDateFormat.toMinutes(delta);
            return (minutes <= 0L ? 1L : minutes) + ONE_MINUTE_DISPLAY + agoOrLater;
        }
        if (delta < 86400000L) {
            long hours = RelativeDateFormat.toHours(delta);
            return (hours <= 0L ? 1L : hours) + ONE_HOUR_DISPLAY + agoOrLater;
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    private static long toSeconds(long delta) {
        return delta / 1000L;
    }

    private static long toMinutes(long delta) {
        return RelativeDateFormat.toSeconds(delta) / 60L;
    }

    private static long toHours(long delta) {
        return RelativeDateFormat.toMinutes(delta) / 60L;
    }
}

