/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PasswordStrength {
    private static final int WEAK = 1;
    private static final int MEDIUM = 2;
    private static final int STRONG = 3;

    private int passwordStrength(String password) {
        Pattern p3;
        Matcher m3;
        Pattern p2;
        Matcher m2;
        if (password == null || password.length() < 6) {
            return 1;
        }
        int score = 0;
        score += password.length() * 4;
        score += this.checkRepetition(1, password).length() - password.length();
        score += this.checkRepetition(2, password).length() - password.length();
        score += this.checkRepetition(3, password).length() - password.length();
        score += this.checkRepetition(4, password).length() - password.length();
        Pattern p1 = Pattern.compile("^(.*[0-9].*[0-9].*[0-9].*)$");
        Matcher m1 = p1.matcher(password);
        if (m1.matches()) {
            score += 5;
        }
        if ((m2 = (p2 = Pattern.compile("^(.*[!,@,#,$,%,^,&,*,?,_,~].*[!,@,#,$,%,^,&,*,?,_,~].*)$")).matcher(password)).matches()) {
            score += 5;
        }
        if ((m3 = (p3 = Pattern.compile("^(.*[a-z].*[A-Z].*)|(.*[A-Z].*[a-z].*)$")).matcher(password)).matches()) {
            score += 10;
        }
        Pattern p4 = Pattern.compile("[a-zA-Z]");
        Matcher m4 = p4.matcher(password);
        Pattern p5 = Pattern.compile("[0-9]");
        Matcher m5 = p5.matcher(password);
        if (m4.find() && m5.find()) {
            score += 15;
        }
        Pattern p6 = Pattern.compile("[!,@,#,$,%,^,&,*,?,_,~]");
        Matcher m6 = p6.matcher(password);
        Pattern p7 = Pattern.compile("[0-9]");
        Matcher m7 = p7.matcher(password);
        if (m6.find() && m7.find()) {
            score += 15;
        }
        Pattern p8 = Pattern.compile("[a-zA-Z]");
        Matcher m8 = p8.matcher(password);
        Pattern p9 = Pattern.compile("[!,@,#,$,%,^,&,*,?,_,~]");
        Matcher m9 = p9.matcher(password);
        if (m8.find() && m9.find()) {
            score += 15;
        }
        Pattern p10 = Pattern.compile("^([a-zA-Z])+$");
        Matcher m10 = p10.matcher(password);
        Pattern p11 = Pattern.compile("^([0-9])+$");
        Matcher m11 = p11.matcher(password);
        if (m10.matches() || m11.matches()) {
            score -= 10;
        }
        if (score < 0) {
            score = 0;
        }
        if (score > 100) {
            score = 100;
        }
        if (score < 34) {
            return 1;
        }
        if (score < 68) {
            return 2;
        }
        return 3;
    }

    private String checkRepetition(int pLen, String str) {
        String res = "";
        for (int i = 0; i < str.length(); ++i) {
            int j;
            boolean repeated = true;
            for (j = 0; j < pLen && j + i + pLen < str.length(); ++j) {
                repeated = repeated && str.charAt(j + i) == str.charAt(j + i + pLen);
            }
            if (j < pLen) {
                repeated = false;
            }
            if (repeated) {
                i += pLen - 1;
                continue;
            }
            res = res + str.charAt(i);
        }
        return res;
    }

    public static void main(String[] args) {
        System.out.println(new PasswordStrength().passwordStrength("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"));
    }
}

