/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class IdentityCardUtils {
    private static final Pattern IDENTITY_CARD_PATTERN = Pattern.compile("^\\d{15}(\\d{2}[\\dx])?$", 2);
    private static final String[] VALID_PROVINCE_CODES = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private static final int[] WEIGHING = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final String[] VERIGY_CODES = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};

    public static boolean isValidIdentityCardNumber(String credentialNumber) {
        if (credentialNumber == null || credentialNumber.length() <= 0) {
            return false;
        }
        if (!IDENTITY_CARD_PATTERN.matcher(credentialNumber).matches()) {
            return false;
        }
        String provinceCode = credentialNumber.substring(0, 2);
        if (!IdentityCardUtils.isValidProvinceCode(provinceCode)) {
            return false;
        }
        String birthday = credentialNumber.length() == 18 ? credentialNumber.substring(6, 14) : "19" + credentialNumber.substring(6, 12);
        if (!IdentityCardUtils.isValidBirthday(birthday)) {
            return false;
        }
        return credentialNumber.length() != 18 || IdentityCardUtils.isValidVerifyCode(credentialNumber);
    }

    private static boolean isValidProvinceCode(String provinceCode) {
        if (provinceCode == null || provinceCode.length() != 2) {
            return false;
        }
        for (String s : VALID_PROVINCE_CODES) {
            if (!provinceCode.equals(s)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidBirthday(String strBirthday) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        sdf.setLenient(false);
        try {
            Date birthday = sdf.parse(strBirthday);
            if (birthday.before(new Date())) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isValidVerifyCode(String credentialNumber) {
        char[] chars = credentialNumber.substring(0, 17).toCharArray();
        int[] ints = new int[17];
        for (int i = 0; i < 17; ++i) {
            ints[i] = Integer.parseInt(String.valueOf(chars[i]));
        }
        int weightSum = 0;
        for (int i = 0; i < 17; ++i) {
            weightSum += ints[i] * WEIGHING[i];
        }
        int remainder = weightSum % 11;
        String verifyCode = VERIGY_CODES[remainder];
        return verifyCode.equalsIgnoreCase(credentialNumber.substring(17));
    }
}

