/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdGenerator {
    private static final Logger logger = LoggerFactory.getLogger(IdGenerator.class);
    private static final ReentrantLock lock = new ReentrantLock();
    private static final long twepoch = 1361753741828L;
    private static final long workerIdBits = 8L;
    private static final long maxWorkerId = 255L;
    private static final long sequenceBits = 5L;
    private static final long workerIdShift = 5L;
    private static final long timestampLeftShift = 13L;
    private static final long sequenceMask = 31L;
    private static long workerId;
    private static long lastTimestamp;
    private static long sequence;
    private static String DEFAULT_LOCAL_HOST;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextId() {
        lock.lock();
        try {
            long nextId;
            long timestamp = System.currentTimeMillis();
            if (lastTimestamp == timestamp) {
                if ((sequence = sequence + 1L & 0x1FL) == 0L) {
                    timestamp = IdGenerator.untilNextMillis(lastTimestamp);
                }
            } else {
                sequence = 0L;
            }
            if (timestamp < lastTimestamp) {
                try {
                    throw new Exception(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            lastTimestamp = timestamp;
            long l = nextId = timestamp - 1361753741828L << 13 | workerId << 5 | sequence;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public static String getUniqueId() {
        String uuid = UUID.randomUUID().toString();
        return uuid.replaceAll("-", "");
    }

    private static long untilNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    private static long getWorkerId() throws Exception {
        long id = IdGenerator.getWorkerIdFromIp();
        if (id == -1L) {
            id = IdGenerator.getWorkerIdFromMacAddress();
        }
        logger.info("IdGenerator; worker id:" + id);
        return id;
    }

    private static long getWorkerIdFromIp() {
        byte[] ipArray = IdGenerator.getValidIpFromLocalHost();
        if (ipArray == null) {
            ipArray = IdGenerator.getValidIpForEnvironmentHostName();
        }
        if (ipArray != null) {
            return 0xFFL & (long)ipArray[ipArray.length - 1];
        }
        return -1L;
    }

    private static byte[] getValidIpFromLocalHost() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (!DEFAULT_LOCAL_HOST.equals(localHost.getHostAddress())) {
                logger.info("IdGenerator; get ip from localhost: " + localHost.getHostAddress());
                return localHost.getAddress();
            }
        }
        catch (Exception e) {
            logger.error("IdGenerator; failed to get localhost ip: " + e.getMessage());
        }
        return null;
    }

    private static byte[] getValidIpForEnvironmentHostName() {
        try {
            String hostName = System.getenv("HOSTNAME");
            if (hostName == null) {
                return null;
            }
            logger.info("IdGenerator; hostname from environment: " + hostName);
            InetAddress host = InetAddress.getByName(hostName);
            if (!DEFAULT_LOCAL_HOST.equals(host.getHostAddress())) {
                logger.info("IdGenerator; get ip for environment host: " + host.getHostAddress());
                return host.getAddress();
            }
        }
        catch (Exception e) {
            logger.error("IdGenerator; failed to get ip for environment host name: " + e.getMessage());
        }
        return null;
    }

    private static long getWorkerIdFromMacAddress() throws Exception {
        long id = -1L;
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            byte[] hardwareAddress = networkInterface.getHardwareAddress();
            if (hardwareAddress == null) continue;
            id = 0xFFL & (long)hardwareAddress[hardwareAddress.length - 1];
            break;
        }
        return id;
    }

    static {
        sequence = 0L;
        DEFAULT_LOCAL_HOST = "127.0.0.1";
        try {
            workerId = IdGenerator.getWorkerId();
            if (workerId > 255L || workerId < 0L) {
                throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 255L));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

