/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static final String DATA_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static Date today() {
        return new Date();
    }

    public static Date yesterday() {
        return DateUtils.calDate(new Date(), -1);
    }

    public static Date lastMinute(Date date) {
        return DateUtils.strToDate(DateUtils.dateToStr(date) + " 23:59:59", TIME_FORMAT);
    }

    public static Date calDate(Date d, int days) {
        SimpleDateFormat format = new SimpleDateFormat(DATA_FORMAT);
        String date = format.format(d);
        d = DateUtils.strToDate(date);
        Calendar ca = Calendar.getInstance();
        ca.setTime(d);
        ca.add(5, days);
        return ca.getTime();
    }

    public static Date strToDate(String str) {
        return DateUtils.strToDate(str, DATA_FORMAT);
    }

    public static String dateToStr(Date date) {
        return DateUtils.dateToStr(date, DATA_FORMAT);
    }

    public static Date strToDate(String str, String format) {
        if (str == null || str.length() <= 0) {
            return new Date();
        }
        Date date = null;
        try {
            date = new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            date = new Date();
        }
        return date;
    }

    public static String dateToStr(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String timeToStr(Date date) {
        return new SimpleDateFormat(TIME_FORMAT).format(date);
    }

    public static int dateDiff(Date dateFrom, Date dateTo) {
        return (int)Math.abs((dateTo.getTime() - dateFrom.getTime()) / 86400000L) + 1;
    }
}

