/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.utils;

public class FileNameUtils {
    private static final String[] ILLEGAL_CHAR = new String[]{"/", "\n", "*", "\\", "<", ">", "|", "\"", ":", "?"};

    public static void checkFileName(String name) {
        if (name == null || name.length() <= 0) {
            throw new IllegalArgumentException("File name must not be empty.");
        }
        if (name.length() > 256) {
            throw new IllegalArgumentException("File name too long, no more than 256 characters.");
        }
        String suffix = FileNameUtils.getSuffix(name);
        if (suffix == null || suffix.length() <= 0) {
            throw new IllegalArgumentException("File name has no suffix.");
        }
        if (FileNameUtils.containsIllegalChar(name)) {
            throw new IllegalArgumentException("File name contains illegal character.");
        }
    }

    public static void checkFileType(String[] allSupportedType, String name) {
        String suffix = FileNameUtils.getSuffix(name);
        for (String s : allSupportedType) {
            if (!s.equalsIgnoreCase(suffix)) continue;
            return;
        }
        throw new IllegalArgumentException("File type not supported.");
    }

    private static String getSuffix(String name) {
        if (name.indexOf(".") == -1) {
            return null;
        }
        String suffix = null;
        if (name != null && name.length() > 0) {
            suffix = name.substring(name.lastIndexOf(".") + 1, name.length());
        }
        return suffix;
    }

    private static boolean containsIllegalChar(String value) {
        for (String x : ILLEGAL_CHAR) {
            if (!value.contains(x)) continue;
            return true;
        }
        return false;
    }
}

