/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.bimface.exception.BimfaceException;
import com.bimface.sdk.client.ApiClient;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.service.AccessTokenService;

public class ViewTokenService {
    private ApiClient apiClient;
    private AccessTokenService accessTokenService;

    public ViewTokenService(Endpoint endpoint, AccessTokenService accessTokenService) {
        this.apiClient = ApiClient.getApiClient(endpoint.getApiHost());
        this.accessTokenService = accessTokenService;
    }

    public String getViewTokenByFileId(Long fileId) throws BimfaceException {
        return this.getViewTokenByFileId(fileId, this.accessTokenService.getAccessToken());
    }

    public String getViewTokenByFileId(Long fileId, String accessToken) throws BimfaceException {
        return this.apiClient.getViewToken(fileId, null, null, accessToken);
    }

    public String getViewTokenByIntegrateId(Long integrateId) throws BimfaceException {
        return this.getViewTokenByIntegrateId(integrateId, this.accessTokenService.getAccessToken());
    }

    public String getViewTokenByIntegrateId(Long integrateId, String accessToken) throws BimfaceException {
        return this.apiClient.getViewToken(null, integrateId, null, accessToken);
    }

    public String getViewTokenByCompareId(Long compareId) throws BimfaceException {
        return this.getViewTokenByCompareId(compareId, this.accessTokenService.getAccessToken());
    }

    public String getViewTokenByCompareId(Long compareId, String accessToken) throws BimfaceException {
        return this.apiClient.getViewToken(null, null, compareId, accessToken);
    }
}

