/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.bimface.api.bean.request.translate.FileTranslateRequest;
import com.bimface.api.bean.request.translate.TranslateQueryRequest;
import com.bimface.api.bean.response.FileTranslateBean;
import com.bimface.api.bean.response.FileTranslateDetailBean;
import com.bimface.exception.BimfaceException;
import com.bimface.page.PagedList;
import com.bimface.sdk.client.ApiClient;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.utils.AssertUtils;

public class TranslateService {
    private ApiClient apiClient;
    private AccessTokenService accessTokenService;

    public TranslateService(Endpoint endpoint, AccessTokenService accessTokenService) {
        this.apiClient = ApiClient.getApiClient(endpoint.getApiHost());
        this.accessTokenService = accessTokenService;
    }

    public FileTranslateBean translate(FileTranslateRequest request) throws BimfaceException {
        return this.translate(request, this.accessTokenService.getAccessToken());
    }

    public FileTranslateBean translate(FileTranslateRequest request, String accessToken) throws BimfaceException {
        this.check(request);
        return this.apiClient.translate(request, accessToken);
    }

    public FileTranslateBean getTranslate(Long fileId) throws BimfaceException {
        return this.getTranslate(fileId, this.accessTokenService.getAccessToken());
    }

    public FileTranslateBean getTranslate(Long fileId, String accessToken) throws BimfaceException {
        return this.apiClient.getTranslation(fileId, accessToken);
    }

    public PagedList<FileTranslateDetailBean> getTranslates(TranslateQueryRequest translateQueryRequest) throws BimfaceException {
        return this.apiClient.getTranslations(translateQueryRequest, this.accessTokenService.getAccessToken());
    }

    private void check(FileTranslateRequest request) {
        AssertUtils.assertParameterNotNull(request, "TranslateRequest");
        AssertUtils.assertParameterNotNull(request.getSource(), "source");
        AssertUtils.assertParameterNotNull(request.getSource().getFileId(), "fileId");
    }
}

