/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.bimface.api.bean.compatible.response.BatchDeleteResultBean;
import com.bimface.api.bean.compatible.response.ShareLinkBean;
import com.bimface.exception.BimfaceException;
import com.bimface.page.PagedList;
import com.bimface.sdk.client.ApiClient;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.service.AccessTokenService;
import java.util.List;

public class ShareLinkService {
    private ApiClient apiClient;
    private AccessTokenService accessTokenService;

    public ShareLinkService(Endpoint endpoint, AccessTokenService accessTokenService) {
        this.apiClient = ApiClient.getApiClient(endpoint.getApiHost());
        this.accessTokenService = accessTokenService;
    }

    public ShareLinkBean createShare(Long fileId, Integer activeHours) throws BimfaceException {
        return this.apiClient.createShare(fileId, null, activeHours, null, false, this.accessTokenService.getAccessToken());
    }

    public ShareLinkBean createShare(Long fileId, String expireDate, Boolean needPassword) throws BimfaceException {
        return this.apiClient.createShare(fileId, null, null, expireDate, needPassword, this.accessTokenService.getAccessToken());
    }

    public ShareLinkBean createShare(Long fileId) throws BimfaceException {
        return this.createShare(fileId, null);
    }

    public String deleteShare(Long fileId) throws BimfaceException {
        return this.apiClient.deleteShare(fileId, null, this.accessTokenService.getAccessToken());
    }

    public ShareLinkBean createIntegrateShare(Long integrateId, Integer activeHours) throws BimfaceException {
        return this.apiClient.createShare(null, integrateId, activeHours, null, false, this.accessTokenService.getAccessToken());
    }

    public ShareLinkBean createIntegrateShare(Long integrateId, String expireDate, Boolean needPassword) throws BimfaceException {
        return this.apiClient.createShare(null, integrateId, null, expireDate, needPassword, this.accessTokenService.getAccessToken());
    }

    public ShareLinkBean createIntegrateShare(Long integrateId) throws BimfaceException {
        return this.createIntegrateShare(integrateId, null);
    }

    public String deleteIntegrateShare(Long integrateId) throws BimfaceException {
        return this.apiClient.deleteShare(null, integrateId, this.accessTokenService.getAccessToken());
    }

    public BatchDeleteResultBean<Long> batchDeteleShare(List<Long> sourceIds) throws BimfaceException {
        return this.apiClient.batchDeteleShare(sourceIds, this.accessTokenService.getAccessToken());
    }

    public ShareLinkBean getShareLink(String token) throws BimfaceException {
        return this.apiClient.getShareLink(token, null, null, this.accessTokenService.getAccessToken());
    }

    public ShareLinkBean getTranslateShare(Long fileId) throws BimfaceException {
        return this.apiClient.getShareLink(null, fileId, null, this.accessTokenService.getAccessToken());
    }

    public ShareLinkBean getIntegrateShare(Long integrateId) throws BimfaceException {
        return this.apiClient.getShareLink(null, null, integrateId, this.accessTokenService.getAccessToken());
    }

    public PagedList<ShareLinkBean> shareList(Integer pageNo, Integer pageSize) throws BimfaceException {
        return this.apiClient.shareList(this.accessTokenService.getAccessToken(), pageNo, pageSize);
    }
}

