/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.bimface.api.bean.response.databagDerivative.DatabagDerivativeBean;
import com.bimface.exception.BimfaceException;
import com.bimface.sdk.bean.request.OfflineDatabagRequest;
import com.bimface.sdk.client.ApiClient;
import com.bimface.sdk.client.DataClient;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.service.AccessTokenService;
import java.util.List;

public class OfflineDatabagService {
    private ApiClient apiClient;
    private DataClient dataClient;
    private AccessTokenService accessTokenService;

    public OfflineDatabagService(Endpoint endpoint, AccessTokenService accessTokenService) {
        this.apiClient = ApiClient.getApiClient(endpoint.getApiHost());
        this.dataClient = DataClient.getDataClient(endpoint.getApiHost() + "/data/");
        this.accessTokenService = accessTokenService;
    }

    public DatabagDerivativeBean generateOfflineDatabag(OfflineDatabagRequest request) throws BimfaceException {
        if (request.getFileId() != null) {
            return this.apiClient.createTranslateOfflineDatabag(request.getFileId(), request.getCallback(), this.accessTokenService.getAccessToken());
        }
        if (request.getIntegrateId() != null) {
            return this.apiClient.createIntegateOfflineDatabag(request.getIntegrateId(), request.getCallback(), this.accessTokenService.getAccessToken());
        }
        if (request.getCompareId() != null) {
            return this.apiClient.createCompareOfflineDatabag(request.getCompareId(), request.getCallback(), this.accessTokenService.getAccessToken());
        }
        throw new NullPointerException("'fileId', 'integrateId', 'compareId' can't be all empty");
    }

    public List<? extends DatabagDerivativeBean> queryOfflineDatabag(OfflineDatabagRequest request) throws BimfaceException {
        if (request.getFileId() != null) {
            return this.apiClient.getTranslateOfflineDatabag(request.getFileId(), this.accessTokenService.getAccessToken());
        }
        if (request.getIntegrateId() != null) {
            return this.apiClient.getIntegateOfflineDatabag(request.getIntegrateId(), this.accessTokenService.getAccessToken());
        }
        if (request.getCompareId() != null) {
            return this.apiClient.getCompareOfflineDatabag(request.getCompareId(), this.accessTokenService.getAccessToken());
        }
        throw new NullPointerException("'fileId', 'integrateId', 'compareId' can't be all empty");
    }

    public String getOfflineDatabagUrl(OfflineDatabagRequest request) throws BimfaceException {
        return this.dataClient.getDatabagDownloadUrl(request.getFileId(), request.getIntegrateId(), request.getCompareId(), "offline", request.getDatabagVersion(), this.accessTokenService.getAccessToken());
    }
}

