/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.bimface.api.bean.request.integrate.FileIntegrateRequest;
import com.bimface.api.bean.request.integrate.IntegrateQueryRequest;
import com.bimface.api.bean.response.FileIntegrateBean;
import com.bimface.api.bean.response.FileIntegrateDetailBean;
import com.bimface.exception.BimfaceException;
import com.bimface.page.PagedList;
import com.bimface.sdk.client.ApiClient;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.service.AccessTokenService;

public class IntegrateService {
    private ApiClient apiClient;
    private AccessTokenService accessTokenService;

    public IntegrateService(Endpoint endpoint, AccessTokenService accessTokenService) {
        this.apiClient = ApiClient.getApiClient(endpoint.getApiHost());
        this.accessTokenService = accessTokenService;
    }

    public FileIntegrateBean integrate(FileIntegrateRequest request) throws BimfaceException {
        return this.apiClient.integrate(request, this.accessTokenService.getAccessToken());
    }

    public FileIntegrateBean getIntegrate(Long integrateId) throws BimfaceException {
        return this.apiClient.getIntegrate(integrateId, this.accessTokenService.getAccessToken());
    }

    public PagedList<FileIntegrateDetailBean> getIntegrates(IntegrateQueryRequest integrateQueryRequest) throws BimfaceException {
        return this.apiClient.getIntegrates(integrateQueryRequest, this.accessTokenService.getAccessToken());
    }

    public void deleteIntegrate(Long integrateId) throws BimfaceException {
        this.apiClient.deleteIntegrate(integrateId, this.accessTokenService.getAccessToken());
    }
}

