/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.bimface.data.bean.Floor;
import com.bimface.exception.BimfaceException;
import com.bimface.sdk.client.DataClient;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.service.AccessTokenService;
import java.util.List;
import java.util.Map;

public class FloorService {
    private DataClient dataClient;
    private AccessTokenService accessTokenService;

    public FloorService(Endpoint endpoint, AccessTokenService accessTokenService) {
        this.dataClient = DataClient.getDataClient(endpoint.getApiHost() + "/data/");
        this.accessTokenService = accessTokenService;
    }

    public List<Floor> getFileFloors(Long fileId, Boolean includeArea, Boolean includeRoom) throws BimfaceException {
        return this.dataClient.getSingleModelFloors(fileId, includeArea, includeRoom, this.accessTokenService.getAccessToken());
    }

    public List<Floor> getIntegrateFloors(Long integrateId, Boolean includeArea, Boolean includeRoom) throws BimfaceException {
        return this.dataClient.getIntegrateModelFloors(integrateId, includeArea, includeRoom, this.accessTokenService.getAccessToken());
    }

    public List<Map<String, Object>> getSingleModelFileIdFloorsMapping(List<String> fileIds, Boolean includeArea, Boolean includeRoom) throws BimfaceException {
        return this.dataClient.getSingleModelFileIdFloorsMapping(fileIds, includeArea, includeRoom, this.accessTokenService.getAccessToken());
    }
}

