/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.bimface.exception.BimfaceException;
import com.bimface.file.bean.AppendFileBean;
import com.bimface.file.bean.FileBean;
import com.bimface.file.bean.FileUploadStatusBean;
import com.bimface.file.bean.SupportFileBean;
import com.bimface.file.bean.UploadPolicyBean;
import com.bimface.sdk.bean.request.FileBatchQueryRequest;
import com.bimface.sdk.bean.request.FileUploadRequest;
import com.bimface.sdk.client.FileClient;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.constants.BimfaceConstants;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.utils.AssertUtils;
import com.bimface.sdk.utils.FileNameUtils;
import com.bimface.sdk.utils.StringUtils;
import com.glodon.paas.foundation.restclient.RESTStreamRequestBody;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class FileService {
    private AccessTokenService accessTokenService;
    private FileClient fileClient;

    public FileService(Endpoint endpoint, AccessTokenService accessTokenService) {
        this.fileClient = FileClient.getFileClient(endpoint.getFileHost());
        this.accessTokenService = accessTokenService;
    }

    public FileBean upload(FileUploadRequest fileUploadRequest) throws BimfaceException {
        return this.upload(fileUploadRequest, this.accessTokenService.getAccessToken());
    }

    public FileBean upload(FileUploadRequest fileUploadRequest, String accessToken) throws BimfaceException {
        this.check(fileUploadRequest, accessToken);
        FileBean fileBean = fileUploadRequest.isByUrl() ? this.fileClient.uploadFileByUrl(fileUploadRequest.getName(), fileUploadRequest.getSourceId(), fileUploadRequest.getUrl(), fileUploadRequest.getEtag(), accessToken) : (fileUploadRequest.isByOSS() ? this.fileClient.uploadFileFromOSS(fileUploadRequest.getName(), fileUploadRequest.getSourceId(), fileUploadRequest.getBucket(), fileUploadRequest.getObjectKey(), accessToken) : this.fileClient.uploadFileStream(fileUploadRequest.getName(), fileUploadRequest.getSourceId(), fileUploadRequest.getContentLength(), fileUploadRequest.getInputStream(), accessToken));
        return fileBean;
    }

    public UploadPolicyBean getPolicy(String name, String sourceId) throws BimfaceException {
        return this.getPolicy(name, sourceId, this.accessTokenService.getAccessToken());
    }

    public UploadPolicyBean getPolicy(String name, String sourceId, String accessToken) throws BimfaceException {
        FileNameUtils.checkFileName(name);
        if (StringUtils.isNullOrEmpty(sourceId)) {
            sourceId = "";
        }
        SupportFileBean supportFileBean = this.fileClient.getSupportFileTypes(accessToken);
        String[] allSupportedType = supportFileBean.getTypes();
        FileNameUtils.checkFileType(allSupportedType, name);
        return this.fileClient.getUploadPolicy(name, sourceId, accessToken);
    }

    public FileBean uploadByPolicy(String name, String sourceId, Long contentLength, InputStream inputStream) throws BimfaceException {
        return this.uploadByPolicy(name, sourceId, contentLength, inputStream, this.accessTokenService.getAccessToken());
    }

    public FileBean uploadByPolicy(String name, String sourceId, Long contentLength, InputStream inputStream, String accessToken) throws BimfaceException {
        this.check(new FileUploadRequest(name, sourceId, contentLength, inputStream), accessToken);
        UploadPolicyBean policy = this.getPolicy(name, sourceId, accessToken);
        return this.uploadByPolicy(policy, name, contentLength, inputStream, accessToken);
    }

    private FileBean uploadByPolicy(UploadPolicyBean policy, String name, Long contentLength, InputStream inputStream, String accessToken) throws BimfaceException {
        if (contentLength == null || contentLength < 0L) {
            try {
                contentLength = inputStream.available();
            }
            catch (IOException e) {
                throw new BimfaceException("invalid input stream", e);
            }
        }
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("key", policy.getObjectKey()).addFormDataPart("success_action_status", "200").addFormDataPart("Content-Disposition", "attachment;filename=" + name).addFormDataPart("OSSAccessKeyId", policy.getAccessId()).addFormDataPart("policy", policy.getPolicy()).addFormDataPart("Signature", policy.getSignature()).addFormDataPart("callback", policy.getCallbackBody()).addFormDataPart("file", name, RESTStreamRequestBody.create(MediaType.parse((String)"application/octet-stream"), contentLength, inputStream)).build();
        return this.fileClient.uploadByPolicy(policy.getHost(), (RequestBody)body);
    }

    public void check(FileUploadRequest fileUploadRequest, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileUploadRequest, "fileUploadRequest");
        FileNameUtils.checkFileName(fileUploadRequest.getName());
        SupportFileBean supportFileBean = this.fileClient.getSupportFileTypes(accessToken);
        String[] allSupportedType = supportFileBean.getTypes();
        FileNameUtils.checkFileType(allSupportedType, fileUploadRequest.getName());
        if (fileUploadRequest.isByUrl()) {
            AssertUtils.checkUrl(fileUploadRequest.getUrl());
        } else if (!fileUploadRequest.isByOSS()) {
            if (fileUploadRequest.getContentLength() == null || fileUploadRequest.getContentLength() < 0L) {
                throw new IllegalArgumentException("ContentLength is null.");
            }
            AssertUtils.assertParameterNotNull(fileUploadRequest.getInputStream(), "inputStream");
            AssertUtils.checkFileLength(supportFileBean.getLength(), fileUploadRequest.getContentLength());
        }
    }

    public void deleteFile(Long fileId) throws BimfaceException {
        this.fileClient.deleteFile(fileId, this.accessTokenService.getAccessToken());
    }

    public AppendFileBean createAppendFile(String name, String sourceId, Long length) throws BimfaceException {
        return this.createAppendFile(name, sourceId, length, this.accessTokenService.getAccessToken());
    }

    public AppendFileBean createAppendFile(String name, String sourceId, Long length, String accessToken) throws BimfaceException {
        FileNameUtils.checkFileName(name);
        AssertUtils.assertParameterNotNull(length, "length");
        if (StringUtils.isNullOrEmpty(sourceId)) {
            sourceId = "";
        }
        SupportFileBean supportFileBean = this.fileClient.getSupportFileTypes(accessToken);
        String[] allSupportedType = supportFileBean.getTypes();
        FileNameUtils.checkFileType(allSupportedType, name);
        return this.fileClient.createAppendFile(name, sourceId, length, accessToken);
    }

    public AppendFileBean queryAppendFile(Long appendFileId) throws BimfaceException {
        return this.queryAppendFile(appendFileId, this.accessTokenService.getAccessToken());
    }

    public AppendFileBean queryAppendFile(Long appendFileId, String accessToken) throws BimfaceException {
        return this.fileClient.getAppendFile(appendFileId, accessToken);
    }

    public AppendFileBean uploadAppendFile(InputStream inputStream, Long appendFileId) throws BimfaceException {
        return this.uploadAppendFile(inputStream, appendFileId, this.accessTokenService.getAccessToken());
    }

    public AppendFileBean uploadAppendFile(InputStream inputStream, Long appendFileId, String accessToken) throws BimfaceException {
        AppendFileBean appendFileBean = this.queryAppendFile(appendFileId, accessToken);
        RequestBody body = FileService.requestIOFromPosition(inputStream, appendFileBean);
        return this.fileClient.appendUpload(appendFileId, appendFileBean.getPosition(), body, accessToken);
    }

    private static RequestBody requestIOFromPosition(final InputStream inputStream, final AppendFileBean appendFileBean) {
        if (inputStream == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody(){

            public MediaType contentType() {
                return MediaType.parse((String)"application/octet-stream");
            }

            public long contentLength() {
                return appendFileBean.getLength() - appendFileBean.getPosition();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void writeTo(BufferedSink sink) throws IOException {
                try {
                    int l;
                    inputStream.skip(appendFileBean.getPosition());
                    byte[] buffer = new byte[BimfaceConstants.PUT_THRESHOLD];
                    while ((l = inputStream.read(buffer)) != -1) {
                        sink.outputStream().write(buffer, 0, l);
                    }
                }
                finally {
                    sink.close();
                }
            }
        };
    }

    @Deprecated
    public FileBean getFileMetadata(Long fileId) throws BimfaceException {
        return this.fileClient.getFileMetaData(fileId, this.accessTokenService.getAccessToken());
    }

    public FileBean getFile(Long fileId) throws BimfaceException {
        return this.fileClient.getFile(fileId, this.accessTokenService.getAccessToken());
    }

    public List<FileBean> getFiles(FileBatchQueryRequest request) throws BimfaceException {
        String startTime = null;
        String endTime = null;
        String status = null;
        LocalDate from = request.getStartTime();
        LocalDate to = request.getEndTime();
        Long offset = request.getOffset();
        Long rows = request.getRows();
        if (from != null && to != null) {
            AssertUtils.assertTrue(from.isBefore(to), "start time must be earlier than end time");
        }
        if (from != null) {
            startTime = from.toString();
        }
        if (to != null) {
            endTime = to.toString();
        }
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("offset must be equal or greater than 0");
        }
        if (rows != null) {
            AssertUtils.assertParameterInRange(rows, 1L, 500L);
        }
        if (request.getStatus() != null) {
            status = request.getStatus().getName();
        }
        return this.fileClient.getFiles(request.getSuffix(), status, startTime, endTime, offset, rows, this.accessTokenService.getAccessToken());
    }

    public FileUploadStatusBean getFileUploadStatus(Long fileId) throws BimfaceException {
        return this.fileClient.getFileUploadStatus(fileId, this.accessTokenService.getAccessToken());
    }

    public SupportFileBean getSupportedFileTypes() throws BimfaceException {
        return this.fileClient.getSupportFileTypes(this.accessTokenService.getAccessToken());
    }
}

