/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.bimface.data.bean.ElementPropertyFilterRequest;
import com.bimface.data.bean.ElementsWithBoundingBox;
import com.bimface.data.bean.MaterialInfo;
import com.bimface.data.bean.Property;
import com.bimface.exception.BimfaceException;
import com.bimface.sdk.bean.request.QueryElementIdsRequest;
import com.bimface.sdk.client.DataClient;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.service.AccessTokenService;
import java.util.List;

public class ElementService {
    private DataClient dataClient;
    private AccessTokenService accessTokenService;

    public ElementService(Endpoint endpoint, AccessTokenService accessTokenService) {
        this.dataClient = DataClient.getDataClient(endpoint.getApiHost() + "/data/");
        this.accessTokenService = accessTokenService;
    }

    @Deprecated
    public List<String> getElements(Long fileId, String floor, String specialty, String categoryId, String family, String familyType) throws BimfaceException {
        return this.dataClient.getSingleModelElements(fileId, specialty, floor, categoryId, family, familyType, this.accessTokenService.getAccessToken());
    }

    @Deprecated
    public ElementsWithBoundingBox getIntegrateElements(Long integrateId, String floor, String specialty, String categoryId, String family, String familyType) throws BimfaceException {
        return this.dataClient.getIntegrateModelElements(integrateId, specialty, floor, categoryId, family, familyType, null, this.accessTokenService.getAccessToken());
    }

    public List<String> getElementIdsV2(Long fileId, QueryElementIdsRequest queryElementIdsRequest) throws BimfaceException {
        return this.dataClient.getSingleModelElementIds(fileId, queryElementIdsRequest, this.accessTokenService.getAccessToken());
    }

    public Property getSingleModelElementV2(Long fileId, String elementId, boolean includeOverrides) throws BimfaceException {
        return this.dataClient.getSingleModelElement(fileId, elementId, includeOverrides, this.accessTokenService.getAccessToken());
    }

    public List<Property> getSingleModelElementsV2(Long fileId, List<String> elementIds) throws BimfaceException {
        return this.getSingleModelElementsV2(fileId, elementIds, null, false);
    }

    public List<Property> getSingleModelElementsV2(Long fileId, List<String> elementIds, List<ElementPropertyFilterRequest.GroupAndKeysPair> filter, boolean includeOverrides) throws BimfaceException {
        ElementPropertyFilterRequest propertyFilterRequest = new ElementPropertyFilterRequest();
        propertyFilterRequest.setElementIds(elementIds);
        propertyFilterRequest.setFilter(filter);
        return this.dataClient.getSingleModelElements(fileId, includeOverrides, propertyFilterRequest, this.accessTokenService.getAccessToken());
    }

    public List<MaterialInfo> getSingleModelMaterials(Long fileId, String elementId) throws BimfaceException {
        return this.dataClient.getSingleModelElementMaterials(fileId, elementId, this.accessTokenService.getAccessToken());
    }
}

