/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.bimface.exception.BimfaceException;
import com.bimface.sdk.client.FileClient;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.service.AccessTokenService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadService {
    private static final Logger logger = LoggerFactory.getLogger(DownloadService.class);
    private FileClient fileClient;
    private AccessTokenService accessTokenService;

    public DownloadService(Endpoint endpoint, AccessTokenService accessTokenService) {
        this.fileClient = FileClient.getFileClient(endpoint.getFileHost());
        this.accessTokenService = accessTokenService;
    }

    public String getDownloadUrl(String accessToken, Long fileId) throws BimfaceException {
        return this.getDownloadUrl(fileId, null, accessToken);
    }

    public String getDownloadUrl(Long fileId) throws BimfaceException {
        return this.getDownloadUrl(this.accessTokenService.getAccessToken(), fileId);
    }

    public String getDownloadUrl(Long fileId, String fileName) throws BimfaceException {
        return this.getDownloadUrl(fileId, fileName, this.accessTokenService.getAccessToken());
    }

    public String getDownloadUrl(Long fileId, String fileName, String accessToken) throws BimfaceException {
        return this.fileClient.getFileDownloadUrl(fileId, fileName, accessToken);
    }

    public InputStream getFileContent(Long fileId, String name) throws BimfaceException {
        return this.getFileContent(fileId, name, this.accessTokenService.getAccessToken());
    }

    public InputStream getFileContent(Long fileId, String name, String accessToken) throws BimfaceException {
        String url = name == null ? this.getDownloadUrl(accessToken, fileId) : this.getDownloadUrl(fileId, name, accessToken);
        logger.debug("download by url[{}]", (Object)url);
        try {
            return new URL(url).openStream();
        }
        catch (IOException e) {
            throw new BimfaceException("download by url error, url: " + url, e);
        }
    }
}

