/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.bimface.exception.BimfaceException;
import com.bimface.sdk.client.DataClient;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.utils.AssertUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class DatabagService {
    private DataClient dataClient;
    private AccessTokenService accessTokenService;

    public DatabagService(Endpoint endpoint, AccessTokenService accessTokenService) {
        this.dataClient = DataClient.getDataClient(endpoint.getApiHost() + "/data/");
        this.accessTokenService = accessTokenService;
    }

    public InputStream getFileDatabagContent(Long fileId) throws BimfaceException {
        String dataBagUrl = this.getFileDatabagUrl(fileId);
        try {
            return new URL(dataBagUrl).openStream();
        }
        catch (IOException e) {
            throw new BimfaceException("download by url error, url: " + dataBagUrl, e);
        }
    }

    public String getFileDatabagUrl(Long fileId) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileId, "fileId");
        String accessToken = this.accessTokenService.getAccessToken();
        return this.dataClient.getDatabagDownloadUrl(fileId, null, null, null, null, accessToken);
    }

    public Long getFileDatabagSize(Long fileId) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileId, "fileId");
        return this.dataClient.getDatabagSize(fileId, this.accessTokenService.getAccessToken());
    }

    public String getFileDataBagRootUrl(Long fileId) throws BimfaceException {
        return this.dataClient.getFileDatabagRootUrl(fileId, this.accessTokenService.getAccessToken());
    }

    public String getIntegrateDatabagRootUrl(Long integrateId) throws BimfaceException {
        return this.dataClient.getIntegrateDatabagRootUrl(integrateId, this.accessTokenService.getAccessToken());
    }
}

