/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.bimface.data.bean.Area;
import com.bimface.data.bean.BusinessAssociationRequest;
import com.bimface.data.bean.BusinessElementAssociation;
import com.bimface.data.bean.DrawingSheet;
import com.bimface.data.bean.ElementBusinessAssociation;
import com.bimface.data.bean.ElementIdWithName;
import com.bimface.data.bean.ElementsWithBoundingBox;
import com.bimface.data.bean.FileIdHashWithElementIds;
import com.bimface.data.bean.FileTreeRequestBody;
import com.bimface.data.bean.FileViews;
import com.bimface.data.bean.IntegrateFileData;
import com.bimface.data.bean.IntegrationTreeOptionalRequestBody;
import com.bimface.data.bean.Link;
import com.bimface.data.bean.MaterialInfo;
import com.bimface.data.bean.MaterialOverrideSetVO;
import com.bimface.data.bean.ModelCompareChange;
import com.bimface.data.bean.ModelCompareDiff;
import com.bimface.data.bean.Pagination;
import com.bimface.data.bean.Property;
import com.bimface.data.bean.PropertyGroup;
import com.bimface.data.bean.PropertyValuesResp;
import com.bimface.data.bean.RfaFamilyType;
import com.bimface.data.bean.RfaFamilyTypeProperty;
import com.bimface.data.bean.Room;
import com.bimface.data.bean.SearchAreaIdsResp;
import com.bimface.data.bean.SearchElementIdsResp;
import com.bimface.data.bean.SearchRoomIdsResp;
import com.bimface.data.bean.SegmentDto;
import com.bimface.data.bean.SegmentGroupDto;
import com.bimface.data.bean.Tree;
import com.bimface.data.bean.View;
import com.bimface.data.enums.ToleranceType;
import com.bimface.exception.BimfaceException;
import com.bimface.sdk.bean.request.QueryElementIdsRequest;
import com.bimface.sdk.client.DataClient;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.utils.AssertUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DataService {
    private DataClient dataClient;
    private AccessTokenService accessTokenService;

    public DataService(Endpoint endpoint, AccessTokenService accessTokenService) {
        this.dataClient = DataClient.getDataClient(endpoint.getApiHost() + "/data/");
        this.accessTokenService = accessTokenService;
    }

    public List<View> getSingleModelViews(Long fileId) throws BimfaceException {
        return this.dataClient.getSingleModelViews(fileId, this.accessTokenService.getAccessToken());
    }

    public List<Room> getSingleModelRooms(Long fileId, String floorId, String elementId, ToleranceType roomToleranceZ, ToleranceType roomToleranceXY) throws BimfaceException {
        AssertUtils.assertTrue(StringUtils.isNotBlank((CharSequence)floorId) || StringUtils.isNotBlank((CharSequence)elementId), "floorId or elementId can't be both empty or blank");
        return this.dataClient.getSingleModelRooms(fileId, floorId, elementId, roomToleranceZ, roomToleranceXY, this.accessTokenService.getAccessToken());
    }

    public Room getSingleModelRoom(Long fileId, String roomId) throws BimfaceException {
        return this.dataClient.getSingleModelRoom(fileId, roomId, this.accessTokenService.getAccessToken());
    }

    public List<Area> getSingleModelAreas(Long fileId, String floorId) throws BimfaceException {
        return this.dataClient.getSingleModelAreas(fileId, floorId, this.accessTokenService.getAccessToken());
    }

    public Area getSingleModelArea(Long fileId, String areaId) throws BimfaceException {
        return this.dataClient.getSingleModelArea(fileId, areaId, this.accessTokenService.getAccessToken());
    }

    public List<Tree.TreeNode> getSingleModelTreeV2(Long fileId, FileTreeRequestBody requestBody) throws BimfaceException {
        return this.dataClient.getSingleModelTreeV2(fileId, requestBody, this.accessTokenService.getAccessToken());
    }

    public Tree getSingleModelCustomizedTree(Long fileId, FileTreeRequestBody requestBody) throws BimfaceException {
        return this.dataClient.getSingleModelCustomizedTree(fileId, requestBody, this.accessTokenService.getAccessToken());
    }

    public List<Link> getSingleModelLinks(Long fileId) throws BimfaceException {
        return this.dataClient.getSingleModelLinks(fileId, this.accessTokenService.getAccessToken());
    }

    public List<DrawingSheet> getSingleModelDrawingSheets(Long fileId, String elementId) throws BimfaceException {
        return this.dataClient.getSingleModelDrawingSheets(fileId, elementId, this.accessTokenService.getAccessToken());
    }

    public Object getSingleModelModelInfo(Long fileId) throws BimfaceException {
        return this.dataClient.getSingleModelModelInfo(fileId, this.accessTokenService.getAccessToken());
    }

    public List<ElementIdWithName> getSingleModelChildElementIds(Long fileId, String elementId) throws BimfaceException {
        return this.dataClient.getSingleModelChildElementIds(fileId, elementId, this.accessTokenService.getAccessToken());
    }

    public String updateSingleModelElementProperties(Long fileId, String elementId, List<PropertyGroup> propertyGroups) throws BimfaceException {
        return this.dataClient.updateSingleModelElementProperties(fileId, elementId, propertyGroups, this.accessTokenService.getAccessToken());
    }

    public String deleteSingleModelElementProperties(Long fileId, String elementId, List<PropertyGroup> propertyGroups) throws BimfaceException {
        return this.dataClient.deleteSingleModelElementProperties(fileId, elementId, propertyGroups, this.accessTokenService.getAccessToken());
    }

    public ElementsWithBoundingBox getIntegrateModelElementIds(Long integrateId, QueryElementIdsRequest queryElementIdsRequest) throws BimfaceException {
        return this.dataClient.getIntegrateModelElementIds(integrateId, queryElementIdsRequest, this.accessTokenService.getAccessToken());
    }

    public String updateIntegrateModelElementProperties(Long integrateId, String fileIdHash, String elementId, List<PropertyGroup> propertyGroups) throws BimfaceException {
        return this.dataClient.updateIntegrateModelElementProperties(integrateId, fileIdHash, elementId, propertyGroups, this.accessTokenService.getAccessToken());
    }

    public String deleteIntegrateModelElementProperties(Long integrateId, String fileIdHash, String elementId, List<PropertyGroup> propertyGroups) throws BimfaceException {
        return this.dataClient.deleteIntegrateModelElementProperties(integrateId, fileIdHash, elementId, propertyGroups, this.accessTokenService.getAccessToken());
    }

    public Property getIntegrateModelElement(Long integrateId, String fileIdHash, String elementId, Boolean includeOverrides) throws BimfaceException {
        return this.dataClient.getIntegrateModelElement(integrateId, fileIdHash, elementId, includeOverrides, this.accessTokenService.getAccessToken());
    }

    public Property getIntegrateModelElement(Long integrateId, String elementId) throws BimfaceException {
        return this.dataClient.getIntegrateModelElement(integrateId, elementId, this.accessTokenService.getAccessToken());
    }

    public List<MaterialInfo> getIntegrateModelElementMaterials(Long integrateId, String fileIdHash, String elementId) throws BimfaceException {
        return this.dataClient.getIntegrateModelElementMaterials(integrateId, fileIdHash, elementId, this.accessTokenService.getAccessToken());
    }

    public Tree getIntegrateModelTree(Long integrateId, String treeType, List<String> desiredHierarchy, IntegrationTreeOptionalRequestBody requestBody) throws BimfaceException {
        return this.dataClient.getIntegrateModelTree(integrateId, treeType, desiredHierarchy, requestBody, this.accessTokenService.getAccessToken());
    }

    public List<FileViews> getIntegrateModelFileViews(Long integrateId, String viewType) throws BimfaceException {
        return this.dataClient.getIntegrateModelFileViews(integrateId, viewType, this.accessTokenService.getAccessToken());
    }

    public List<Room> getIntegrateModelRooms(Long integrateId, String floorId, String elementId, ToleranceType roomToleranceZ, ToleranceType roomToleranceXY) throws BimfaceException {
        AssertUtils.assertTrue(StringUtils.isNotBlank((CharSequence)floorId) || StringUtils.isNotBlank((CharSequence)elementId), "floorId or elementId can't be both empty or blank");
        return this.dataClient.getIntegrateModelRooms(integrateId, floorId, elementId, roomToleranceZ, roomToleranceXY, this.accessTokenService.getAccessToken());
    }

    public Room getIntegrateModelRoom(Long integrateId, String roomId) throws BimfaceException {
        return this.dataClient.getIntegrateModelRoom(integrateId, roomId, this.accessTokenService.getAccessToken());
    }

    public List<Area> getIntegrateModelAreas(Long integrateId, String floorId) throws BimfaceException {
        return this.dataClient.getIntegrateModelAreas(integrateId, floorId, this.accessTokenService.getAccessToken());
    }

    public Area getIntegrateModelArea(Long integrateId, String areaId) throws BimfaceException {
        return this.dataClient.getIntegrateModelArea(integrateId, areaId, this.accessTokenService.getAccessToken());
    }

    public List<IntegrateFileData> getIntegrateFiles(Long integrateId) throws BimfaceException {
        return this.dataClient.getIntegrateFiles(integrateId, this.accessTokenService.getAccessToken());
    }

    public String getIntegrateModelViewToken(Long integrateId, String fileId) throws BimfaceException {
        return this.dataClient.getIntegrateModelViewToken(integrateId, fileId, this.accessTokenService.getAccessToken());
    }

    public List<SegmentGroupDto> getIntegrateModelSegmentGroups(Long integrateId) throws BimfaceException {
        return this.dataClient.getIntegrateModelSegmentGroups(integrateId, this.accessTokenService.getAccessToken());
    }

    public List<SegmentGroupDto> getIntegrateModelSegmentTree(Long integrateId) throws BimfaceException {
        return this.dataClient.getIntegrateModelSegmentTree(integrateId, this.accessTokenService.getAccessToken());
    }

    public List<SegmentDto> getIntegrateModelSegments(Long integrateId, String segmentGroupId) throws BimfaceException {
        return this.dataClient.getIntegrateModelSegments(integrateId, segmentGroupId, this.accessTokenService.getAccessToken());
    }

    public List<String> getIntegrateModelSegmentElementIds(Long integrateId, String segmentId) throws BimfaceException {
        return this.dataClient.getIntegrateModelSegmentElementIds(integrateId, segmentId, this.accessTokenService.getAccessToken());
    }

    public Property getIntegrateModelCommonElementProperties(Long integrateId, List<FileIdHashWithElementIds> fileIdHashWithElementIds, Boolean includeOverrides) throws BimfaceException {
        return this.dataClient.getIntegrateModelCommonElementProperties(integrateId, fileIdHashWithElementIds, includeOverrides, this.accessTokenService.getAccessToken());
    }

    public void addAssociations(String integrateId, String fromIntegrationId, String fromBusinessType, String fromBusinessFlag, BusinessAssociationRequest request) throws BimfaceException {
        this.dataClient.addAssociations(integrateId, fromIntegrationId, fromBusinessType, fromBusinessFlag, request, this.accessTokenService.getAccessToken());
    }

    public List<ElementBusinessAssociation> getAssociationsByElementId(String integrateId, String elementId, String businessType, String businessFlag) throws BimfaceException {
        return this.dataClient.getAssociationsByElementId(integrateId, elementId, businessType, businessFlag, this.accessTokenService.getAccessToken());
    }

    public List<BusinessElementAssociation> getAssociationsByBusinessId(String integrateId, String businessType, String businessId) throws BimfaceException {
        return this.dataClient.getAssociationsByBusinessId(integrateId, businessType, businessId, this.accessTokenService.getAccessToken());
    }

    public void deleteAssociationsByElementId(String integrateId, String elementId, String businessType, String businessFlag, List<String> businessIds) throws BimfaceException {
        this.dataClient.deleteAssociationsByElementId(integrateId, elementId, businessType, businessFlag, businessIds, this.accessTokenService.getAccessToken());
    }

    public void deleteAssociationsByBusinessId(String integrateId, String businessType, String businessId) throws BimfaceException {
        this.dataClient.deleteAssociationsByBusinessId(integrateId, businessType, businessId, this.accessTokenService.getAccessToken());
    }

    public void deleteAssociationsByElements(String integrateId, String businessType, String businessFlag, List<String> elementIds) throws BimfaceException {
        this.dataClient.deleteAssociationsByElements(integrateId, businessType, businessFlag, elementIds, this.accessTokenService.getAccessToken());
    }

    public void deleteAssociationsByBizIds(String integrateId, String businessType, String businessFlag, List<String> businessIds) throws BimfaceException {
        this.dataClient.deleteAssociationsByBizIds(integrateId, businessType, businessFlag, businessIds, this.accessTokenService.getAccessToken());
    }

    public ModelCompareChange getModelCompareElementChange(Long comparisonId, Long previousFileId, String previousElementId, Long followingFileId, String followingElementId) throws BimfaceException {
        return this.dataClient.getModelCompareElementChange(comparisonId, previousFileId, previousElementId, followingFileId, followingElementId, this.accessTokenService.getAccessToken());
    }

    public Tree getModelCompareTree(Long comparisonId) throws BimfaceException {
        return this.dataClient.getModelCompareTree(comparisonId, this.accessTokenService.getAccessToken());
    }

    public Pagination<ModelCompareDiff> getModelCompareResult(Long comparisonId, String family, String elementName, Integer page, Integer pageSize) throws BimfaceException {
        return this.dataClient.getModelCompareResult(comparisonId, family, elementName, page, pageSize, this.accessTokenService.getAccessToken());
    }

    public MaterialOverrideSetVO getMaterialOverrideSet(Long id) throws BimfaceException {
        return this.dataClient.getMaterialOverrideSet(id, this.accessTokenService.getAccessToken());
    }

    public List<String> getRfaFamilyPropertyNames(Long rfaFileId) throws BimfaceException {
        return this.dataClient.getRfaFamilyPropertyNames(rfaFileId, this.accessTokenService.getAccessToken());
    }

    public List<RfaFamilyType> getRfaFamilyTypes(Long rfaFileId) throws BimfaceException {
        return this.dataClient.getRfaFamilyTypes(rfaFileId, this.accessTokenService.getAccessToken());
    }

    public RfaFamilyTypeProperty getRfaFamilyTypeProperty(Long rfaFileId, String familyTypeGuid) throws BimfaceException {
        return this.dataClient.getRfaFamilyTypeProperty(rfaFileId, familyTypeGuid, this.accessTokenService.getAccessToken());
    }

    public List<SearchElementIdsResp> getElements(String requestBody) throws BimfaceException {
        return this.dataClient.getElements(requestBody, this.accessTokenService.getAccessToken());
    }

    public List<SearchRoomIdsResp> getRooms(String requestBody) throws BimfaceException {
        return this.dataClient.getRooms(requestBody, this.accessTokenService.getAccessToken());
    }

    public List<SearchAreaIdsResp> getAreas(String requestBody) throws BimfaceException {
        return this.dataClient.getAreas(requestBody, this.accessTokenService.getAccessToken());
    }

    public List<PropertyValuesResp> getPropertyValues(List<String> targetIds, String targetType, List<String> properties) throws BimfaceException {
        return this.dataClient.getPropertyValues(targetIds, targetType, properties, this.accessTokenService.getAccessToken());
    }

    public String getPaginationContextId() throws BimfaceException {
        return this.dataClient.getPaginationContextId(this.accessTokenService.getAccessToken());
    }

    public String getFileThumbnailUrl(Long fileId, Integer size) throws BimfaceException {
        return this.dataClient.getFileThumbnailUrl(fileId, size, this.accessTokenService.getAccessToken());
    }

    public String getDwgPdfUrl(Long dwgFileId) throws BimfaceException {
        return this.dataClient.getDwgPdfUrl(dwgFileId, this.accessTokenService.getAccessToken());
    }

    public String getDwgPreviewImageUrl(Long dwgFileId, String layoutName) throws BimfaceException {
        return this.dataClient.getDwgPreviewImageUrl(dwgFileId, layoutName, this.accessTokenService.getAccessToken());
    }
}

