/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.bimface.api.bean.request.modelCompare.CompareRequest;
import com.bimface.api.bean.request.modelCompare.ModelCompareQueryRequest;
import com.bimface.api.bean.request.modelCompare.ModelCompareRequest;
import com.bimface.api.bean.response.ModelCompareBean;
import com.bimface.data.bean.ModelCompareChange;
import com.bimface.data.bean.ModelCompareTree;
import com.bimface.exception.BimfaceException;
import com.bimface.page.PagedList;
import com.bimface.sdk.bean.request.compare.CompareElementRequest;
import com.bimface.sdk.client.ApiClient;
import com.bimface.sdk.client.DataClient;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.service.AccessTokenService;
import java.util.List;

public class CompareService {
    private ApiClient apiClient;
    private DataClient dataClient;
    private AccessTokenService accessTokenService;

    public CompareService(Endpoint endpoint, AccessTokenService accessTokenService) {
        this.apiClient = ApiClient.getApiClient(endpoint.getApiHost());
        this.dataClient = DataClient.getDataClient(endpoint.getApiHost() + "/data/");
        this.accessTokenService = accessTokenService;
    }

    @Deprecated
    public ModelCompareBean compare(ModelCompareRequest request) throws BimfaceException {
        return this.apiClient.invokeModelCompare(request, this.accessTokenService.getAccessToken());
    }

    public ModelCompareBean compareV2(CompareRequest request) throws BimfaceException {
        return this.apiClient.invokeModelComparev2(request, this.accessTokenService.getAccessToken());
    }

    public ModelCompareBean getCompareInfo(Long compareId) throws BimfaceException {
        return this.apiClient.getModelCompare(compareId, this.accessTokenService.getAccessToken());
    }

    public PagedList<ModelCompareBean> getCompares(ModelCompareQueryRequest modelCompareQueryRequest) throws BimfaceException {
        return this.apiClient.getModelCompares(modelCompareQueryRequest, this.accessTokenService.getAccessToken());
    }

    public void deleteCompare(Long compareId) throws BimfaceException {
        this.apiClient.deleteModelCompare(compareId, this.accessTokenService.getAccessToken());
    }

    public List<ModelCompareTree.SpecialtyNode> getCompareResult(Long compareId) throws BimfaceException {
        return this.dataClient.getModelCompareResult(compareId, this.accessTokenService.getAccessToken());
    }

    @Deprecated
    public ModelCompareChange getCompareElementDiff(CompareElementRequest compareElementRequest) throws BimfaceException {
        return this.dataClient.getModelCompareChange(compareElementRequest.getCompareId(), compareElementRequest.getPreviousFileId(), compareElementRequest.getPreviousElementId(), compareElementRequest.getFollowingFileId(), compareElementRequest.getFollowingElementId(), this.accessTokenService.getAccessToken());
    }
}

