/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.bimface.exception.BimfaceException;
import com.bimface.sdk.bean.response.AccessTokenBean;
import com.bimface.sdk.client.ApiClient;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.config.authorization.AccessTokenStorage;
import com.bimface.sdk.config.authorization.Credential;

public class AccessTokenService {
    private Credential credential;
    private volatile AccessTokenStorage accessTokenStorage;
    private ApiClient apiClient;

    public AccessTokenService(Endpoint endpoint, Credential credential, AccessTokenStorage accessTokenStorage) {
        this.credential = credential;
        this.accessTokenStorage = accessTokenStorage;
        this.apiClient = ApiClient.getApiClient(endpoint.getApiHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessTokenBean getAccessTokenBean() throws BimfaceException {
        AccessTokenBean accessTokenBean = this.accessTokenStorage.get();
        if (accessTokenBean == null) {
            AccessTokenService accessTokenService = this;
            synchronized (accessTokenService) {
                if (accessTokenBean == null) {
                    accessTokenBean = this.grantAccessTokenBean();
                    this.accessTokenStorage.put(accessTokenBean);
                }
            }
        }
        return accessTokenBean;
    }

    public synchronized void updateAccessTokenBean() throws BimfaceException {
        AccessTokenBean accessTokenBean = this.grantAccessTokenBean();
        this.accessTokenStorage.put(accessTokenBean);
    }

    public String getAccessToken() throws BimfaceException {
        AccessTokenBean accessTokenBean = this.getAccessTokenBean();
        return accessTokenBean.getToken();
    }

    private AccessTokenBean grantAccessTokenBean() throws BimfaceException {
        return this.apiClient.applyOAuthToken(this.credential);
    }
}

