/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.interfaces;

import com.bimface.api.bean.compatible.response.BatchDeleteResultBean;
import com.bimface.api.bean.compatible.response.ShareLinkBean;
import com.bimface.api.bean.request.integrate.FileIntegrateRequest;
import com.bimface.api.bean.request.integrate.IntegrateQueryRequest;
import com.bimface.api.bean.request.modelCompare.CompareRequest;
import com.bimface.api.bean.request.modelCompare.ModelCompareQueryRequest;
import com.bimface.api.bean.request.modelCompare.ModelCompareRequest;
import com.bimface.api.bean.request.translate.FileTranslateRequest;
import com.bimface.api.bean.request.translate.TranslateQueryRequest;
import com.bimface.api.bean.response.FileIntegrateBean;
import com.bimface.api.bean.response.FileIntegrateDetailBean;
import com.bimface.api.bean.response.FileTranslateBean;
import com.bimface.api.bean.response.FileTranslateDetailBean;
import com.bimface.api.bean.response.ModelCompareBean;
import com.bimface.api.bean.response.databagDerivative.IntegrateDatabagDerivativeBean;
import com.bimface.api.bean.response.databagDerivative.ModelCompareDatabagDerivativeBean;
import com.bimface.api.bean.response.databagDerivative.TranslateDatabagDerivativeBean;
import com.bimface.page.PagedList;
import com.bimface.sdk.bean.response.AccessTokenBean;
import com.glodon.paas.foundation.restclient.RESTResponse;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface ApiInterface {
    @POST(value="oauth2/token")
    public Call<RESTResponse<AccessTokenBean>> applyOAuthToken(@Header(value="Authorization") String var1);

    @GET(value="view/token")
    public Call<RESTResponse<String>> getViewToken(@Query(value="fileId") Long var1, @Query(value="integrateId") Long var2, @Query(value="compareId") Long var3, @Header(value="Authorization") String var4);

    @PUT(value="translate")
    public Call<RESTResponse<FileTranslateBean>> translate(@Body FileTranslateRequest var1, @Header(value="Authorization") String var2);

    @GET(value="translate")
    public Call<RESTResponse<FileTranslateBean>> getTranslation(@Query(value="fileId") Long var1, @Header(value="Authorization") String var2);

    @POST(value="translateDetails")
    public Call<RESTResponse<PagedList<FileTranslateDetailBean>>> getTranslates(@Body TranslateQueryRequest var1, @Header(value="Authorization") String var2);

    @POST(value="share")
    public Call<RESTResponse<ShareLinkBean>> createShare(@Query(value="fileId") Long var1, @Query(value="integrateId") Long var2, @Query(value="activeHours") Integer var3, @Query(value="expireDate") String var4, @Query(value="needPassword") Boolean var5, @Header(value="Authorization") String var6);

    @DELETE(value="share")
    public Call<RESTResponse<String>> deleteShare(@Query(value="fileId") Long var1, @Query(value="integrateId") Long var2, @Header(value="Authorization") String var3);

    @DELETE(value="shares")
    public Call<RESTResponse<BatchDeleteResultBean<Long>>> batchDeteleShare(@Query(value="sourceIds") List<Long> var1, @Header(value="Authorization") String var2);

    @GET(value="share")
    public Call<RESTResponse<ShareLinkBean>> getShareLink(@Query(value="token") String var1, @Query(value="fileId") Long var2, @Query(value="integrateId") Long var3, @Header(value="Authorization") String var4);

    @GET(value="shares")
    public Call<RESTResponse<PagedList<ShareLinkBean>>> shareList(@Header(value="Authorization") String var1, @Query(value="pageNo") Integer var2, @Query(value="pageSize") Integer var3);

    @PUT(value="files/{fileId}/offlineDatabag")
    public Call<RESTResponse<TranslateDatabagDerivativeBean>> createTranslateOfflineDatabag(@Path(value="fileId") Long var1, @Query(value="callback") String var2, @Header(value="Authorization") String var3);

    @PUT(value="integrations/{integrateId}/offlineDatabag")
    public Call<RESTResponse<IntegrateDatabagDerivativeBean>> createIntegateOfflineDatabag(@Path(value="integrateId") Long var1, @Query(value="callback") String var2, @Header(value="Authorization") String var3);

    @PUT(value="comparisions/{compareId}/offlineDatabag")
    public Call<RESTResponse<ModelCompareDatabagDerivativeBean>> createCompareOfflineDatabag(@Path(value="compareId") Long var1, @Query(value="callback") String var2, @Header(value="Authorization") String var3);

    @GET(value="files/{fileId}/offlineDatabag")
    public Call<RESTResponse<List<TranslateDatabagDerivativeBean>>> getTranslateOfflineDatabag(@Path(value="fileId") Long var1, @Header(value="Authorization") String var2);

    @GET(value="integrations/{integrateId}/offlineDatabag")
    public Call<RESTResponse<List<IntegrateDatabagDerivativeBean>>> getIntegateOfflineDatabag(@Path(value="integrateId") Long var1, @Header(value="Authorization") String var2);

    @GET(value="comparisions/{compareId}/offlineDatabag")
    public Call<RESTResponse<List<ModelCompareDatabagDerivativeBean>>> getCompareOfflineDatabag(@Path(value="compareId") Long var1, @Header(value="Authorization") String var2);

    @PUT(value="integrate")
    public Call<RESTResponse<FileIntegrateBean>> integrate(@Body FileIntegrateRequest var1, @Header(value="Authorization") String var2);

    @GET(value="integrate")
    public Call<RESTResponse<FileIntegrateBean>> getIntegrate(@Query(value="integrateId") Long var1, @Header(value="Authorization") String var2);

    @POST(value="integrateDetails")
    public Call<RESTResponse<PagedList<FileIntegrateDetailBean>>> getIntegrates(@Body IntegrateQueryRequest var1, @Header(value="Authorization") String var2);

    @DELETE(value="integrate")
    public Call<RESTResponse<Void>> deleteIntegrate(@Query(value="integrateId") Long var1, @Header(value="Authorization") String var2);

    @POST(value="compare")
    public Call<RESTResponse<ModelCompareBean>> invokeModelCompare(@Body ModelCompareRequest var1, @Header(value="Authorization") String var2);

    @POST(value="v2/compare")
    public Call<RESTResponse<ModelCompareBean>> invokeModelCompareV2(@Body CompareRequest var1, @Header(value="Authorization") String var2);

    @GET(value="v2/compare")
    public Call<RESTResponse<ModelCompareBean>> getModelCompareV2(@Query(value="compareId") Long var1, @Header(value="Authorization") String var2);

    @POST(value="compares")
    public Call<RESTResponse<PagedList<ModelCompareBean>>> getModelCompares(@Body ModelCompareQueryRequest var1, @Header(value="Authorization") String var2);

    @DELETE(value="v2/compare")
    public Call<RESTResponse<ModelCompareBean>> deleteModelCompareV2(@Query(value="compareId") Long var1, @Header(value="Authorization") String var2);
}

