/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.config.authorization;

import com.bimface.sdk.bean.response.AccessTokenBean;
import com.bimface.sdk.config.authorization.AccessTokenStorage;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DefaultAccessTokenStorage
implements AccessTokenStorage {
    private AccessTokenBean accessTokenBean;

    @Override
    public synchronized void put(AccessTokenBean accessTokenBean) {
        this.accessTokenBean = accessTokenBean;
    }

    @Override
    public AccessTokenBean get() {
        if (this.accessTokenBean == null) {
            return null;
        }
        if (this.maybeExpire(this.accessTokenBean.getExpireTime())) {
            return null;
        }
        return this.accessTokenBean;
    }

    private boolean maybeExpire(String expireTime) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date expire = dateFormat.parse(this.accessTokenBean.getExpireTime());
            return expire.getTime() - System.currentTimeMillis() <= 1000L;
        }
        catch (ParseException e) {
            return true;
        }
    }
}

