/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.client;

import com.bimface.data.bean.Area;
import com.bimface.data.bean.BusinessAssociationRequest;
import com.bimface.data.bean.BusinessElementAssociation;
import com.bimface.data.bean.DatabagInfo;
import com.bimface.data.bean.DrawingSheet;
import com.bimface.data.bean.ElementBusinessAssociation;
import com.bimface.data.bean.ElementIdWithName;
import com.bimface.data.bean.ElementPropertyFilterRequest;
import com.bimface.data.bean.ElementsWithBoundingBox;
import com.bimface.data.bean.FileIdHashWithElementIds;
import com.bimface.data.bean.FileTreeRequestBody;
import com.bimface.data.bean.FileViews;
import com.bimface.data.bean.Floor;
import com.bimface.data.bean.IntegrateFileData;
import com.bimface.data.bean.IntegrationTreeOptionalRequestBody;
import com.bimface.data.bean.Link;
import com.bimface.data.bean.MaterialInfo;
import com.bimface.data.bean.MaterialOverrideSetVO;
import com.bimface.data.bean.ModelCompareChange;
import com.bimface.data.bean.ModelCompareDiff;
import com.bimface.data.bean.ModelCompareTree;
import com.bimface.data.bean.Pagination;
import com.bimface.data.bean.Property;
import com.bimface.data.bean.PropertyGroup;
import com.bimface.data.bean.PropertyValuesResp;
import com.bimface.data.bean.RfaFamilyType;
import com.bimface.data.bean.RfaFamilyTypeProperty;
import com.bimface.data.bean.Room;
import com.bimface.data.bean.SearchAreaIdsResp;
import com.bimface.data.bean.SearchElementIdsResp;
import com.bimface.data.bean.SearchRoomIdsResp;
import com.bimface.data.bean.SegmentDto;
import com.bimface.data.bean.SegmentGroupDto;
import com.bimface.data.bean.Tree;
import com.bimface.data.bean.View;
import com.bimface.data.enums.ToleranceType;
import com.bimface.exception.BimfaceException;
import com.bimface.http.BimfaceResponseChecker;
import com.bimface.sdk.bean.request.QueryElementIdsRequest;
import com.bimface.sdk.client.AbstractClient;
import com.bimface.sdk.interfaces.DataInteface;
import com.bimface.sdk.utils.ConvertUtils;
import com.glodon.paas.foundation.restclient.RESTClientBuilder;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(DataClient.class);
    private static final Gson GSON = new Gson();
    private DataInteface dataClient;
    private static DataClient instance;

    public static synchronized DataClient getDataClient(String dataBaseUrl) {
        if (instance == null) {
            instance = new DataClient(dataBaseUrl);
        }
        return instance;
    }

    private DataClient(String dataBaseUrl) {
        RESTClientBuilder builder = new RESTClientBuilder().serviceBaseUrl(dataBaseUrl).responseChecker(new BimfaceResponseChecker());
        if (logger.isDebugEnabled()) {
            builder.enableHttpLoggingInterceptor();
        }
        this.dataClient = builder.build(DataInteface.class);
    }

    @Deprecated
    public Property getSingleModelElementProperty(@NotNull Long fileId, @NotNull String elementId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelElementProperty(fileId, elementId, accessToken));
    }

    public Property getIntegrateModelProperty(@NotNull Long integrateId, @NotNull Long fileId, @NotNull String elementId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelProperty(integrateId, fileId, elementId, accessToken));
    }

    public String getDatabagDownloadUrl(Long fileId, Long integrateId, Long compareId, String type, String databagVersion, @NotNull String accessToken) throws BimfaceException {
        if (fileId != null && integrateId != null || integrateId != null && compareId != null || fileId != null && compareId != null || fileId == null && integrateId == null && compareId == null) {
            throw new IllegalArgumentException("one and only one argument can be not null in (fileId, integrateId, compareId)");
        }
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getDatabagDownloadUrl(fileId, integrateId, compareId, type, databagVersion, accessToken));
    }

    public Long getDatabagSize(@NotNull Long fileId, @NotNull String accessToken) throws BimfaceException {
        DatabagInfo databagInfo = DataClient.executeCall(this.dataClient.getDataBagSize(fileId, accessToken = this.validToken(accessToken)));
        if (databagInfo != null) {
            return databagInfo.getLength();
        }
        throw new BimfaceException("find databagInfo error");
    }

    public List<String> getSingleModelElements(@NotNull Long fileId, String specialty, String floor, String categoryId, String family, String familyType, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelElements(fileId, specialty, floor, categoryId, family, familyType, accessToken));
    }

    public ElementsWithBoundingBox getIntegrateModelElements(@NotNull Long integrateId, String specialty, String floor, String categoryId, String family, String familyType, String systemType, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelElements(integrateId, specialty, floor, categoryId, family, familyType, systemType, accessToken));
    }

    public Object getIntegrateTree(@NotNull Long integrateId, @NotNull Integer treeType, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateTree(integrateId, treeType, accessToken));
    }

    public List<ModelCompareTree.SpecialtyNode> getModelCompareResult(@NotNull Long compareId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getModelCompareResult(compareId, accessToken));
    }

    public ModelCompareChange getModelCompareChange(@NotNull Long compareId, @NotNull Long previousFileId, @NotNull String previousElementId, @NotNull Long followingFileId, @NotNull String followingElementId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getModelCompareChange(compareId, previousFileId, previousElementId, followingFileId, followingElementId, accessToken));
    }

    public Object getSingleModelTree(@NotNull Long fileId, String version, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelTree(fileId, version, accessToken));
    }

    public List<String> getSingleModelElementIds(@NotNull Long fileId, @NotNull QueryElementIdsRequest queryElementIdsRequest, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelElementIds(fileId, ConvertUtils.convertToParamsMap(queryElementIdsRequest), accessToken));
    }

    public List<Map<String, Object>> getSingleModelFileIdFloorsMapping(@NotNull List<String> fileIds, Boolean includeArea, Boolean includeRoom, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        String fileIdsList = fileIds.stream().reduce((i, j) -> i + "," + j).orElse(null);
        return DataClient.executeCall(this.dataClient.getSingleModelFileIdFloorsMapping(fileIdsList, includeArea, includeRoom, accessToken));
    }

    public List<Floor> getSingleModelFloors(@NotNull Long fileId, Boolean includeArea, Boolean includeRoom, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelFloors(fileId, includeArea, includeRoom, accessToken));
    }

    public Property getSingleModelElement(@NotNull Long fileId, @NotNull String elementId, @NotNull Boolean includeOverrides, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelElement(fileId, elementId, includeOverrides, accessToken));
    }

    public List<Property> getSingleModelElements(@NotNull Long fileId, Boolean includeOverrides, ElementPropertyFilterRequest elementPropertyFilterRequest, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelElements(fileId, includeOverrides, elementPropertyFilterRequest, accessToken));
    }

    public Property getSingleModelElementProperty(@NotNull Long fileId, @NotNull List<String> elementIds, @NotNull Boolean includeOverrides, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelElementProperty(fileId, elementIds, includeOverrides, accessToken));
    }

    public List<MaterialInfo> getSingleModelElementMaterials(@NotNull Long fileId, @NotNull String elementId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelElementMaterials(fileId, elementId, accessToken));
    }

    public List<View> getSingleModelViews(@NotNull Long fileId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelViews(fileId, accessToken));
    }

    public List<Room> getSingleModelRooms(@NotNull Long fileId, String floorId, String elementId, ToleranceType roomToleranceZ, ToleranceType roomToleranceXY, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelRooms(fileId, floorId, elementId, roomToleranceZ, roomToleranceXY, accessToken));
    }

    public Room getSingleModelRoom(@NotNull Long fileId, @NotNull String roomId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelRoom(fileId, roomId, accessToken));
    }

    public List<Area> getSingleModelAreas(@NotNull Long fileId, @NotNull String floorId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelAreas(fileId, floorId, accessToken));
    }

    public Area getSingleModelArea(@NotNull Long fileId, @NotNull String areaId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelArea(fileId, areaId, accessToken));
    }

    public List<Tree.TreeNode> getSingleModelTreeV2(@NotNull Long fileId, FileTreeRequestBody requestBody, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        Object response = requestBody != null ? DataClient.executeCall(this.dataClient.getSingleModelTreeV2(fileId, "2.0", null, requestBody, accessToken)) : DataClient.executeCall(this.dataClient.getSingleModelTreeV2(fileId, "2.0", null, accessToken));
        return (List)GSON.fromJson(GSON.toJson(response), new TypeToken<List<Tree.TreeNode>>(){}.getType());
    }

    public Tree getSingleModelCustomizedTree(@NotNull Long fileId, FileTreeRequestBody requestBody, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        Object response = requestBody != null ? DataClient.executeCall(this.dataClient.getSingleModelTreeV2(fileId, null, "customized", requestBody, accessToken)) : DataClient.executeCall(this.dataClient.getSingleModelTreeV2(fileId, null, "customized", accessToken));
        return (Tree)GSON.fromJson(GSON.toJson(response), new TypeToken<Tree>(){}.getType());
    }

    public List<Link> getSingleModelLinks(@NotNull Long fileId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelLinks(fileId, accessToken));
    }

    public List<DrawingSheet> getSingleModelDrawingSheets(@NotNull Long fileId, String elementId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelDrawingSheets(fileId, elementId, accessToken));
    }

    public Object getSingleModelModelInfo(@NotNull Long fileId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.execute(this.dataClient.getSingleModelModelInfo(fileId, accessToken));
    }

    public List<ElementIdWithName> getSingleModelChildElementIds(@NotNull Long fileId, @NotNull String elementId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getSingleModelChildElementIds(fileId, elementId, accessToken));
    }

    public String updateSingleModelElementProperties(@NotNull Long fileId, @NotNull String elementId, List<PropertyGroup> propertyGroups, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.updateSingleModelElementProperties(fileId, elementId, propertyGroups, accessToken));
    }

    public String deleteSingleModelElementProperties(@NotNull Long fileId, @NotNull String elementId, List<PropertyGroup> propertyGroups, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.deleteSingleModelElementProperties(fileId, elementId, propertyGroups, accessToken));
    }

    public ElementsWithBoundingBox getIntegrateModelElementIds(@NotNull Long integrateId, @NotNull QueryElementIdsRequest queryElementIdsRequest, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelElementIds(integrateId, ConvertUtils.convertToParamsMap(queryElementIdsRequest), accessToken));
    }

    public String updateIntegrateModelElementProperties(@NotNull Long integrateId, @NotNull String fileIdHash, @NotNull String elementId, List<PropertyGroup> propertyGroups, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.updateIntegrateModelElementProperties(integrateId, fileIdHash, elementId, propertyGroups, accessToken));
    }

    public String deleteIntegrateModelElementProperties(@NotNull Long integrateId, @NotNull String fileIdHash, @NotNull String elementId, List<PropertyGroup> propertyGroups, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.deleteIntegrateModelElementProperties(integrateId, fileIdHash, elementId, propertyGroups, accessToken));
    }

    public List<Floor> getIntegrateModelFloors(@NotNull Long integrateId, Boolean includeArea, Boolean includeRoom, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelFloors(integrateId, includeArea, includeRoom, accessToken));
    }

    public Property getIntegrateModelElement(@NotNull Long integrateId, @NotNull String fileIdHash, @NotNull String elementId, @NotNull Boolean includeOverrides, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelElement(integrateId, fileIdHash, elementId, includeOverrides, accessToken));
    }

    public Property getIntegrateModelElement(@NotNull Long integrateId, @NotNull String elementId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelElement(integrateId, elementId, accessToken));
    }

    public List<MaterialInfo> getIntegrateModelElementMaterials(@NotNull Long integrateId, @NotNull String fileIdHash, @NotNull String elementId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelElementMaterials(integrateId, fileIdHash, elementId, accessToken));
    }

    public Tree getIntegrateModelTree(@NotNull Long integrateId, String treeType, List<String> desiredHierarchy, IntegrationTreeOptionalRequestBody requestBody, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return requestBody != null ? DataClient.executeCall(this.dataClient.getIntegrateModelTree(integrateId, treeType, desiredHierarchy, requestBody, accessToken)) : DataClient.executeCall(this.dataClient.getIntegrateModelTree(integrateId, treeType, desiredHierarchy, accessToken));
    }

    public List<FileViews> getIntegrateModelFileViews(@NotNull Long integrateId, String viewType, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelFileViews(integrateId, viewType, accessToken));
    }

    public List<Room> getIntegrateModelRooms(@NotNull Long integrateId, String floorId, String elementId, ToleranceType roomToleranceZ, ToleranceType roomToleranceXY, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelRooms(integrateId, floorId, elementId, roomToleranceZ, roomToleranceXY, accessToken));
    }

    public Room getIntegrateModelRoom(@NotNull Long integrateId, @NotNull String roomId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelRoom(integrateId, roomId, accessToken));
    }

    public List<Area> getIntegrateModelAreas(@NotNull Long integrateId, @NotNull String floorId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelAreas(integrateId, floorId, accessToken));
    }

    public Area getIntegrateModelArea(@NotNull Long integrateId, @NotNull String areaId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelArea(integrateId, areaId, accessToken));
    }

    public List<IntegrateFileData> getIntegrateFiles(@NotNull Long integrateId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateFiles(integrateId, accessToken));
    }

    public String getIntegrateModelViewToken(@NotNull Long integrateId, @NotNull String fileId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelViewToken(integrateId, fileId, accessToken));
    }

    public List<SegmentGroupDto> getIntegrateModelSegmentGroups(@NotNull Long integrateId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelSegmentGroups(integrateId, accessToken));
    }

    public List<SegmentGroupDto> getIntegrateModelSegmentTree(@NotNull Long integrateId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelSegmentTree(integrateId, accessToken));
    }

    public List<SegmentDto> getIntegrateModelSegments(@NotNull Long integrateId, @NotNull String segmentGroupId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelSegments(integrateId, segmentGroupId, accessToken));
    }

    public List<String> getIntegrateModelSegmentElementIds(@NotNull Long integrateId, @NotNull String segmentId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateModelSegmentElementIds(integrateId, segmentId, accessToken));
    }

    public Property getIntegrateModelCommonElementProperties(@NotNull Long integrateId, List<FileIdHashWithElementIds> fileIdHashWithElementIds, @NotNull Boolean includeOverrides, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return fileIdHashWithElementIds != null ? DataClient.executeCall(this.dataClient.getIntegrateModelCommonElementProperties(integrateId, fileIdHashWithElementIds, includeOverrides, accessToken)) : DataClient.executeCall(this.dataClient.getIntegrateModelCommonElementProperties(integrateId, accessToken));
    }

    public void addAssociations(@NotNull String integrateId, String fromIntegrationId, String fromBusinessType, String fromBusinessFlag, BusinessAssociationRequest request, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        if (request != null) {
            DataClient.executeCall(this.dataClient.addAssociations(integrateId, fromIntegrationId, fromBusinessType, fromBusinessFlag, request, accessToken));
        } else {
            DataClient.executeCall(this.dataClient.addAssociations(integrateId, fromIntegrationId, fromBusinessType, fromBusinessFlag, accessToken));
        }
    }

    public List<ElementBusinessAssociation> getAssociationsByElementId(@NotNull String integrateId, @NotNull String elementId, String businessType, String businessFlag, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getAssociationsByElementId(integrateId, elementId, businessType, businessFlag, accessToken));
    }

    public List<BusinessElementAssociation> getAssociationsByBusinessId(@NotNull String integrateId, @NotNull String businessType, @NotNull String businessId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getAssociationsByBusinessId(integrateId, businessType, businessId, accessToken));
    }

    public void deleteAssociationsByElementId(@NotNull String integrateId, @NotNull String elementId, String businessType, String businessFlag, List<String> businessIds, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        DataClient.executeCall(this.dataClient.deleteAssociationsByElementId(integrateId, elementId, businessType, businessFlag, businessIds, accessToken));
    }

    public void deleteAssociationsByBusinessId(@NotNull String integrateId, @NotNull String businessType, @NotNull String businessId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        DataClient.executeCall(this.dataClient.deleteAssociationsByBusinessId(integrateId, businessType, businessId, accessToken));
    }

    public void deleteAssociationsByElements(@NotNull String integrateId, String businessType, String businessFlag, List<String> elementIds, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        DataClient.executeCall(this.dataClient.deleteAssociationsByElements(integrateId, businessType, businessFlag, elementIds, accessToken));
    }

    public void deleteAssociationsByBizIds(@NotNull String integrateId, String businessType, String businessFlag, List<String> businessIds, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        DataClient.executeCall(this.dataClient.deleteAssociationsByBizIds(integrateId, businessType, businessFlag, businessIds, accessToken));
    }

    public ModelCompareChange getModelCompareElementChange(@NotNull Long comparisonId, @NotNull Long previousFileId, @NotNull String previousElementId, @NotNull Long followingFileId, @NotNull String followingElementId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getModelCompareElementChange(comparisonId, previousFileId, previousElementId, followingFileId, followingElementId, accessToken));
    }

    public Tree getModelCompareTree(@NotNull Long comparisonId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getModelCompareTree(comparisonId, accessToken));
    }

    public Pagination<ModelCompareDiff> getModelCompareResult(@NotNull Long comparisonId, String family, String elementName, Integer page, Integer pageSize, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getModelCompareResult(comparisonId, family, elementName, page, pageSize, accessToken));
    }

    public MaterialOverrideSetVO getMaterialOverrideSet(@NotNull Long id, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getMaterialOverrideSet(id, accessToken));
    }

    public List<String> getRfaFamilyPropertyNames(@NotNull Long rfaFileId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getRfaFamilyPropertyNames(rfaFileId, accessToken));
    }

    public List<RfaFamilyType> getRfaFamilyTypes(@NotNull Long rfaFileId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getRfaFamilyTypes(rfaFileId, accessToken));
    }

    public RfaFamilyTypeProperty getRfaFamilyTypeProperty(@NotNull Long rfaFileId, @NotNull String familyTypeGuid, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getRfaFamilyTypeProperty(rfaFileId, familyTypeGuid, accessToken));
    }

    public List<SearchElementIdsResp> getElements(@NotNull String requestBody, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getElements(requestBody, accessToken));
    }

    public List<SearchRoomIdsResp> getRooms(@NotNull String requestBody, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getRooms(requestBody, accessToken));
    }

    public List<SearchAreaIdsResp> getAreas(@NotNull String requestBody, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getAreas(requestBody, accessToken));
    }

    public List<PropertyValuesResp> getPropertyValues(@NotNull List<String> targetIds, String targetType, @NotNull List<String> properties, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getPropertyValues(targetIds, targetType, properties, accessToken));
    }

    public String getPaginationContextId(@NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getPaginationContextId(accessToken));
    }

    public String getFileThumbnailUrl(@NotNull Long fileId, @NotNull Integer size, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getFileThumbnailUrl(fileId, size, accessToken));
    }

    public String getDwgPdfUrl(@NotNull Long dwgFileId, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getDwgPdfUrl(dwgFileId, accessToken));
    }

    public String getDwgPreviewImageUrl(@NotNull Long dwgFileId, @NotNull String layoutName, @NotNull String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getDwgPreviewImageUrl(dwgFileId, layoutName, accessToken));
    }

    public String getFileDatabagRootUrl(Long fileId, String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getFileDatabagRootUrl(fileId, accessToken));
    }

    public String getIntegrateDatabagRootUrl(Long integrateId, String accessToken) throws BimfaceException {
        accessToken = this.validToken(accessToken);
        return DataClient.executeCall(this.dataClient.getIntegrateDatabagRootUrl(integrateId, accessToken));
    }
}

