/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.aspects;

import com.bimface.exception.BimfaceException;
import com.bimface.sdk.service.AccessTokenService;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class UpdateAccessTokenAspect {
    private Logger logger = LoggerFactory.getLogger(UpdateAccessTokenAspect.class);

    @Pointcut(value="execution(* *(..)) && ( within(com.bimface.sdk.service..*) && !within(com.bimface.sdk.service.AccessTokenService))")
    void serviceMethodPointCut(ProceedingJoinPoint joinPoint) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="serviceMethodPointCut(joinPoint)")
    public Object updateTokenOnException(ProceedingJoinPoint joinPoint) throws BimfaceException {
        Object object;
        block13: {
            object = null;
            try {
                object = joinPoint.proceed(joinPoint.getArgs());
            }
            catch (BimfaceException e) {
                this.logger.warn("request bimface error, error message: {}", (Object)e.getMessage());
                if (e.getMessage().contains("invalid access token") || e.getMessage().contains("token was not recognized")) {
                    Field[] fields;
                    Object service = joinPoint.getThis();
                    for (Field field : fields = service.getClass().getDeclaredFields()) {
                        if (!field.getType().isAssignableFrom(AccessTokenService.class)) continue;
                        field.setAccessible(true);
                        try {
                            AccessTokenService tokenService = (AccessTokenService)field.get(service);
                            String oldToken = tokenService.getAccessToken();
                            this.logger.debug("old token: {}", (Object)oldToken);
                            tokenService.updateAccessTokenBean();
                            String newToken = tokenService.getAccessToken();
                            this.logger.debug("new token: {}", (Object)newToken);
                            Object[] args = joinPoint.getArgs();
                            for (int i = 0; i < args.length; ++i) {
                                if (!(args[i] instanceof String) || !oldToken.equals(args[i])) continue;
                                args[i] = newToken;
                                break;
                            }
                            this.logger.debug("retry args: {}", (Object)Arrays.toString(args));
                            object = joinPoint.proceed(args);
                        }
                        catch (IllegalAccessException e1) {
                            e1.printStackTrace();
                            break block13;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            break block13;
                        }
                        finally {
                            field.setAccessible(false);
                        }
                    }
                }
                throw e;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return object;
    }
}

