/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk;

import com.bimface.api.bean.compatible.response.BatchDeleteResultBean;
import com.bimface.api.bean.compatible.response.ShareLinkBean;
import com.bimface.api.bean.request.integrate.FileIntegrateRequest;
import com.bimface.api.bean.request.integrate.IntegrateQueryRequest;
import com.bimface.api.bean.request.modelCompare.CompareRequest;
import com.bimface.api.bean.request.modelCompare.ModelCompareQueryRequest;
import com.bimface.api.bean.request.modelCompare.ModelCompareRequest;
import com.bimface.api.bean.request.translate.FileTranslateRequest;
import com.bimface.api.bean.request.translate.TranslateQueryRequest;
import com.bimface.api.bean.request.translate.TranslateSource;
import com.bimface.api.bean.response.FileIntegrateBean;
import com.bimface.api.bean.response.FileIntegrateDetailBean;
import com.bimface.api.bean.response.FileTranslateBean;
import com.bimface.api.bean.response.FileTranslateDetailBean;
import com.bimface.api.bean.response.ModelCompareBean;
import com.bimface.api.bean.response.databagDerivative.DatabagDerivativeBean;
import com.bimface.data.bean.Area;
import com.bimface.data.bean.BusinessAssociationRequest;
import com.bimface.data.bean.BusinessElementAssociation;
import com.bimface.data.bean.Category;
import com.bimface.data.bean.DrawingSheet;
import com.bimface.data.bean.ElementBusinessAssociation;
import com.bimface.data.bean.ElementIdWithName;
import com.bimface.data.bean.ElementPropertyFilterRequest;
import com.bimface.data.bean.ElementsWithBoundingBox;
import com.bimface.data.bean.FileIdHashWithElementIds;
import com.bimface.data.bean.FileTreeRequestBody;
import com.bimface.data.bean.FileViews;
import com.bimface.data.bean.Floor;
import com.bimface.data.bean.FloorTree;
import com.bimface.data.bean.IntegrateFileData;
import com.bimface.data.bean.IntegrationTreeOptionalRequestBody;
import com.bimface.data.bean.Link;
import com.bimface.data.bean.MaterialInfo;
import com.bimface.data.bean.MaterialOverrideSetVO;
import com.bimface.data.bean.ModelCompareChange;
import com.bimface.data.bean.ModelCompareDiff;
import com.bimface.data.bean.ModelCompareTree;
import com.bimface.data.bean.Pagination;
import com.bimface.data.bean.Property;
import com.bimface.data.bean.PropertyGroup;
import com.bimface.data.bean.PropertyValuesResp;
import com.bimface.data.bean.RfaFamilyType;
import com.bimface.data.bean.RfaFamilyTypeProperty;
import com.bimface.data.bean.Room;
import com.bimface.data.bean.SearchAreaIdsResp;
import com.bimface.data.bean.SearchElementIdsResp;
import com.bimface.data.bean.SearchRoomIdsResp;
import com.bimface.data.bean.SegmentDto;
import com.bimface.data.bean.SegmentGroupDto;
import com.bimface.data.bean.SpecialtyTree;
import com.bimface.data.bean.Tree;
import com.bimface.data.bean.View;
import com.bimface.data.enums.ToleranceType;
import com.bimface.exception.BimfaceException;
import com.bimface.file.bean.AppendFileBean;
import com.bimface.file.bean.FileBean;
import com.bimface.file.bean.FileUploadStatusBean;
import com.bimface.file.bean.SupportFileBean;
import com.bimface.file.bean.UploadPolicyBean;
import com.bimface.page.PagedList;
import com.bimface.sdk.bean.request.FileBatchQueryRequest;
import com.bimface.sdk.bean.request.FileUploadRequest;
import com.bimface.sdk.bean.request.OfflineDatabagRequest;
import com.bimface.sdk.bean.request.QueryElementIdsRequest;
import com.bimface.sdk.bean.request.compare.CompareElementRequest;
import com.bimface.sdk.config.Config;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.config.authorization.AccessTokenStorage;
import com.bimface.sdk.config.authorization.Credential;
import com.bimface.sdk.config.authorization.DefaultAccessTokenStorage;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.service.CategoryTreeService;
import com.bimface.sdk.service.CompareService;
import com.bimface.sdk.service.DataService;
import com.bimface.sdk.service.DatabagService;
import com.bimface.sdk.service.DownloadService;
import com.bimface.sdk.service.ElementService;
import com.bimface.sdk.service.FileService;
import com.bimface.sdk.service.FloorService;
import com.bimface.sdk.service.IntegrateService;
import com.bimface.sdk.service.OfflineDatabagService;
import com.bimface.sdk.service.PropertyService;
import com.bimface.sdk.service.ShareLinkService;
import com.bimface.sdk.service.SignatureService;
import com.bimface.sdk.service.TranslateService;
import com.bimface.sdk.service.ViewTokenService;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class BimfaceClient {
    private Credential credential;
    private Endpoint endpoint;
    private AccessTokenService accessTokenService;
    private FileService fileService;
    private TranslateService translateService;
    private ViewTokenService viewTokenService;
    private ShareLinkService shareLinkService;
    private PropertyService propertyService;
    private DownloadService downloadService;
    private ElementService elementService;
    private CategoryTreeService categoryTreeService;
    private IntegrateService integrateService;
    private CompareService compareService;
    private OfflineDatabagService offlineDatabagService;
    private FloorService floorService;
    private SignatureService signatureService;
    private DataService dataService;
    private DatabagService databagService;

    public BimfaceClient(String appKey, String appSecret) {
        this(appKey, appSecret, null, null, null);
    }

    public BimfaceClient(String appKey, String appSecret, Config config) {
        this(appKey, appSecret, null, config, null);
    }

    public BimfaceClient(String appKey, String appSecret, Endpoint endpoint) {
        this(appKey, appSecret, endpoint, null, null);
    }

    public BimfaceClient(String appKey, String appSecret, Endpoint endpoint, Config config) {
        this(appKey, appSecret, endpoint, config, null);
    }

    public BimfaceClient(String appKey, String appSecret, Endpoint endpoint, Config config, AccessTokenStorage accessTokenStorage) {
        this.credential = new Credential(appKey, appSecret);
        this.endpoint = endpoint == null ? new Endpoint() : endpoint;
        AccessTokenStorage usedAccessTokenStorage = accessTokenStorage == null ? new DefaultAccessTokenStorage() : accessTokenStorage;
        this.accessTokenService = new AccessTokenService(this.endpoint, this.credential, usedAccessTokenStorage);
        this.fileService = new FileService(this.endpoint, this.accessTokenService);
        this.translateService = new TranslateService(this.endpoint, this.accessTokenService);
        this.viewTokenService = new ViewTokenService(this.endpoint, this.accessTokenService);
        this.shareLinkService = new ShareLinkService(this.endpoint, this.accessTokenService);
        this.propertyService = new PropertyService(this.endpoint, this.accessTokenService);
        this.downloadService = new DownloadService(this.endpoint, this.accessTokenService);
        this.elementService = new ElementService(this.endpoint, this.accessTokenService);
        this.categoryTreeService = new CategoryTreeService(this.endpoint, this.accessTokenService);
        this.integrateService = new IntegrateService(this.endpoint, this.accessTokenService);
        this.compareService = new CompareService(this.endpoint, this.accessTokenService);
        this.offlineDatabagService = new OfflineDatabagService(this.endpoint, this.accessTokenService);
        this.floorService = new FloorService(this.endpoint, this.accessTokenService);
        this.signatureService = new SignatureService(this.credential);
        this.dataService = new DataService(this.endpoint, this.accessTokenService);
        this.databagService = new DatabagService(this.endpoint, this.accessTokenService);
    }

    public SupportFileBean getSupport() throws BimfaceException {
        return this.fileService.getSupportedFileTypes();
    }

    public FileBean upload(FileUploadRequest fileUploadRequest) throws BimfaceException {
        return this.fileService.upload(fileUploadRequest);
    }

    public FileBean upload(String name, Long contentLength, InputStream inputStream) throws BimfaceException {
        return this.upload(name, null, contentLength, inputStream);
    }

    public FileBean upload(String name, String sourceId, Long contentLength, InputStream inputStream) throws BimfaceException {
        return this.fileService.upload(new FileUploadRequest(name, sourceId, contentLength, inputStream));
    }

    public FileBean upload(String name, String url) throws BimfaceException {
        return this.upload(name, null, url);
    }

    public FileBean upload(String name, String sourceId, String url) throws BimfaceException {
        return this.fileService.upload(new FileUploadRequest(name, sourceId, url));
    }

    @Deprecated
    public FileBean getFileMetadata(Long fileId) throws BimfaceException {
        return this.fileService.getFileMetadata(fileId);
    }

    public FileBean getFile(Long fileId) throws BimfaceException {
        return this.fileService.getFile(fileId);
    }

    public List<FileBean> getFiles(FileBatchQueryRequest request) throws BimfaceException {
        return this.fileService.getFiles(request);
    }

    public FileUploadStatusBean getFileUploadStatus(Long fileId) throws BimfaceException {
        return this.fileService.getFileUploadStatus(fileId);
    }

    public void deleteFile(Long fileId) throws BimfaceException {
        this.fileService.deleteFile(fileId);
    }

    public UploadPolicyBean getPolicy(String name) throws BimfaceException {
        return this.getPolicy(name, null);
    }

    public UploadPolicyBean getPolicy(String name, String sourceId) throws BimfaceException {
        return this.fileService.getPolicy(name, sourceId);
    }

    public FileBean uploadByPolicy(String name, Long contentLength, InputStream inputStream) throws BimfaceException {
        return this.uploadByPolicy(name, null, contentLength, inputStream);
    }

    public FileBean uploadByPolicy(String name, String sourceId, Long contentLength, InputStream inputStream) throws BimfaceException {
        return this.fileService.uploadByPolicy(name, sourceId, contentLength, inputStream);
    }

    public String getDownloadUrl(Long fileId) throws BimfaceException {
        return this.downloadService.getDownloadUrl(fileId);
    }

    public String getDownloadUrl(Long fileId, String fileName) throws BimfaceException {
        return this.downloadService.getDownloadUrl(fileId, fileName);
    }

    public InputStream download(Long fileId, String fileName) throws BimfaceException {
        return this.downloadService.getFileContent(fileId, fileName);
    }

    @Deprecated
    public List<String> getElements(Long fileId, String categoryId, String family, String familyType) throws BimfaceException {
        return this.elementService.getElements(fileId, null, null, categoryId, family, familyType);
    }

    @Deprecated
    public List<String> getElements(Long fileId, String floor, String specialty, String categoryId, String family, String familyType) throws BimfaceException {
        return this.elementService.getElements(fileId, floor, specialty, categoryId, family, familyType);
    }

    @Deprecated
    public ElementsWithBoundingBox getIntegrateElements(Long integrateId, String floor, String specialty, String categoryId, String family, String familyType) throws BimfaceException {
        return this.elementService.getIntegrateElements(integrateId, floor, specialty, categoryId, family, familyType);
    }

    public FileTranslateBean translate(FileTranslateRequest fileTranslateRequest) throws BimfaceException {
        return this.translateService.translate(fileTranslateRequest);
    }

    public FileTranslateBean translate(Long fileId) throws BimfaceException {
        FileTranslateRequest fileTranslateRequest = new FileTranslateRequest();
        TranslateSource source = new TranslateSource();
        source.setFileId(fileId);
        fileTranslateRequest.setSource(source);
        return this.translate(fileTranslateRequest);
    }

    public FileTranslateBean translate(Long fileId, String callback) throws BimfaceException {
        FileTranslateRequest fileTranslateRequest = new FileTranslateRequest();
        fileTranslateRequest.setCallback(callback);
        TranslateSource source = new TranslateSource();
        source.setFileId(fileId);
        fileTranslateRequest.setSource(source);
        return this.translateService.translate(fileTranslateRequest);
    }

    public FileTranslateBean getTranslate(Long fileId) throws BimfaceException {
        return this.translateService.getTranslate(fileId);
    }

    public PagedList<FileTranslateDetailBean> getTranslates(TranslateQueryRequest translateQueryRequest) throws BimfaceException {
        return this.translateService.getTranslates(translateQueryRequest);
    }

    @Deprecated
    public ModelCompareBean compare(ModelCompareRequest modelCompareRequest) throws BimfaceException {
        return this.compareService.compare(modelCompareRequest);
    }

    public ModelCompareBean compareV2(CompareRequest compareRequest) throws BimfaceException {
        return this.compareService.compareV2(compareRequest);
    }

    public ModelCompareBean getCompareInfo(Long compareId) throws BimfaceException {
        return this.compareService.getCompareInfo(compareId);
    }

    public PagedList<ModelCompareBean> getCompares(ModelCompareQueryRequest modelCompareQueryRequest) throws BimfaceException {
        return this.compareService.getCompares(modelCompareQueryRequest);
    }

    public void deleteCompare(Long compareId) throws BimfaceException {
        this.compareService.deleteCompare(compareId);
    }

    public List<ModelCompareTree.SpecialtyNode> getCompareResult(Long compareId) throws BimfaceException {
        return this.compareService.getCompareResult(compareId);
    }

    public ModelCompareChange getCompareElementDiff(CompareElementRequest compareElementRequest) throws BimfaceException {
        return this.compareService.getCompareElementDiff(compareElementRequest);
    }

    public String getViewTokenByIntegrateId(Long integrateId) throws BimfaceException {
        return this.viewTokenService.getViewTokenByIntegrateId(integrateId);
    }

    public String getViewTokenByCompareId(Long compareId) throws BimfaceException {
        return this.viewTokenService.getViewTokenByCompareId(compareId);
    }

    public String getViewTokenByFileId(Long fileId) throws BimfaceException {
        return this.viewTokenService.getViewTokenByFileId(fileId);
    }

    public ShareLinkBean createTranslateShare(Long fileId, Integer activeHours) throws BimfaceException {
        return this.shareLinkService.createShare(fileId, activeHours);
    }

    public ShareLinkBean createTranslateShare(Long fileId, String expireDate, Boolean needPassword) throws BimfaceException {
        return this.shareLinkService.createShare(fileId, expireDate, needPassword);
    }

    public ShareLinkBean createTranslateShare(Long fileId) throws BimfaceException {
        return this.shareLinkService.createShare(fileId);
    }

    public void deleteTranslateShare(Long fileId) throws BimfaceException {
        this.shareLinkService.deleteShare(fileId);
    }

    public ShareLinkBean createIntegrateShare(Long integrateId, Integer activeHours) throws BimfaceException {
        return this.shareLinkService.createIntegrateShare(integrateId, activeHours);
    }

    public ShareLinkBean createIntegrateShare(Long integrateId, String expireDate, Boolean needPassword) throws BimfaceException {
        return this.shareLinkService.createIntegrateShare(integrateId, expireDate, needPassword);
    }

    public ShareLinkBean createIntegrateShare(Long integrateId) throws BimfaceException {
        return this.shareLinkService.createIntegrateShare(integrateId);
    }

    public void deleteIntegrateShare(Long integrateId) throws BimfaceException {
        this.shareLinkService.deleteIntegrateShare(integrateId);
    }

    public BatchDeleteResultBean<Long> batchDeteleShare(List<Long> sourceIds) throws BimfaceException {
        return this.shareLinkService.batchDeteleShare(sourceIds);
    }

    public ShareLinkBean getShareLink(String token) throws BimfaceException {
        return this.shareLinkService.getShareLink(token);
    }

    public ShareLinkBean getTranslateShare(Long fileId) throws BimfaceException {
        return this.shareLinkService.getTranslateShare(fileId);
    }

    public ShareLinkBean getIntegrateShare(Long integrateId) throws BimfaceException {
        return this.shareLinkService.getIntegrateShare(integrateId);
    }

    public PagedList<ShareLinkBean> shares(Integer pageNo, Integer pageSize) throws BimfaceException {
        return this.shareLinkService.shareList(pageNo, pageSize);
    }

    @Deprecated
    public Property getProperty(Long fileId, String elementId) throws BimfaceException {
        return this.propertyService.getElementProperty(fileId, elementId);
    }

    @Deprecated
    public Property getIntegrationProperty(Long integrateId, Long fileId, String elementId) throws BimfaceException {
        return this.propertyService.getIntegrationElementProperty(integrateId, fileId, elementId);
    }

    @Deprecated
    public List<Category> getCategory(Long fileId) throws BimfaceException {
        return this.categoryTreeService.getCategoryTree(fileId);
    }

    @Deprecated
    public List<Tree.TreeNode> getCategoryV2(Long fileId) throws BimfaceException {
        return this.categoryTreeService.getCategoryTreeV2(fileId);
    }

    @Deprecated
    public SpecialtyTree getSpecialtyTree(Long integrateId) throws BimfaceException {
        return this.categoryTreeService.getSpecialtyTree(integrateId);
    }

    @Deprecated
    public FloorTree getFloorTree(Long integrateId) throws BimfaceException {
        return this.categoryTreeService.getFloorTree(integrateId);
    }

    public FileIntegrateBean integrate(FileIntegrateRequest request) throws BimfaceException {
        return this.integrateService.integrate(request);
    }

    public FileIntegrateBean getIntegrate(Long integrateId) throws BimfaceException {
        return this.integrateService.getIntegrate(integrateId);
    }

    public PagedList<FileIntegrateDetailBean> getIntegrates(IntegrateQueryRequest integrateQueryRequest) throws BimfaceException {
        return this.integrateService.getIntegrates(integrateQueryRequest);
    }

    public void deleteIntegrate(Long integrateId) throws BimfaceException {
        this.integrateService.deleteIntegrate(integrateId);
    }

    public boolean validateSignature(String signature, String id, String status, String nonce) throws BimfaceException {
        return this.signatureService.validate(signature, id, status, nonce);
    }

    public DatabagDerivativeBean generateOfflineDatabag(OfflineDatabagRequest offlineDatabagRequest) throws BimfaceException {
        return this.offlineDatabagService.generateOfflineDatabag(offlineDatabagRequest);
    }

    public List<? extends DatabagDerivativeBean> queryOfflineDatabag(OfflineDatabagRequest offlineDatabagRequest) throws BimfaceException {
        return this.offlineDatabagService.queryOfflineDatabag(offlineDatabagRequest);
    }

    public String getOfflineDatabagUrl(OfflineDatabagRequest offlineDatabagRequest) throws BimfaceException {
        return this.offlineDatabagService.getOfflineDatabagUrl(offlineDatabagRequest);
    }

    public Credential getCredential() {
        return this.credential;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public AccessTokenService getAccessTokenService() {
        return this.accessTokenService;
    }

    public FileService getFileService() {
        return this.fileService;
    }

    public TranslateService getTranslateService() {
        return this.translateService;
    }

    public ViewTokenService getViewTokenService() {
        return this.viewTokenService;
    }

    public ShareLinkService getShareLinkService() {
        return this.shareLinkService;
    }

    public PropertyService getPropertyService() {
        return this.propertyService;
    }

    public SignatureService getSignatureService() {
        return this.signatureService;
    }

    public DownloadService getDownloadService() {
        return this.downloadService;
    }

    public ElementService getElementService() {
        return this.elementService;
    }

    public CategoryTreeService getCategoryService() {
        return this.categoryTreeService;
    }

    public OfflineDatabagService getOfflineDatabagService() {
        return this.offlineDatabagService;
    }

    public AppendFileBean createAppendFile(String name, String sourceId, Long length) throws BimfaceException {
        return this.fileService.createAppendFile(name, sourceId, length);
    }

    public AppendFileBean queryAppendFile(Long appendFileId) throws BimfaceException {
        return this.fileService.queryAppendFile(appendFileId);
    }

    public AppendFileBean uploadAppendFile(InputStream inputStream, Long appendFileId) throws BimfaceException {
        return this.fileService.uploadAppendFile(inputStream, appendFileId);
    }

    @Deprecated
    public List<Floor> getFileFloors(Long fileId) throws BimfaceException {
        return this.getFileFloors(fileId, false, false);
    }

    public List<Floor> getFileFloors(Long fileId, Boolean includeArea, Boolean includeRoom) throws BimfaceException {
        return this.floorService.getFileFloors(fileId, includeArea, includeRoom);
    }

    @Deprecated
    public List<Floor> getIntegrateFloors(Long integrateId) throws BimfaceException {
        return this.getIntegrateFloors(integrateId, false, false);
    }

    public List<Floor> getIntegrateFloors(Long integrateId, Boolean includeArea, Boolean includeRoom) throws BimfaceException {
        return this.floorService.getIntegrateFloors(integrateId, includeArea, includeRoom);
    }

    @Deprecated
    public List<String> getElementIdsV2(Long fileId, String specialty, String floor, String categoryId, String family, String familyType) throws BimfaceException {
        QueryElementIdsRequest queryElementIdsRequest = new QueryElementIdsRequest(specialty, floor, categoryId, family, familyType);
        return this.getElementIdsV2(fileId, queryElementIdsRequest);
    }

    public List<String> getElementIdsV2(Long fileId, QueryElementIdsRequest queryElementIdsRequest) throws BimfaceException {
        return this.elementService.getElementIdsV2(fileId, queryElementIdsRequest);
    }

    public List<Map<String, Object>> getSingleModelFileIdFloorsMapping(List<String> fileIds, Boolean includeArea, Boolean includeRoom) throws BimfaceException {
        return this.floorService.getSingleModelFileIdFloorsMapping(fileIds, includeArea, includeRoom);
    }

    public Property getSingleModelElementV2(Long fileId, String elementId) throws BimfaceException {
        return this.getSingleModelElementV2(fileId, elementId, false);
    }

    public Property getSingleModelElementV2(Long fileId, String elementId, boolean includeOverrides) throws BimfaceException {
        return this.elementService.getSingleModelElementV2(fileId, elementId, includeOverrides);
    }

    @Deprecated
    public List<Property> getSingleModelElementsV2(Long fileId, List<String> elementIds) throws BimfaceException {
        return this.elementService.getSingleModelElementsV2(fileId, elementIds);
    }

    public List<Property> getSingleModelElementsV2(Long fileId, List<String> elementIds, List<ElementPropertyFilterRequest.GroupAndKeysPair> filter, boolean includeOverrides) throws BimfaceException {
        return this.elementService.getSingleModelElementsV2(fileId, elementIds, filter, includeOverrides);
    }

    public Property getElementPropertyV2(Long fileId, List<String> elementIds) throws BimfaceException {
        return this.propertyService.getSingleModelElementPropertyV2(fileId, elementIds, false);
    }

    public Property getElementPropertyV2(Long fileId, List<String> elementIds, Boolean includeOverrides) throws BimfaceException {
        return this.propertyService.getSingleModelElementPropertyV2(fileId, elementIds, includeOverrides);
    }

    public List<MaterialInfo> getSingleModelMaterials(Long fileId, String elementId) throws BimfaceException {
        return this.elementService.getSingleModelMaterials(fileId, elementId);
    }

    public List<View> getSingleModelViews(Long fileId) throws BimfaceException {
        return this.dataService.getSingleModelViews(fileId);
    }

    @Deprecated
    public List<Room> getSingleModelRooms(Long fileId, String floorId) throws BimfaceException {
        return this.getSingleModelRooms(fileId, floorId, null, null, null);
    }

    public List<Room> getSingleModelRooms(Long fileId, String floorId, String elementId, ToleranceType roomToleranceZ, ToleranceType roomToleranceXY) throws BimfaceException {
        return this.dataService.getSingleModelRooms(fileId, floorId, elementId, roomToleranceZ, roomToleranceXY);
    }

    public Room getSingleModelRoom(Long fileId, String roomId) throws BimfaceException {
        return this.dataService.getSingleModelRoom(fileId, roomId);
    }

    public List<Area> getSingleModelAreas(Long fileId, String floorId) throws BimfaceException {
        return this.dataService.getSingleModelAreas(fileId, floorId);
    }

    public Area getSingleModelArea(Long fileId, String areaId) throws BimfaceException {
        return this.dataService.getSingleModelArea(fileId, areaId);
    }

    public List<Tree.TreeNode> getSingleModelTreeV2(Long fileId, FileTreeRequestBody requestBody) throws BimfaceException {
        return this.dataService.getSingleModelTreeV2(fileId, requestBody);
    }

    public Tree getSingleModelCustomizedTree(Long fileId, FileTreeRequestBody requestBody) throws BimfaceException {
        return this.dataService.getSingleModelCustomizedTree(fileId, requestBody);
    }

    public List<Link> getSingleModelLinks(Long fileId) throws BimfaceException {
        return this.dataService.getSingleModelLinks(fileId);
    }

    @Deprecated
    public List<DrawingSheet> getSingleModelDrawingSheets(Long fileId) throws BimfaceException {
        return this.getSingleModelDrawingSheets(fileId, null);
    }

    public List<DrawingSheet> getSingleModelDrawingSheets(Long fileId, String elementId) throws BimfaceException {
        return this.dataService.getSingleModelDrawingSheets(fileId, elementId);
    }

    public Object getSingleModelModelInfo(Long fileId) throws BimfaceException {
        return this.dataService.getSingleModelModelInfo(fileId);
    }

    public List<ElementIdWithName> getSingleModelChildElementIds(Long fileId, String elementId) throws BimfaceException {
        return this.dataService.getSingleModelChildElementIds(fileId, elementId);
    }

    public String updateSingleModelElementProperties(Long fileId, String elementId, List<PropertyGroup> propertyGroups) throws BimfaceException {
        return this.dataService.updateSingleModelElementProperties(fileId, elementId, propertyGroups);
    }

    public String deleteSingleModelElementProperties(Long fileId, String elementId, List<PropertyGroup> propertyGroups) throws BimfaceException {
        return this.dataService.deleteSingleModelElementProperties(fileId, elementId, propertyGroups);
    }

    @Deprecated
    public ElementsWithBoundingBox getIntegrateModelElementIds(Long integrateId, String specialty, String roomId, String floor, String categoryId, String family, String familyType, String systemType) throws BimfaceException {
        QueryElementIdsRequest queryElementIdsRequest = new QueryElementIdsRequest(specialty, floor, categoryId, family, familyType);
        queryElementIdsRequest.setRoomId(roomId);
        queryElementIdsRequest.setSystemType(systemType);
        return this.getIntegrateModelElementIds(integrateId, queryElementIdsRequest);
    }

    public ElementsWithBoundingBox getIntegrateModelElementIds(Long integrateId, QueryElementIdsRequest queryElementIdsRequest) throws BimfaceException {
        return this.dataService.getIntegrateModelElementIds(integrateId, queryElementIdsRequest);
    }

    public String updateIntegrateModelElementProperties(Long integrateId, String fileIdHash, String elementId, List<PropertyGroup> propertyGroups) throws BimfaceException {
        return this.dataService.updateIntegrateModelElementProperties(integrateId, fileIdHash, elementId, propertyGroups);
    }

    public String deleteIntegrateModelElementProperties(Long integrateId, String fileIdHash, String elementId, List<PropertyGroup> propertyGroups) throws BimfaceException {
        return this.dataService.deleteIntegrateModelElementProperties(integrateId, fileIdHash, elementId, propertyGroups);
    }

    public Property getIntegrateModelElement(Long integrateId, String fileIdHash, String elementId) throws BimfaceException {
        return this.dataService.getIntegrateModelElement(integrateId, fileIdHash, elementId, false);
    }

    public Property getIntegrateModelElement(Long integrateId, String fileIdHash, String elementId, Boolean includeOverrides) throws BimfaceException {
        return this.dataService.getIntegrateModelElement(integrateId, fileIdHash, elementId, includeOverrides);
    }

    public Property getIntegrateModelElement(Long integrateId, String elementId) throws BimfaceException {
        return this.dataService.getIntegrateModelElement(integrateId, elementId);
    }

    public List<MaterialInfo> getIntegrateModelElementMaterials(Long integrateId, String fileIdHash, String elementId) throws BimfaceException {
        return this.dataService.getIntegrateModelElementMaterials(integrateId, fileIdHash, elementId);
    }

    public Tree getIntegrateModelTree(Long integrateId, String treeType, List<String> desiredHierarchy, IntegrationTreeOptionalRequestBody requestBody) throws BimfaceException {
        return this.dataService.getIntegrateModelTree(integrateId, treeType, desiredHierarchy, requestBody);
    }

    public List<FileViews> getIntegrateModelFileViews(Long integrateId, String viewType) throws BimfaceException {
        return this.dataService.getIntegrateModelFileViews(integrateId, viewType);
    }

    @Deprecated
    public List<Room> getIntegrateModelRooms(Long integrateId, String floorId) throws BimfaceException {
        return this.getIntegrateModelRooms(integrateId, floorId, null, null, null);
    }

    public List<Room> getIntegrateModelRooms(Long integrateId, String floorId, String elementId, ToleranceType roomToleranceZ, ToleranceType roomToleranceXY) throws BimfaceException {
        return this.dataService.getIntegrateModelRooms(integrateId, floorId, elementId, roomToleranceZ, roomToleranceXY);
    }

    public Room getIntegrateModelRoom(Long integrateId, String roomId) throws BimfaceException {
        return this.dataService.getIntegrateModelRoom(integrateId, roomId);
    }

    public List<Area> getIntegrateModelAreas(Long integrateId, String floorId) throws BimfaceException {
        return this.dataService.getIntegrateModelAreas(integrateId, floorId);
    }

    public Area getIntegrateModelArea(Long integrateId, String areaId) throws BimfaceException {
        return this.dataService.getIntegrateModelArea(integrateId, areaId);
    }

    public List<IntegrateFileData> getIntegrateFiles(Long integrateId) throws BimfaceException {
        return this.dataService.getIntegrateFiles(integrateId);
    }

    public String getIntegrateModelViewToken(Long integrateId, String fileId) throws BimfaceException {
        return this.dataService.getIntegrateModelViewToken(integrateId, fileId);
    }

    public List<SegmentGroupDto> getIntegrateModelSegmentGroups(Long integrateId) throws BimfaceException {
        return this.dataService.getIntegrateModelSegmentGroups(integrateId);
    }

    public List<SegmentGroupDto> getIntegrateModelSegmentTree(Long integrateId) throws BimfaceException {
        return this.dataService.getIntegrateModelSegmentTree(integrateId);
    }

    public List<SegmentDto> getIntegrateModelSegments(Long integrateId, String segmentGroupId) throws BimfaceException {
        return this.dataService.getIntegrateModelSegments(integrateId, segmentGroupId);
    }

    public List<String> getIntegrateModelSegmentElementIds(Long integrateId, String segmentId) throws BimfaceException {
        return this.dataService.getIntegrateModelSegmentElementIds(integrateId, segmentId);
    }

    public Property getIntegrateModelCommonElementProperties(Long integrateId, List<FileIdHashWithElementIds> fileIdHashWithElementIds) throws BimfaceException {
        return this.dataService.getIntegrateModelCommonElementProperties(integrateId, fileIdHashWithElementIds, false);
    }

    public Property getIntegrateModelCommonElementProperties(Long integrateId, List<FileIdHashWithElementIds> fileIdHashWithElementIds, Boolean includeOverrides) throws BimfaceException {
        return this.dataService.getIntegrateModelCommonElementProperties(integrateId, fileIdHashWithElementIds, includeOverrides);
    }

    public void addAssociations(String integrateId, String fromIntegrationId, String fromBusinessType, String fromBusinessFlag, BusinessAssociationRequest request) throws BimfaceException {
        this.dataService.addAssociations(integrateId, fromIntegrationId, fromBusinessType, fromBusinessFlag, request);
    }

    public List<ElementBusinessAssociation> getAssociationsByElementId(String integrateId, String elementId, String businessType, String businessFlag) throws BimfaceException {
        return this.dataService.getAssociationsByElementId(integrateId, elementId, businessType, businessFlag);
    }

    public List<BusinessElementAssociation> getAssociationsByBusinessId(String integrateId, String businessType, String businessId) throws BimfaceException {
        return this.dataService.getAssociationsByBusinessId(integrateId, businessType, businessId);
    }

    public void deleteAssociationsByElementId(String integrateId, String elementId, String businessType, String businessFlag, List<String> businessIds) throws BimfaceException {
        this.dataService.deleteAssociationsByElementId(integrateId, elementId, businessType, businessFlag, businessIds);
    }

    public void deleteAssociationsByBusinessId(String integrateId, String businessType, String businessId) throws BimfaceException {
        this.dataService.deleteAssociationsByBusinessId(integrateId, businessType, businessId);
    }

    public void deleteAssociationsByElements(String integrateId, String businessType, String businessFlag, List<String> elementIds) throws BimfaceException {
        this.dataService.deleteAssociationsByElements(integrateId, businessType, businessFlag, elementIds);
    }

    public void deleteAssociationsByBizIds(String integrateId, String businessType, String businessFlag, List<String> businessIds) throws BimfaceException {
        this.dataService.deleteAssociationsByBizIds(integrateId, businessType, businessFlag, businessIds);
    }

    public ModelCompareChange getModelCompareElementChange(Long comparisonId, Long previousFileId, String previousElementId, Long followingFileId, String followingElementId) throws BimfaceException {
        return this.dataService.getModelCompareElementChange(comparisonId, previousFileId, previousElementId, followingFileId, followingElementId);
    }

    public Tree getModelCompareTree(Long comparisonId) throws BimfaceException {
        return this.dataService.getModelCompareTree(comparisonId);
    }

    public Pagination<ModelCompareDiff> getModelCompareResult(Long comparisonId, String family, String elementName, Integer page, Integer pageSize) throws BimfaceException {
        return this.dataService.getModelCompareResult(comparisonId, family, elementName, page, pageSize);
    }

    public MaterialOverrideSetVO getMaterialOverrideSet(Long id) throws BimfaceException {
        return this.dataService.getMaterialOverrideSet(id);
    }

    public List<String> getRfaFamilyPropertyNames(Long rfaFileId) throws BimfaceException {
        return this.dataService.getRfaFamilyPropertyNames(rfaFileId);
    }

    public List<RfaFamilyType> getRfaFamilyTypes(Long rfaFileId) throws BimfaceException {
        return this.dataService.getRfaFamilyTypes(rfaFileId);
    }

    public RfaFamilyTypeProperty getRfaFamilyTypeProperty(Long rfaFileId, String familyTypeGuid) throws BimfaceException {
        return this.dataService.getRfaFamilyTypeProperty(rfaFileId, familyTypeGuid);
    }

    public List<SearchElementIdsResp> getElements(String requestBody) throws BimfaceException {
        return this.dataService.getElements(requestBody);
    }

    public List<SearchRoomIdsResp> getRooms(String requestBody) throws BimfaceException {
        return this.dataService.getRooms(requestBody);
    }

    public List<SearchAreaIdsResp> getAreas(String requestBody) throws BimfaceException {
        return this.dataService.getAreas(requestBody);
    }

    public List<PropertyValuesResp> getPropertyValues(List<String> targetIds, String targetType, List<String> properties) throws BimfaceException {
        return this.dataService.getPropertyValues(targetIds, targetType, properties);
    }

    public String getPaginationContextId() throws BimfaceException {
        return this.dataService.getPaginationContextId();
    }

    public String getFileThumbnailUrl(Long fileId, Integer size) throws BimfaceException {
        return this.dataService.getFileThumbnailUrl(fileId, size);
    }

    public String getDwgPdfUrl(Long dwgFileId) throws BimfaceException {
        return this.dataService.getDwgPdfUrl(dwgFileId);
    }

    public String getDwgPreviewImageUrl(Long dwgFileId, String layoutName) throws BimfaceException {
        return this.dataService.getDwgPreviewImageUrl(dwgFileId, layoutName);
    }

    public String getFileDataBagRootUrl(Long fileId) throws BimfaceException {
        return this.databagService.getFileDataBagRootUrl(fileId);
    }

    public String getIntegrateDatabagRootUrl(Long integrateId) throws BimfaceException {
        return this.databagService.getIntegrateDatabagRootUrl(integrateId);
    }

    public InputStream getFileDatabagContent(Long fileId) throws BimfaceException {
        return this.databagService.getFileDatabagContent(fileId);
    }

    public Long getFileDatabagSize(Long fileId) throws BimfaceException {
        return this.databagService.getFileDatabagSize(fileId);
    }
}

